/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Pareto
extends AbstractDistribution {
    private double location;
    private double shape;
    private double RECIPC;
    private double CAC;

    public Pareto(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.location = d;
        this.shape = d2;
        this.RECIPC = 1.0 / d2;
        this.CAC = d2 * Math.pow(d, d2);
    }

    public double cdf(double d) {
        if (d < this.location) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return 1.0 - Math.pow(this.location / d, this.shape);
    }

    public double getLocation() {
        return this.location;
    }

    public double getShape() {
        return this.shape;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return this.location;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.location / Math.pow(1.0 - d, this.RECIPC);
    }

    public double mean() {
        return this.shape > 1.0 ? this.shape * this.location / (this.shape - 1.0) : Double.NaN;
    }

    public double pdf(double d) {
        if (d < this.location) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return this.CAC / Math.pow(d, this.shape + 1.0);
    }

    public double random() {
        return this.location / Math.pow(1.0 - this.rand.nextDouble(), this.RECIPC);
    }

    public String toString() {
        return new String("Pareto distribution: location = " + this.location + ", shape = " + this.shape + ".");
    }

    public double variance() {
        return this.shape > 2.0 ? this.shape * this.location * this.location / ((this.shape - 1.0) * (this.shape - 1.0) * (this.shape - 2.0)) : Double.NaN;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            Pareto pareto = new Pareto(1.0, 2.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = pareto.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, pareto, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

