/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.distributions.Normal;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Lognormal
extends AbstractDistribution {
    private Normal N;

    public Lognormal() {
        this(0.0, 1.0);
    }

    public Lognormal(double d, double d2) {
        this.N = new Normal(d, d2);
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        return this.N.cdf(Math.log(d));
    }

    public double getLocation() {
        return this.N.mean();
    }

    public double getScale() {
        return this.N.sd();
    }

    public double inverseCdf(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.exp(this.N.inverseCdf(d));
    }

    public double mean() {
        return Math.exp(this.N.mean() + 0.5 * this.N.variance());
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        return this.N.pdf(Math.log(d)) / d;
    }

    public double random() {
        return Math.exp(this.N.random());
    }

    public String toString() {
        return new String("Lognormal distribution: location = " + this.N.mean() + ", scale = " + this.N.sd() + ".");
    }

    public double variance() {
        double d = this.N.mean() + this.N.variance();
        return Math.exp(d + d) - Math.exp(this.N.mean() + d);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 5.0;
            double d2 = 0.6;
            Lognormal lognormal = new Lognormal(d, d2);
            int n = 10000;
            lognormal = new Lognormal(-10.0, 99.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = lognormal.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, lognormal, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

