/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class ExtremeValue
extends AbstractDistribution {
    static final double C1 = 1.6449340668482264;
    static final double C2 = Math.sqrt(1.6449340668482264);
    private double location;
    private double scale;

    public ExtremeValue(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.location = d;
        this.scale = d2;
    }

    public double cdf(double d) {
        return Math.exp(-Math.exp(-(d - this.location) / this.scale));
    }

    public double getLocation() {
        return this.location;
    }

    public double getScale() {
        return this.scale;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.location - this.scale * Math.log(Math.log(1.0 / d));
    }

    public double mean() {
        return this.location + this.scale * 0.577215664901533;
    }

    public double pdf(double d) {
        double d2 = -(d - this.location) / this.scale;
        return Math.exp(d2) * Math.exp(-Math.exp(d2)) / this.scale;
    }

    public double random() {
        return this.location - this.scale * Math.log(-Math.log(1.0 - this.rand.nextDouble()));
    }

    public double sd() {
        return this.scale * C2;
    }

    public String toString() {
        return new String("Extreme value distribution: location = " + this.location + ", scale = " + this.scale + ".");
    }

    public double variance() {
        return this.scale * this.scale * 1.6449340668482264;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 5.0;
            double d2 = 1.5;
            ExtremeValue extremeValue = new ExtremeValue(d, d2);
            int n = 10000;
            extremeValue = new ExtremeValue(5.0, 1.5);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = extremeValue.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, extremeValue, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

