/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.distributions.Normal;
import jsc.numerical.Function;
import jsc.numerical.Integration;
import jsc.numerical.NumericalException;
import jsc.numerical.Roots;
import jsc.util.Maths;

public abstract class AbstractContinuousDistribution
extends AbstractDistribution {
    protected double minX;
    protected double maxX;
    protected boolean open;
    protected double tolerance = 1.0E-6;

    public AbstractContinuousDistribution(double d, double d2, boolean bl) {
        if (d >= d2) {
            throw new IllegalArgumentException("Invalid variate range: " + d + " to " + d2 + ".");
        }
        this.minX = d;
        this.maxX = d2;
        this.open = bl;
    }

    public double cdf(double d) {
        if (d < this.minX || d > this.maxX) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == this.minX) {
            return 0.0;
        }
        if (d == this.maxX) {
            return 1.0;
        }
        try {
            double d2 = Integration.integrate(new PDF(), this.minX, d, this.open, this.tolerance, 20);
            if (d2 > 1.0) {
                return 1.0;
            }
            if (d2 < 0.0) {
                return 0.0;
            }
            return d2;
        }
        catch (NumericalException numericalException) {
            throw new RuntimeException("Cannot calculate cdf to required accuracy. " + numericalException.getMessage());
        }
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinX() {
        return this.minX;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return this.minX;
        }
        if (d == 1.0) {
            return this.maxX;
        }
        CdfMinusP cdfMinusP = new CdfMinusP(d);
        try {
            if (Double.isInfinite(this.minX) || Double.isInfinite(this.maxX)) {
                double d2 = this.mean();
                double d3 = this.sd();
                return Roots.secant(cdfMinusP, Math.max(this.minX, d2 - d3), Math.min(this.maxX, d2 + d3), this.tolerance, 1000);
            }
            return Roots.bisection(cdfMinusP, this.minX, this.maxX, this.tolerance, 1000);
        }
        catch (NumericalException numericalException) {
            throw new RuntimeException("Cannot calculate inverse of cdf. " + numericalException.getMessage());
        }
    }

    public double mean() {
        try {
            return Integration.integrate(new MeanIntegrand(), this.minX, this.maxX, this.open, this.tolerance, 20);
        }
        catch (NumericalException numericalException) {
            throw new RuntimeException("Cannot calculate mean. " + numericalException.getMessage());
        }
    }

    public double moment(int n) {
        return this.moment(n, 0.0);
    }

    public double moment(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid moment order.");
        }
        if (n == 0) {
            return 1.0;
        }
        try {
            return Integration.integrate(new MomentIntegrand(n, d), this.minX, this.maxX, this.open, this.tolerance, 20);
        }
        catch (NumericalException numericalException) {
            throw new RuntimeException("Cannot calculate moment. " + numericalException.getMessage());
        }
    }

    public abstract double pdf(double var1);

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public void setTolerance(double d) {
        this.tolerance = Math.abs(d);
    }

    public double variance() {
        return this.moment(2, this.mean());
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 1.0;
            double d2 = 2.0;
            Normal normal = new Normal(d, d2);
            TestNormal testNormal = new TestNormal(d, d2);
            System.out.println("Normal distribution: mean = " + d + " s.d. = " + d2);
            System.out.println("Test: mean = " + testNormal.mean() + " s.d. = " + testNormal.sd());
            double[] dArray = new double[]{-10000.0, -100.0, -50.0, -25.0, -10.0, -1.0, -0.5, -0.1, 0.0, 0.1, 0.5, 1.0, 10.0, 25.0, 50.0, 100.0, 1000.0, 100000.0};
            int n = 0;
            while (n < dArray.length) {
                System.out.println("Normal: X=" + dArray[n] + " cdf=" + normal.cdf(dArray[n]) + " X=" + normal.inverseCdf(normal.cdf(dArray[n])));
                System.out.println("  Test: X=" + dArray[n] + " cdf=" + testNormal.cdf(dArray[n]) + " X=" + testNormal.inverseCdf(testNormal.cdf(dArray[n])));
                ++n;
            }
        }

        static class TestBeta
        extends AbstractContinuousDistribution {
            private double p;
            private double q;
            private double logB;

            TestBeta(double d, double d2) {
                super(0.0, 1.0, false);
                this.p = d;
                this.q = d2;
                this.logB = Maths.lnB(d, d2);
            }

            public double pdf(double d) {
                if (d > 0.0 && d < 1.0 || d == 0.0 && this.p >= 1.0 || d == 1.0 && this.q >= 1.0) {
                    if (d == 0.0) {
                        return this.p == 1.0 ? this.q : 0.0;
                    }
                    if (d == 1.0) {
                        return this.q == 1.0 ? this.p : 0.0;
                    }
                    return Math.exp((this.p - 1.0) * Math.log(d) + (this.q - 1.0) * Math.log(1.0 - d) - this.logB);
                }
                throw new IllegalArgumentException("Invalid variate-value.");
            }
        }

        static class TestNormal
        extends AbstractContinuousDistribution {
            private double mean;
            private double sd;

            TestNormal(double d, double d2) {
                super(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
                this.mean = d;
                this.sd = d2;
            }

            public double pdf(double d) {
                double d2 = (d - this.mean) / this.sd;
                return Math.exp(-0.5 * d2 * d2) / (Normal.SQRPI2 * this.sd);
            }
        }
    }

    class PDF
    implements Function {
        PDF() {
        }

        public double function(double d) {
            return AbstractContinuousDistribution.this.pdf(d);
        }
    }

    class MomentIntegrand
    implements Function {
        int r;
        double a;

        public MomentIntegrand(int n, double d) {
            this.r = n;
            this.a = d;
        }

        public double function(double d) {
            double d2;
            double d3 = d2 = d - this.a;
            int n = 1;
            while (n < this.r) {
                d3 *= d2;
                ++n;
            }
            return d3 * AbstractContinuousDistribution.this.pdf(d);
        }
    }

    class MeanIntegrand
    implements Function {
        MeanIntegrand() {
        }

        public double function(double d) {
            return d * AbstractContinuousDistribution.this.pdf(d);
        }
    }

    class CdfMinusP
    implements Function {
        double p;

        public CdfMinusP(double d) {
            this.p = d;
        }

        public double function(double d) {
            return AbstractContinuousDistribution.this.cdf(d) - this.p;
        }
    }
}

