/*
 * Decompiled with CFR 0.152.
 */
package jsc.datastructures;

import java.util.Vector;
import jsc.util.Arrays;
import jsc.util.Sort;

public class GroupedData {
    private int groupCount;
    private int n;
    private Vector groupLabels;
    private double minValue;
    private double maxValue;
    private double[][] groupedData;

    public GroupedData(double[] dArray, String[] stringArray) {
        this.n = dArray.length;
        if (this.n < 1) {
            throw new IllegalArgumentException("No data.");
        }
        if (this.n != stringArray.length) {
            throw new IllegalArgumentException("Arrays not equal length.");
        }
        this.minValue = dArray[0];
        this.maxValue = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] > this.maxValue) {
                this.maxValue = dArray[n];
            }
            if (dArray[n] < this.minValue) {
                this.minValue = dArray[n];
            }
            ++n;
        }
        this.groupLabels = Sort.getLabels(stringArray);
        this.groupCount = this.groupLabels.size();
        this.groupedData = new double[this.groupCount][];
        Vector<Double> vector = new Vector<Double>(this.n);
        int n2 = 0;
        while (n2 < this.groupCount) {
            vector.clear();
            String string = (String)this.groupLabels.get(n2);
            int n3 = 0;
            while (n3 < this.n) {
                if (string.equals(stringArray[n3])) {
                    vector.add(new Double(dArray[n3]));
                }
                ++n3;
            }
            int n4 = vector.size();
            this.groupedData[n2] = new double[n4];
            int n5 = 0;
            while (n5 < n4) {
                this.groupedData[n2][n5] = (Double)vector.get(n5);
                ++n5;
            }
            ++n2;
        }
    }

    public GroupedData(double[] dArray, int[] nArray) {
        this(dArray, Arrays.toStringArray(nArray));
    }

    public Object clone() {
        return this.copy();
    }

    public GroupedData copy() {
        int n = 0;
        String[] stringArray = new String[this.n];
        double[] dArray = new double[this.n];
        int n2 = 0;
        while (n2 < this.groupCount) {
            String string = this.getLabel(n2);
            double[] dArray2 = this.getData(n2);
            int n3 = 0;
            while (n3 < this.getSize(n2)) {
                dArray[n] = dArray2[n3];
                stringArray[n] = string;
                ++n;
                ++n3;
            }
            ++n2;
        }
        return new GroupedData(dArray, stringArray);
    }

    public double[] getData(String string) {
        int n = this.groupLabels.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.groupedData[n];
    }

    public double[] getData() {
        double[] dArray = new double[this.n];
        int n = 0;
        int n2 = 0;
        while (n2 < this.groupCount) {
            double[] dArray2 = this.groupedData[n2];
            int n3 = 0;
            while (n3 < dArray2.length) {
                dArray[n] = dArray2[n3];
                ++n;
                ++n3;
            }
            ++n2;
        }
        return dArray;
    }

    public double[] getData(int n) {
        return this.groupedData[n];
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public String getLabel(int n) {
        return (String)this.groupLabels.get(n);
    }

    public Vector getLabels() {
        return this.groupLabels;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public int getMaxSize() {
        int n = this.groupedData[0].length;
        int n2 = 1;
        while (n2 < this.groupCount) {
            if (this.groupedData[n2].length > n) {
                n = this.groupedData[n2].length;
            }
            ++n2;
        }
        return n;
    }

    public int getMinSize() {
        int n = this.groupedData[0].length;
        int n2 = 1;
        while (n2 < this.groupCount) {
            if (this.groupedData[n2].length < n) {
                n = this.groupedData[n2].length;
            }
            ++n2;
        }
        return n;
    }

    public int getN() {
        return this.n;
    }

    public int getSize(int n) {
        return this.groupedData[n].length;
    }

    public int getSize(String string) {
        int n = this.groupLabels.indexOf(string);
        if (n < 0) {
            return 0;
        }
        return this.groupedData[n].length;
    }

    public int[] getSizes() {
        int[] nArray = new int[this.groupCount];
        int n = 0;
        while (n < this.groupCount) {
            nArray[n] = this.groupedData[n].length;
            ++n;
        }
        return nArray;
    }

    public boolean hasLabel(String string) {
        return this.groupLabels.contains(string);
    }

    public int indexOf(String string) {
        return this.groupLabels.indexOf(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nGrouped data");
        int n = 0;
        while (n < this.getGroupCount()) {
            String string = this.getLabel(n);
            stringBuffer.append("\n" + string);
            double[] dArray = this.getData(n);
            int n2 = 0;
            while (n2 < this.getSize(string)) {
                stringBuffer.append(" " + dArray[n2]);
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"Britain", "Japan", "West Germany", "Italy", "Britain", "Japan", "West Germany", "Italy", "Britain", "Japan", "West Germany", "Italy", "Britain", "Japan", "West Germany", "Italy", "Britain", "Japan", "West Germany", "Britain", "Japan", "West Germany", "Britain", "Japan", "West Germany", "Britain", "West Germany", "Britain", "Britain", "Britain", "Britain", "Britain"};
            double[] dArray = new double[]{21.0, 9.0, 18.0, 41.0, 33.0, 13.0, 35.0, 41.0, 12.0, 6.0, 8.0, 48.0, 28.0, 3.0, 17.0, 34.0, 41.0, 5.0, 22.0, 39.0, 10.0, 20.0, 24.0, 4.0, 37.0, 29.0, 11.0, 30.0, 19.0, 27.0, 38.0, 23.0};
            GroupedData groupedData = new GroupedData(dArray, stringArray2);
            System.out.println(groupedData.getN() + " values, " + groupedData.getGroupCount() + " groups" + " min size = " + groupedData.getMinSize() + " max size = " + groupedData.getMaxSize());
            System.out.println(groupedData.toString());
            GroupedData groupedData2 = groupedData.copy();
            System.out.println(groupedData2.toString());
        }
    }
}

