/*
 * Decompiled with CFR 0.152.
 */
package jsc.curvefitting;

import jsc.curvefitting.FunctionVector;

public class PolynomialFunctionVector
implements FunctionVector {
    private final int degree;
    private final double[] f;

    PolynomialFunctionVector(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Order must be > 0.");
        }
        this.degree = n;
        this.f = new double[1 + n];
        this.f[0] = 1.0;
    }

    public double[] function(double d) {
        this.f[1] = d;
        double d2 = d;
        int n = 2;
        while (n <= this.degree) {
            this.f[n] = d2 *= d;
            ++n;
        }
        return this.f;
    }
}

