/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.ablationanalysis;

import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisTrajectoryEntry;
import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisValidator;
import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisValidatorOptions;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.options.docgen.OptionsToUsage;
import ca.ubc.cs.beta.aeatk.options.docgen.UsageSectionGenerator;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceOptions;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.RandomInstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorLoader;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AblationAnalysisValidatorExecutor {
    private static Logger log;
    private static Map<String, AbstractOptions> taeOptions;

    public static void main(String[] args) {
        AblationAnalysisValidatorOptions options = AblationAnalysisValidatorExecutor.parseCommandLineOptions(args);
        SeedableRandomPool pool = options.seedOptions.getSeedableRandomPool();
        try {
            ProblemInstanceOptions.TrainTestInstances tti = options.getTrainingAndTestProblemInstances(pool, false, true);
            List testSet = tti.getTestInstances().getInstances();
            ParameterConfigurationSpace configurationSpace = options.algoExecOptions.paramFileDelegate.getParamConfigurationSpace();
            ParameterConfiguration sourceConfiguration = configurationSpace.getParameterConfigurationFromString(options.sourceConfiguration, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX, null);
            ParameterConfiguration targetConfiguration = configurationSpace.getParameterConfigurationFromString(options.targetConfiguration, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX, null);
            List<AblationAnalysisTrajectoryEntry> trajectory = options.getAblationTrajectory();
            RandomInstanceSeedGenerator generator = new RandomInstanceSeedGenerator(testSet, (long)options.seedOptions.numRun);
            AlgorithmExecutionConfiguration executionConfiguration = options.algoExecOptions.getAlgorithmExecutionConfig(options.experimentDir);
            TargetAlgorithmEvaluator tae = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((TargetAlgorithmEvaluatorOptions)options.algoExecOptions.taeOpts, (boolean)true, (boolean)true, taeOptions, null);
            try {
                AblationAnalysisValidator.AblationAnalysisValidationResult result = new AblationAnalysisValidator().validate(tae, executionConfiguration, trajectory, testSet, (InstanceSeedGenerator)generator, options);
                log.info("Ablation analysis validation complete.");
                char[] hyphens = new char[136];
                Arrays.fill(hyphens, '-');
                hyphens[135] = '\u0000';
                log.info(new String(hyphens));
                log.info(String.format("%20s %50s %20s %20s %20s", "Round", "Flipped Parameter", "Source value", "Target value", "Validation result"));
                log.info(new String(hyphens));
                for (Pair<AblationAnalysisTrajectoryEntry, Double> roundResult : result.validationResults) {
                    StringBuffer paramBuf = new StringBuffer();
                    StringBuffer oldBuf = new StringBuffer();
                    StringBuffer newBuf = new StringBuffer();
                    boolean first = true;
                    for (String s : ((AblationAnalysisTrajectoryEntry)roundResult.getFirst()).parametersFlipped) {
                        if (!first) {
                            paramBuf.append(", ");
                        }
                        first = false;
                        paramBuf.append(s);
                    }
                    first = true;
                    for (String s : ((AblationAnalysisTrajectoryEntry)roundResult.getFirst()).oldParameterValues) {
                        if (!first) {
                            oldBuf.append(", ");
                        }
                        first = false;
                        oldBuf.append(s);
                    }
                    first = true;
                    for (String s : ((AblationAnalysisTrajectoryEntry)roundResult.getFirst()).newParameterValues) {
                        if (!first) {
                            newBuf.append(", ");
                        }
                        first = false;
                        newBuf.append(s);
                    }
                    log.info(String.format("%20s %50s %20s %20s %20.5f", String.valueOf(((AblationAnalysisTrajectoryEntry)roundResult.getFirst()).round), paramBuf, oldBuf, newBuf, (double)((Double)roundResult.getSecond())));
                }
                log.info(new String(hyphens));
            }
            finally {
                tae.notifyShutdown();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    protected static AblationAnalysisValidatorOptions parseCommandLineOptions(String[] args) {
        taeOptions = TargetAlgorithmEvaluatorLoader.getAvailableTargetAlgorithmEvaluators();
        AblationAnalysisValidatorOptions options = new AblationAnalysisValidatorOptions();
        JCommander jcom = JCommanderHelper.getJCommander((AbstractOptions)options, taeOptions);
        jcom.setProgramName("ablationAnalysisValidation");
        AblationAnalysisValidatorExecutor.checkArgsForUsageScreenValues(args, options);
        jcom.parse(args);
        System.setProperty("OUTPUTDIR", "./log/");
        System.setProperty("NUMRUN", String.valueOf(options.seedOptions.numRun));
        System.setProperty("STDOUT-LEVEL", options.consoleLogLevel.name());
        System.setProperty("ROOT-LEVEL", options.logLevel.name());
        String logLocation = "." + File.separator + "log" + File.separator;
        System.out.println("*****************************\nLogging to: " + logLocation + "\n*****************************");
        log = LoggerFactory.getLogger(AblationAnalysisValidatorExecutor.class);
        return options;
    }

    private static void checkArgsForUsageScreenValues(String[] args, AblationAnalysisValidatorOptions config) {
        try {
            String[] helpNames;
            HashSet<String> possibleValues = new HashSet<String>(Arrays.asList(args));
            String[] stringArray = helpNames = ((Object)((Object)config)).getClass().getField("showHelp").getAnnotation(Parameter.class).names();
            int n = helpNames.length;
            int n2 = 0;
            while (n2 < n) {
                String helpName = stringArray[n2];
                if (possibleValues.contains(helpName)) {
                    OptionsToUsage.usage((List)UsageSectionGenerator.getUsageSections((Object)((Object)config), taeOptions));
                    System.exit(0);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

