/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.ablationanalysis;

import ca.ubc.cs.beta.aeatk.misc.jcommander.converter.BinaryDigitBooleanConverter;
import ca.ubc.cs.beta.aeatk.misc.jcommander.converter.OverallObjectiveConverter;
import ca.ubc.cs.beta.aeatk.misc.jcommander.converter.RunObjectiveConverter;
import ca.ubc.cs.beta.aeatk.misc.jcommander.validator.OneInfinityOpenInterval;
import ca.ubc.cs.beta.aeatk.misc.jcommander.validator.ZeroInfinityOpenInterval;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import com.beust.jcommander.Parameter;

public class AblationAnalysisOptions
extends AbstractOptions {
    @Parameter(names={"--cutoffTime", "--cutoff_time"}, description="CPU time limit for an individual target algorithm run", required=true, validateWith=ZeroInfinityOpenInterval.class)
    public double cutoffTime = 0.01;
    @Parameter(names={"--maximumAblationRounds"}, description="Maximum number of ablation rounds to perform. Useful if you only care about the k most important parameters. If not set, will perform all necessary rounds between source and target.", required=false, validateWith=ZeroInfinityOpenInterval.class)
    public int maximumAblationRounds = -1;
    @Parameter(names={"--useRacing"}, description="If true, will use racing methods to accelerate ablation. If false, will perform brute-force ablation analysis.", required=false, converter=BinaryDigitBooleanConverter.class)
    public boolean useRacing = true;
    @Parameter(names={"--maximumRacingRounds"}, description="Maximum number of rounds to use when racing. If not set, will use the number of instances provided.", required=false, validateWith=OneInfinityOpenInterval.class)
    public int maximumRacingRounds = -1;
    @Parameter(names={"--racingRoundsBeforeFirstElimination"}, description="Number of racing rounds to perform before the first F-test is applied", required=false, validateWith=OneInfinityOpenInterval.class)
    public int racingRoundsBeforeFirstElimination = 5;
    @Parameter(names={"--seed"}, description="Random seed for reordering instances for each race", required=false, validateWith=OneInfinityOpenInterval.class)
    public long seed = 1L;
    @Parameter(names={"--runObj", "--run_obj"}, description="per target algorithm run objective type that we are optimizing for", converter=RunObjectiveConverter.class, required=true)
    public RunObjective runObj;
    @Parameter(names={"--intraInstanceObj", "--overallObj", "--overall_obj", "--intra_instance_obj"}, description="objective function used to aggregate multiple runs for a single instance", converter=OverallObjectiveConverter.class, required=true)
    public OverallObjective intraInstanceObj;
    @Parameter(names={"--interInstanceObj", "--inter_instance_obj"}, description="objective function used to aggregate over multiple instances (that have already been aggregated under the Intra-Instance Objective)", converter=OverallObjectiveConverter.class)
    public OverallObjective interInstanceObj = OverallObjective.MEAN;
}

