/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvToBean<T> {
    private Map<Class<?>, PropertyEditor> editorMap = null;

    public List<T> parse(MappingStrategy<T> mapper, Reader reader) {
        return this.parse(mapper, reader, null);
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter) {
        return this.parse(mapper, new CSVReader(reader));
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv) {
        return this.parse(mapper, csv, null);
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter) {
        try {
            String[] line;
            mapper.captureHeader(csv);
            ArrayList<T> list = new ArrayList<T>();
            while (null != (line = csv.readNext())) {
                if (filter != null && !filter.allowLine(line)) continue;
                T obj = this.processLine(mapper, line);
                list.add(obj);
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing CSV!", e);
        }
    }

    protected T processLine(MappingStrategy<T> mapper, String[] line) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException {
        T bean = mapper.createBean();
        for (int col = 0; col < line.length; ++col) {
            PropertyDescriptor prop = mapper.findDescriptor(col);
            if (null == prop) continue;
            String value = this.checkForTrim(line[col], prop);
            Object obj = this.convertValue(value, prop);
            prop.getWriteMethod().invoke(bean, obj);
        }
        return bean;
    }

    private String checkForTrim(String s, PropertyDescriptor prop) {
        return this.trimmableProperty(prop) ? s.trim() : s;
    }

    private boolean trimmableProperty(PropertyDescriptor prop) {
        return !prop.getPropertyType().getName().contains("String");
    }

    protected Object convertValue(String value, PropertyDescriptor prop) throws InstantiationException, IllegalAccessException {
        PropertyEditor editor = this.getPropertyEditor(prop);
        Object obj = value;
        if (null != editor) {
            editor.setAsText(value);
            obj = editor.getValue();
        }
        return obj;
    }

    private PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor editor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((editor = this.editorMap.get(cls)) == null) {
            editor = PropertyEditorManager.findEditor(cls);
            this.addEditorToMap(cls, editor);
        }
        return editor;
    }

    private void addEditorToMap(Class<?> cls, PropertyEditor editor) {
        if (editor != null) {
            this.editorMap.put(cls, editor);
        }
    }

    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }
}

