/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class ResultSetHelperService
implements ResultSetHelper {
    public static final int CLOBBUFFERSIZE = 2048;
    static final int NVARCHAR = -9;
    static final int NCHAR = -15;
    static final int LONGNVARCHAR = -16;
    static final int NCLOB = 2011;
    static final String DEFAULT_DATE_FORMAT = "dd-MMM-yyyy";
    static final String DEFAULT_TIMESTAMP_FORMAT = "dd-MMM-yyyy HH:mm:ss";

    private static String read(Clob c) throws SQLException, IOException {
        int n;
        StringBuilder sb = new StringBuilder((int)c.length());
        Reader r = c.getCharacterStream();
        char[] cbuf = new char[2048];
        while ((n = r.read(cbuf, 0, cbuf.length)) != -1) {
            sb.append(cbuf, 0, n);
        }
        return sb.toString();
    }

    @Override
    public String[] getColumnNames(ResultSet rs) throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 0; i < metadata.getColumnCount(); ++i) {
            names.add(metadata.getColumnName(i + 1));
        }
        String[] nameArray = new String[names.size()];
        return names.toArray(nameArray);
    }

    @Override
    public String[] getColumnValues(ResultSet rs) throws SQLException, IOException {
        return this.getColumnValues(rs, false, DEFAULT_DATE_FORMAT, DEFAULT_TIMESTAMP_FORMAT);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim) throws SQLException, IOException {
        return this.getColumnValues(rs, trim, DEFAULT_DATE_FORMAT, DEFAULT_TIMESTAMP_FORMAT);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim, String dateFormatString, String timeFormatString) throws SQLException, IOException {
        ArrayList<String> values = new ArrayList<String>();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 0; i < metadata.getColumnCount(); ++i) {
            values.add(this.getColumnValue(rs, metadata.getColumnType(i + 1), i + 1, trim, dateFormatString, timeFormatString));
        }
        String[] valueArray = new String[values.size()];
        return values.toArray(valueArray);
    }

    private String handleObject(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    private String handleBigDecimal(BigDecimal decimal) {
        return decimal == null ? "" : decimal.toString();
    }

    private String handleLong(ResultSet rs, int columnIndex) throws SQLException {
        long lv = rs.getLong(columnIndex);
        return rs.wasNull() ? "" : Long.toString(lv);
    }

    private String handleInteger(ResultSet rs, int columnIndex) throws SQLException {
        int i = rs.getInt(columnIndex);
        return rs.wasNull() ? "" : Integer.toString(i);
    }

    private String handleDate(ResultSet rs, int columnIndex, String dateFormatString) throws SQLException {
        Date date = rs.getDate(columnIndex);
        String value = null;
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
            value = dateFormat.format(date);
        }
        return value;
    }

    private String handleTime(Time time) {
        return time == null ? null : time.toString();
    }

    private String handleTimestamp(Timestamp timestamp, String timestampFormatString) {
        SimpleDateFormat timeFormat = new SimpleDateFormat(timestampFormatString);
        return timestamp == null ? null : timeFormat.format(timestamp);
    }

    private String getColumnValue(ResultSet rs, int colType, int colIndex, boolean trim, String dateFormatString, String timestampFormatString) throws SQLException, IOException {
        String value = "";
        switch (colType) {
            case -7: 
            case 2000: {
                value = this.handleObject(rs.getObject(colIndex));
                break;
            }
            case 16: {
                boolean b = rs.getBoolean(colIndex);
                value = Boolean.valueOf(b).toString();
                break;
            }
            case 2005: 
            case 2011: {
                Clob c = rs.getClob(colIndex);
                if (c == null) break;
                value = ResultSetHelperService.read(c);
                break;
            }
            case -5: {
                value = this.handleLong(rs, colIndex);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                value = this.handleBigDecimal(rs.getBigDecimal(colIndex));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = this.handleInteger(rs, colIndex);
                break;
            }
            case 91: {
                value = this.handleDate(rs, colIndex, dateFormatString);
                break;
            }
            case 92: {
                value = this.handleTime(rs.getTime(colIndex));
                break;
            }
            case 93: {
                value = this.handleTimestamp(rs.getTimestamp(colIndex), timestampFormatString);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                String columnValue = rs.getString(colIndex);
                if (trim && columnValue != null) {
                    value = columnValue.trim();
                    break;
                }
                value = columnValue;
                break;
            }
            default: {
                value = "";
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }
}

