/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init;

import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.LoggingLoadingSecurityException;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorLoader;
import java.security.Permission;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TAEPluginSecurityManager
extends SecurityManager {
    public static final Set<String> forbiddenPackages;

    @Override
    public void checkPackageAccess(String pkg) {
        if (forbiddenPackages.contains(pkg)) {
            SecurityException e = new SecurityException("Package is forbidden at this point:" + pkg);
            StackTraceElement[] t = e.getStackTrace();
            String bestGuessClass = "Look at stack trace";
            for (StackTraceElement el : t) {
                if (el.getClassName().equals(TargetAlgorithmEvaluatorLoader.class.getCanonicalName()) || !el.getClassName().contains("TargetAlgorithmEvaluator") && !el.getClassName().contains("TAE")) continue;
                bestGuessClass = el.getClassName();
            }
            throw new LoggingLoadingSecurityException("Class <" + bestGuessClass + "> seems to be trying to use logging before it is configured");
        }
    }

    @Override
    public void checkPermission(Permission perm) {
    }

    static {
        HashSet<String> newSet = new HashSet<String>();
        newSet.add("org.slf4j");
        newSet.add("ch.qos.logback");
        forbiddenPackages = Collections.unmodifiableSet(newSet);
    }
}

