/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.functionality;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.concurrent.ReducableSemaphore;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final ReducableSemaphore outstandingRunBlocks = new ReducableSemaphore(1);
    private final AtomicInteger outstandingRuns = new AtomicInteger(0);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private final AtomicInteger runCount = new AtomicInteger();

    public OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        try {
            this.logReduce(runConfigs);
            this.preRun(runConfigs);
            List<AlgorithmRunResult> runs = this.tae.evaluateRun(runConfigs, obs);
            this.postRun(runConfigs);
            this.runCount.addAndGet(runs.size());
            List<AlgorithmRunResult> list = runs;
            return list;
        }
        finally {
            this.logRelease(runConfigs);
        }
    }

    private void logReduce(List<AlgorithmRunConfiguration> runConfigs) {
        this.outstandingRunBlocks.reducePermits();
        this.outstandingRuns.addAndGet(runConfigs.size());
    }

    private void logRelease(List<AlgorithmRunConfiguration> runConfigs) {
        this.outstandingRuns.addAndGet(-1 * runConfigs.size());
        this.outstandingRunBlocks.release();
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        this.logReduce(runConfigs);
        this.preRun(runConfigs);
        TargetAlgorithmEvaluatorCallback callback = new TargetAlgorithmEvaluatorCallback(){
            AtomicBoolean bool = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.postRun(runConfigs);
                OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.runCount.addAndGet(runs.size());
                handler.onSuccess(runs);
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (!this.bool.get()) {
                        this.bool.set(true);
                        OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.logRelease(runConfigs);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(RuntimeException t) {
                try {
                    OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.postRun(runConfigs);
                    handler.onFailure(t);
                }
                finally {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (!this.bool.get()) {
                            this.bool.set(true);
                            OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.logRelease(runConfigs);
                        }
                    }
                }
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, callback, obs);
    }

    @Override
    public void waitForOutstandingEvaluations() {
        try {
            this.outstandingRunBlocks.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        this.outstandingRunBlocks.release();
    }

    @Override
    public int getNumberOfOutstandingEvaluations() {
        return 1 - this.outstandingRunBlocks.availablePermits();
    }

    @Override
    public int getNumberOfOutstandingRuns() {
        return this.outstandingRuns.get();
    }

    @Override
    public int getNumberOfOutstandingBatches() {
        return 1 - this.outstandingRunBlocks.availablePermits();
    }

    @Override
    public int getRunCount() {
        return this.runCount.get();
    }

    protected void preRun(List<AlgorithmRunConfiguration> runConfigs) {
    }

    protected void postRun(List<AlgorithmRunConfiguration> runConfigs) {
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

