/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.runhistory;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.SetInstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.random.RandomUtil;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunHistoryHelper {
    private static Logger log = LoggerFactory.getLogger(RunHistoryHelper.class);

    protected static List<ProblemInstance> getRandomInstanceWithFewestRunsFor(RunHistory rh, ParameterConfiguration config, List<ProblemInstance> instanceList, Random rand, boolean deterministic, int N) {
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = rh.getPerformanceForConfig(config);
        ArrayList<ProblemInstance> candidates = new ArrayList<ProblemInstance>(instanceList.size());
        candidates.addAll(instanceList);
        if (instanceSeedToPerformanceMap != null) {
            candidates.removeAll(instanceSeedToPerformanceMap.keySet());
        }
        if (candidates.size() == 0) {
            int minNumRuns = Integer.MAX_VALUE;
            for (ProblemInstance inst : instanceList) {
                int numRuns = instanceSeedToPerformanceMap.get(inst).size();
                if (numRuns > minNumRuns) continue;
                if (numRuns < minNumRuns) {
                    candidates.clear();
                    minNumRuns = numRuns;
                }
                candidates.add(inst);
            }
        }
        if (!deterministic) {
            int[] permutations = RandomUtil.getPermutation(candidates.size(), 0, rand);
            RandomUtil.permuteList(candidates, permutations);
        }
        ArrayList<ProblemInstance> piDistribution = new ArrayList<ProblemInstance>(instanceList);
        if (N > candidates.size()) {
            while (N > candidates.size()) {
                int[] permutations = RandomUtil.getPermutation(piDistribution.size(), 0, rand);
                RandomUtil.permuteList(piDistribution, permutations);
                candidates.addAll(piDistribution);
            }
            return candidates.subList(0, N);
        }
        if (N == candidates.size()) {
            return candidates;
        }
        return candidates.subList(0, N);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProblemInstanceSeedPair> getRandomInstanceSeedWithFewestRunsFor(ThreadSafeRunHistory rh, InstanceSeedGenerator instanceSeedGenerator, ParameterConfiguration config, List<ProblemInstance> instanceList, Random rand, boolean deterministic, int N) {
        try {
            rh.readLock();
            List<ProblemInstanceSeedPair> list = RunHistoryHelper.getRandomInstanceSeedWithFewestRunsFor((RunHistory)rh, instanceSeedGenerator, config, instanceList, rand, deterministic, N);
            return list;
        }
        finally {
            rh.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProblemInstanceSeedPair> getRandomInstanceSeedWithFewestRunsFor(RunHistory rh, InstanceSeedGenerator instanceSeedGenerator, ParameterConfiguration config, List<ProblemInstance> instanceList, Random rand, boolean deterministic, int N) {
        List<ProblemInstance> pis = RunHistoryHelper.getRandomInstanceWithFewestRunsFor(rh, config, instanceList, rand, deterministic, N);
        ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>(N);
        ConcurrentHashMap assignedSeedsByPi = new ConcurrentHashMap();
        for (ProblemInstance pi : pis) {
            long seed;
            assignedSeedsByPi.putIfAbsent(pi, new HashSet());
            Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = rh.getPerformanceForConfig(config);
            List<Long> seedsUsedByPi = rh.getSeedsUsedByInstance(pi);
            Set<Object> seedsUsedByPiConfigSet = instanceSeedToPerformanceMap == null || instanceSeedToPerformanceMap.get(pi) == null ? Collections.emptySet() : instanceSeedToPerformanceMap.get(pi).keySet();
            ArrayList seedsUsedByPiConfig = new ArrayList(seedsUsedByPiConfigSet);
            ArrayList<Long> potentialSeeds = new ArrayList<Long>(seedsUsedByPi.size() - seedsUsedByPiConfig.size());
            potentialSeeds.addAll(seedsUsedByPi);
            potentialSeeds.removeAll(seedsUsedByPiConfig);
            potentialSeeds.removeAll((Collection)assignedSeedsByPi.get(pi));
            if (potentialSeeds.size() == 0) {
                InstanceSeedGenerator instanceSeedGenerator2 = instanceSeedGenerator;
                synchronized (instanceSeedGenerator2) {
                    seed = instanceSeedGenerator instanceof SetInstanceSeedGenerator ? (instanceSeedGenerator.hasNextSeed(pi) ? (long)instanceSeedGenerator.getNextSeed(pi) : -1L) : (long)instanceSeedGenerator.getNextSeed(pi);
                }
            } else {
                seed = (Long)potentialSeeds.get(rand.nextInt(potentialSeeds.size()));
            }
            ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, seed);
            pisps.add(pisp);
            ((Set)assignedSeedsByPi.get(pi)).add(seed);
        }
        ArrayList newPISPS = new ArrayList(pisps);
        HashSet setPISPS = new HashSet(newPISPS);
        if (setPISPS.size() != newPISPS.size()) {
            throw new IllegalStateException("Duplicated problem instance seed paris generated oddly enough");
        }
        return pisps;
    }

    public static ProblemInstanceSeedPair getRandomInstanceSeedWithFewestRunsFor(ThreadSafeRunHistory rh, InstanceSeedGenerator instanceSeedGenerator, ParameterConfiguration config, List<ProblemInstance> instanceList, Random rand, boolean deterministic) {
        return RunHistoryHelper.getRandomInstanceSeedWithFewestRunsFor(rh, instanceSeedGenerator, config, instanceList, rand, deterministic, 1).get(0);
    }

    public static ProblemInstanceSeedPair getRandomInstanceSeedWithFewestRunsFor(RunHistory rh, InstanceSeedGenerator instanceSeedGenerator, ParameterConfiguration config, List<ProblemInstance> instanceList, Random rand, boolean deterministic) {
        return RunHistoryHelper.getRandomInstanceSeedWithFewestRunsFor(rh, instanceSeedGenerator, config, instanceList, rand, deterministic, 1).get(0);
    }

    public static double[] getRunResponseValues(List<AlgorithmRunResult> runs, RunObjective runObj) {
        double[] responseValues = new double[runs.size()];
        int i = 0;
        for (AlgorithmRunResult run : runs) {
            responseValues[i] = runObj.getObjective(run);
            ++i;
        }
        return responseValues;
    }

    public static final boolean[] getCensoredEarlyFlagForRuns(List<AlgorithmRunResult> runs) {
        boolean[] censored = new boolean[runs.size()];
        int i = 0;
        for (AlgorithmRunResult run : runs) {
            censored[i] = run.isCensoredEarly();
            ++i;
        }
        return censored;
    }
}

