/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.runhistory;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.runhistory.KeyObjectManager;
import ca.ubc.cs.beta.aeatk.runhistory.RunData;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class NewRunHistory
implements RunHistory {
    private final OverallObjective perInstanceObjectiveFunction;
    private final OverallObjective aggregateInstanceObjectiveFunction;
    private final RunObjective runObj;
    private int iteration = 0;
    private final KeyObjectManager<ParameterConfiguration> paramConfigurationList = new KeyObjectManager();
    private final List<RunData> runHistoryListIncludingRedundant = new ArrayList<RunData>();
    private final List<RunData> runHistoryListExcludingRedundant = new ArrayList<RunData>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private double totalRuntimeSum = 0.0;
    private final Map<ParameterConfiguration, Map<ProblemInstance, LinkedHashMap<Long, Double>>> configToPerformanceMap = new HashMap<ParameterConfiguration, Map<ProblemInstance, LinkedHashMap<Long, Double>>>();
    private final HashMap<ProblemInstance, List<Long>> seedsUsedByInstance = new HashMap();
    private final LinkedHashMap<ParameterConfiguration, Integer> configToNumRunsMap = new LinkedHashMap();
    private final LinkedHashMap<ParameterConfiguration, Integer> configToNumRunsIgnoringRedundantMap = new LinkedHashMap();
    private final HashMap<ParameterConfiguration, Set<ProblemInstanceSeedPair>> censoredEarlyRuns = new HashMap();
    private Set<ProblemInstance> instancesRanSet = new HashSet<ProblemInstance>();
    private final HashMap<ParameterConfiguration, List<AlgorithmRunResult>> configToRunMap = new HashMap();
    private final LinkedHashMap<ParameterConfiguration, LinkedHashMap<ProblemInstanceSeedPair, AlgorithmRunResult>> configToRunIgnoreRedundantMap = new LinkedHashMap();
    private final List<AlgorithmRunResult> runsInAuthorativeOrderExcludingRedundant = new ArrayList<AlgorithmRunResult>();
    private final Map<ParamConfigurationProblemInstanceSeedPair, Integer> runIndex = new HashMap<ParamConfigurationProblemInstanceSeedPair, Integer>();
    private static final DecimalFormat format = new DecimalFormat("#######.####");
    private final Map<AlgorithmRunConfiguration, AlgorithmRunResult> algorithmRunConfigurationResultMap = new HashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
    private volatile AlgorithmExecutionConfiguration firstExecConfig;

    public NewRunHistory() {
        this(OverallObjective.MEAN, OverallObjective.MEAN10, RunObjective.RUNTIME);
    }

    public NewRunHistory(OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, RunObjective runObj) {
        if (intraInstanceObjective == null) {
            throw new IllegalArgumentException("You must supply an intra instance objective");
        }
        if (interInstanceObjective == null) {
            throw new IllegalArgumentException("You must supply an interInstanceObjective");
        }
        if (runObj == null) {
            throw new IllegalArgumentException("You must supply a run objective");
        }
        this.perInstanceObjectiveFunction = intraInstanceObjective;
        this.aggregateInstanceObjectiveFunction = interInstanceObjective;
        this.runObj = runObj;
    }

    @Override
    public void append(AlgorithmRunResult run) throws DuplicateRunException {
        LinkedHashMap<Long, Double> seedToPerformanceMap;
        if (this.firstExecConfig == null) {
            this.firstExecConfig = run.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration();
        } else if (!this.firstExecConfig.equals(run.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration())) {
            throw new IllegalArgumentException("RunHistory object cannot store runs for different exec configs first was: " + this.firstExecConfig + " current run was : " + run.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration());
        }
        if (run.getRunStatus().equals((Object)RunStatus.RUNNING)) {
            throw new IllegalArgumentException("Runs with Run Result RUNNING cannot be saved to a RunHistory object");
        }
        ParameterConfiguration config = run.getAlgorithmRunConfiguration().getParameterConfiguration();
        ProblemInstanceSeedPair pisp = run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair();
        ProblemInstance pi = pisp.getProblemInstance();
        long seed = run.getResultSeed();
        Double runResult = this.runObj.getObjective(run);
        List<Long> instanceSeedList = this.seedsUsedByInstance.get(pi);
        if (instanceSeedList == null) {
            instanceSeedList = new LinkedList<Long>();
            this.seedsUsedByInstance.put(pi, instanceSeedList);
        }
        instanceSeedList.add(seed);
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceToPerformanceMap = this.configToPerformanceMap.get(config);
        if (instanceToPerformanceMap == null) {
            instanceToPerformanceMap = new HashMap<ProblemInstance, LinkedHashMap<Long, Double>>();
            this.configToPerformanceMap.put(config, instanceToPerformanceMap);
        }
        if ((seedToPerformanceMap = instanceToPerformanceMap.get(pi)) == null) {
            seedToPerformanceMap = new LinkedHashMap();
            instanceToPerformanceMap.put(pi, seedToPerformanceMap);
        }
        Double dOldValue = seedToPerformanceMap.put(seed, runResult);
        RunStatus result = run.getRunStatus();
        boolean censoredEarly = run.isCensoredEarly();
        if (this.configToRunIgnoreRedundantMap.get(config) == null) {
            this.configToRunIgnoreRedundantMap.put(config, new LinkedHashMap());
        }
        if (dOldValue != null) {
            Set<ProblemInstanceSeedPair> censoredEarlyRunsForConfig = this.censoredEarlyRuns.get(config);
            if (censoredEarlyRunsForConfig != null && censoredEarlyRunsForConfig.contains(pisp)) {
                if (this.runObj != RunObjective.RUNTIME) {
                    this.log.error("Not sure how to rectify early censored runs under different run objectives, current run seems to conflict with a previous one: {} ", (Object)run);
                    throw new IllegalStateException("Unable to handle capped runs for the RunObjective: " + (Object)((Object)this.runObj));
                }
            } else {
                AlgorithmRunResult matchingRun = null;
                for (AlgorithmRunResult algoRun : this.getAlgorithmRunsExcludingRedundant(config)) {
                    if (!algoRun.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().equals(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair())) continue;
                    matchingRun = algoRun;
                }
                seedToPerformanceMap.put(seed, dOldValue);
                Object[] args = new Object[]{matchingRun, run, config, pi, dOldValue};
                throw new DuplicateRunException("Duplicate Run Detected", run);
            }
            censoredEarlyRunsForConfig.remove(pisp);
            if (this.runObj != RunObjective.RUNTIME) {
                this.log.error("Not sure how to rectify early censored runs under different run objectives, current run seems to conflict with a previous one: {} ", (Object)run);
                throw new IllegalStateException("Unable to handle capped runs for the RunObjective: " + (Object)((Object)this.runObj));
            }
            if (censoredEarly) {
                seedToPerformanceMap.put(seed, Math.max(dOldValue, runResult));
                if (dOldValue < runResult) {
                    AlgorithmRunResult run2 = this.configToRunIgnoreRedundantMap.get(config).get(pisp);
                    this.configToRunIgnoreRedundantMap.get(config).put(pisp, run);
                    ParamConfigurationProblemInstanceSeedPair pcpisp = new ParamConfigurationProblemInstanceSeedPair(pisp, config);
                    if (this.runIndex.get(pcpisp) == null) {
                        throw new IllegalStateException("This run should exist somewhere else in our list");
                    }
                    int index = this.runIndex.get(pcpisp);
                    this.runsInAuthorativeOrderExcludingRedundant.set(index, run);
                }
            }
        } else {
            if (this.configToNumRunsIgnoringRedundantMap.get(config) == null) {
                this.configToNumRunsIgnoringRedundantMap.put(config, 1);
            } else {
                this.configToNumRunsIgnoringRedundantMap.put(config, this.configToNumRunsIgnoringRedundantMap.get(config) + 1);
            }
            this.configToRunIgnoreRedundantMap.get(config).put(pisp, run);
            ParamConfigurationProblemInstanceSeedPair pcpisp = new ParamConfigurationProblemInstanceSeedPair(pisp, config);
            this.runsInAuthorativeOrderExcludingRedundant.add(run);
            this.runIndex.put(pcpisp, this.runsInAuthorativeOrderExcludingRedundant.size() - 1);
        }
        if (this.configToRunMap.get(config) == null) {
            this.configToRunMap.put(config, new ArrayList());
        }
        this.configToRunMap.get(config).add(run);
        this.totalRuntimeSum += Math.max(0.1, run.getRuntime());
        int thetaIdx = this.paramConfigurationList.getOrCreateKey(config);
        int instanceIdx = pi.getInstanceID();
        RunData rd = new RunData(this.iteration, thetaIdx, instanceIdx, run, runResult, censoredEarly);
        this.runHistoryListIncludingRedundant.add(rd);
        if (dOldValue != null) {
            if (dOldValue < runResult) {
                ParamConfigurationProblemInstanceSeedPair pcpisp = new ParamConfigurationProblemInstanceSeedPair(pisp, config);
                if (this.runIndex.get(pcpisp) == null) {
                    throw new IllegalStateException("This run should exist somewhere else in our list");
                }
                int index = this.runIndex.get(pcpisp);
                this.runHistoryListExcludingRedundant.set(index, rd);
            }
        } else {
            this.runHistoryListExcludingRedundant.add(rd);
        }
        if (this.configToNumRunsMap.get(config) == null) {
            this.configToNumRunsMap.put(config, 1);
        } else {
            this.configToNumRunsMap.put(config, this.configToNumRunsMap.get(config) + 1);
        }
        this.instancesRanSet.add(pi);
        if (censoredEarly) {
            if (!this.censoredEarlyRuns.containsKey(config)) {
                this.censoredEarlyRuns.put(config, new LinkedHashSet());
            }
            this.censoredEarlyRuns.get(config).add(pisp);
        }
        this.algorithmRunConfigurationResultMap.put(run.getAlgorithmRunConfiguration(), run);
    }

    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        Map<ProblemInstance, Map<Long, Double>> foo = Collections.emptyMap();
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, foo);
    }

    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, double minimumResponseValue) {
        Map<ProblemInstance, Map<Long, Double>> foo = Collections.emptyMap();
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, foo, minimumResponseValue);
    }

    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, Double.NEGATIVE_INFINITY);
    }

    @Override
    public double getEmpiricalCostLowerBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.getEmpiricalCostBound(config, instanceSet, cutoffTime, 0.0, Bound.LOWER);
    }

    @Override
    public double getEmpiricalCostUpperBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.getEmpiricalCostBound(config, instanceSet, cutoffTime, cutoffTime, Bound.UPPER);
    }

    private double getEmpiricalCostBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Double boundValue, Bound b) {
        HashMap<ProblemInstance, Map<Long, Double>> hallucinatedValues = new HashMap<ProblemInstance, Map<Long, Double>>();
        Set<ProblemInstanceSeedPair> earlyCensoredPISPs = this.getEarlyCensoredProblemInstanceSeedPairs(config);
        for (ProblemInstance pi : instanceSet) {
            HashMap<Long, Double> instPerformance = new HashMap<Long, Double>();
            hallucinatedValues.put(pi, instPerformance);
            if (this.seedsUsedByInstance.get(pi) == null) {
                this.seedsUsedByInstance.put(pi, new ArrayList());
            }
            for (Long l : this.seedsUsedByInstance.get(pi)) {
                instPerformance.put(l, boundValue);
            }
            HashMap actualPerformance = new HashMap();
            if (this.configToPerformanceMap.get(config) != null) {
                instPerformance.putAll((Map)this.configToPerformanceMap.get(config).get(pi));
            }
            if (b == Bound.UPPER) {
                for (Long l : this.seedsUsedByInstance.get(pi)) {
                    ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, l);
                    if (!earlyCensoredPISPs.contains(pisp)) continue;
                    instPerformance.put(l, boundValue);
                }
            }
            if (instPerformance.size() != 0) continue;
            instPerformance.put(Long.MIN_VALUE, boundValue);
        }
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, 0.0);
    }

    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues, double minimumResponseValue) {
        if (!this.configToPerformanceMap.containsKey(config) && hallucinatedValues.isEmpty()) {
            return Double.MAX_VALUE;
        }
        ArrayList<Double> instanceCosts = new ArrayList<Double>();
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        if (instanceSeedToPerformanceMap == null) {
            instanceSeedToPerformanceMap = new HashMap<ProblemInstance, LinkedHashMap<Long, Double>>();
        }
        HashSet<ProblemInstance> instancesToUse = new HashSet<ProblemInstance>();
        instancesToUse.addAll(instanceSet);
        HashSet<ProblemInstance> instancesToKeep = new HashSet<ProblemInstance>(instanceSeedToPerformanceMap.keySet());
        instancesToKeep.addAll(hallucinatedValues.keySet());
        instancesToUse.retainAll(instancesToKeep);
        for (ProblemInstance pi : instancesToUse) {
            HashMap<Long, Double> seedToPerformanceMap = new HashMap<Long, Double>();
            if (instanceSeedToPerformanceMap.get(pi) != null) {
                seedToPerformanceMap.putAll((Map)instanceSeedToPerformanceMap.get(pi));
            }
            if (hallucinatedValues.get(pi) != null) {
                seedToPerformanceMap.putAll(hallucinatedValues.get(pi));
            }
            ArrayList<Double> localCosts = new ArrayList<Double>();
            for (Map.Entry ent : seedToPerformanceMap.entrySet()) {
                localCosts.add(Math.max(minimumResponseValue, (Double)ent.getValue()));
            }
            instanceCosts.add(this.perInstanceObjectiveFunction.aggregate(localCosts, cutoffTime));
        }
        return this.aggregateInstanceObjectiveFunction.aggregate(instanceCosts, cutoffTime);
    }

    @Override
    public RunObjective getRunObjective() {
        return this.runObj;
    }

    @Override
    public OverallObjective getOverallObjective() {
        return this.perInstanceObjectiveFunction;
    }

    @Override
    public void incrementIteration() {
        ++this.iteration;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Set<ProblemInstance> getProblemInstancesRan(ParameterConfiguration config) {
        if (!this.configToPerformanceMap.containsKey(config)) {
            return new HashSet<ProblemInstance>();
        }
        return new HashSet<ProblemInstance>(this.configToPerformanceMap.get(config).keySet());
    }

    @Override
    public Set<ProblemInstanceSeedPair> getProblemInstanceSeedPairsRan(ParameterConfiguration config) {
        if (!this.configToPerformanceMap.containsKey(config)) {
            return new HashSet<ProblemInstanceSeedPair>();
        }
        HashSet<ProblemInstanceSeedPair> pispSet = new HashSet<ProblemInstanceSeedPair>();
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        for (Map.Entry<ProblemInstance, LinkedHashMap<Long, Double>> kv : instanceSeedToPerformanceMap.entrySet()) {
            ProblemInstance pi = kv.getKey();
            Map hConfigInst = kv.getValue();
            for (Long seed : hConfigInst.keySet()) {
                pispSet.add(new ProblemInstanceSeedPair(pi, seed));
            }
        }
        return pispSet;
    }

    @Override
    public Set<ProblemInstanceSeedPair> getEarlyCensoredProblemInstanceSeedPairs(ParameterConfiguration config) {
        if (!this.censoredEarlyRuns.containsKey(config)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.censoredEarlyRuns.get(config));
    }

    @Override
    public double getTotalRunCost() {
        return this.totalRuntimeSum;
    }

    @Override
    public Set<ProblemInstance> getUniqueInstancesRan() {
        return Collections.unmodifiableSet(this.instancesRanSet);
    }

    @Override
    public Set<ParameterConfiguration> getUniqueParamConfigurations() {
        return Collections.unmodifiableSet(this.configToNumRunsMap.keySet());
    }

    @Override
    public int[][] getParameterConfigurationInstancesRanByIndexExcludingRedundant() {
        int[][] result = new int[this.runHistoryListExcludingRedundant.size()][2];
        int i = 0;
        for (RunData runData : this.runHistoryListExcludingRedundant) {
            result[i][0] = runData.getThetaIdx();
            result[i][1] = runData.getInstanceidx();
            ++i;
        }
        return result;
    }

    @Override
    public List<ParameterConfiguration> getAllParameterConfigurationsRan() {
        ArrayList<ParameterConfiguration> runs = new ArrayList<ParameterConfiguration>(this.paramConfigurationList.size());
        for (int i = 1; i <= this.paramConfigurationList.size(); ++i) {
            runs.add(this.paramConfigurationList.getValue(i));
        }
        return runs;
    }

    @Override
    public double[][] getAllConfigurationsRanInValueArrayForm() {
        double[][] configs = new double[this.paramConfigurationList.size()][];
        for (int i = 1; i <= this.paramConfigurationList.size(); ++i) {
            configs[i - 1] = this.paramConfigurationList.getValue(i).toValueArray();
        }
        return configs;
    }

    @Override
    public List<RunData> getAlgorithmRunDataExcludingRedundant() {
        return Collections.unmodifiableList(this.runHistoryListExcludingRedundant);
    }

    @Override
    public List<RunData> getAlgorithmRunDataIncludingRedundant() {
        return Collections.unmodifiableList(this.runHistoryListIncludingRedundant);
    }

    @Override
    public int getThetaIdx(ParameterConfiguration config) {
        Integer thetaIdx = this.paramConfigurationList.getKey(config);
        if (thetaIdx == null) {
            return -1;
        }
        return thetaIdx;
    }

    @Override
    public int getOrCreateThetaIdx(ParameterConfiguration config) {
        return this.paramConfigurationList.getOrCreateKey(config);
    }

    @Override
    public int getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(ParameterConfiguration config) {
        Map<ProblemInstance, LinkedHashMap<Long, Double>> runs = this.configToPerformanceMap.get(config);
        int total = 0;
        for (Map.Entry<ProblemInstance, LinkedHashMap<Long, Double>> ent : runs.entrySet()) {
            total += ent.getValue().size();
        }
        return total;
    }

    @Override
    public Map<ProblemInstance, LinkedHashMap<Long, Double>> getPerformanceForConfig(ParameterConfiguration config) {
        Map<ProblemInstance, LinkedHashMap<Long, Double>> map = this.configToPerformanceMap.get(config);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    @Override
    public int getTotalNumRunsOfConfigIncludingRedundant(ParameterConfiguration config) {
        Integer value = this.configToNumRunsMap.get(config);
        if (value != null) {
            return value;
        }
        return 0;
    }

    @Override
    public int getTotalNumRunsOfConfigExcludingRedundant(ParameterConfiguration config) {
        Integer value = this.configToNumRunsIgnoringRedundantMap.get(config);
        if (value != null) {
            return value;
        }
        return 0;
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant() {
        return new ArrayList<AlgorithmRunResult>(this.runsInAuthorativeOrderExcludingRedundant);
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant() {
        ArrayList<AlgorithmRunResult> runs = new ArrayList<AlgorithmRunResult>(this.runHistoryListIncludingRedundant.size());
        for (RunData runData : this.getAlgorithmRunDataIncludingRedundant()) {
            runs.add(runData.getRun());
        }
        return runs;
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant(ParameterConfiguration config) {
        List<AlgorithmRunResult> runs = this.configToRunMap.get(config);
        if (runs != null) {
            return Collections.unmodifiableList(runs);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant(ParameterConfiguration config) {
        Map runs = this.configToRunIgnoreRedundantMap.get(config);
        if (runs == null) {
            runs = Collections.emptyMap();
        }
        return Collections.unmodifiableList(new ArrayList(runs.values()));
    }

    @Override
    public List<Long> getSeedsUsedByInstance(ProblemInstance pi) {
        if (this.seedsUsedByInstance.get(pi) == null) {
            this.seedsUsedByInstance.put(pi, new ArrayList());
        }
        return Collections.unmodifiableList(this.seedsUsedByInstance.get(pi));
    }

    @Override
    public AlgorithmRunResult getAlgorithmRunResultForAlgorithmRunConfiguration(AlgorithmRunConfiguration runConfig) {
        return this.algorithmRunConfigurationResultMap.get(runConfig);
    }

    @Override
    public OverallObjective getIntraInstanceObjective() {
        return this.perInstanceObjectiveFunction;
    }

    @Override
    public OverallObjective getInterInstanceObjective() {
        return this.aggregateInstanceObjectiveFunction;
    }

    @Override
    public AlgorithmExecutionConfiguration getAlgorithmExecutionConfiguration() {
        if (this.firstExecConfig != null) {
            return this.firstExecConfig;
        }
        throw new IllegalStateException("No runs have been logged");
    }

    private static class ParamConfigurationProblemInstanceSeedPair {
        private final ProblemInstanceSeedPair pisp;
        private final ParameterConfiguration config;

        public ParamConfigurationProblemInstanceSeedPair(ProblemInstanceSeedPair pisp, ParameterConfiguration config) {
            this.pisp = pisp;
            this.config = config;
        }

        public ProblemInstanceSeedPair getProblemInstanceSeedPair() {
            return this.pisp;
        }

        public ParameterConfiguration getConfig() {
            return this.config;
        }

        public int hashCode() {
            int prime = 37;
            int result = 1;
            result = 37 * result + (this.config == null ? 0 : this.config.hashCode());
            result = 37 * result + (this.pisp == null ? 0 : this.pisp.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParamConfigurationProblemInstanceSeedPair)) {
                return false;
            }
            ParamConfigurationProblemInstanceSeedPair other = (ParamConfigurationProblemInstanceSeedPair)obj;
            if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
                return false;
            }
            return !(this.pisp == null ? other.pisp != null : !this.pisp.equals(other.pisp));
        }
    }

    private static enum Bound {
        UPPER,
        LOWER;

    }
}

