/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.model.helper;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.model.ModelBuildingOptions;
import ca.ubc.cs.beta.aeatk.model.builder.AdaptiveCappingModelBuilder;
import ca.ubc.cs.beta.aeatk.model.builder.BasicModelBuilder;
import ca.ubc.cs.beta.aeatk.model.builder.ModelBuilder;
import ca.ubc.cs.beta.aeatk.model.data.AbstractSanitizedModelData;
import ca.ubc.cs.beta.aeatk.model.data.MaskCensoredDataAsUncensored;
import ca.ubc.cs.beta.aeatk.model.data.MaskInactiveConditionalParametersWithDefaults;
import ca.ubc.cs.beta.aeatk.model.data.PCAModelDataSanitizer;
import ca.ubc.cs.beta.aeatk.options.RandomForestOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistoryHelper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ModelBuilderHelper {
    public static ModelBuilder getModelBuilder(RunHistory runHistory, ParameterConfigurationSpace configSpace, List<ProblemInstance> instances, ModelBuildingOptions mbOptions, RandomForestOptions randomForestOptions, Random randomForestBuildingPRNG, boolean adaptiveCapping, int numPCA, boolean logModel, double subsamplePercentage) {
        int j;
        LinkedHashSet<ProblemInstance> all_instances = new LinkedHashSet<ProblemInstance>(instances);
        Set<ParameterConfiguration> paramConfigs = runHistory.getUniqueParamConfigurations();
        Set<ProblemInstance> runInstances = runHistory.getUniqueInstancesRan();
        ArrayList<Integer> runInstancesIdx = new ArrayList<Integer>(all_instances.size());
        int i = 0;
        double[][] instanceFeatureMatrix = new double[all_instances.size()][];
        for (ProblemInstance problemInstance : all_instances) {
            if (runInstances.contains(problemInstance)) {
                runInstancesIdx.add(i);
            }
            instanceFeatureMatrix[i] = problemInstance.getFeaturesDouble();
            ++i;
        }
        double[][] thetaMatrix = new double[paramConfigs.size()][];
        i = 0;
        for (ParameterConfiguration pc : paramConfigs) {
            if (mbOptions.maskInactiveConditionalParametersAsDefaultValue) {
                thetaMatrix[i++] = pc.toComparisonValueArray();
                continue;
            }
            thetaMatrix[i++] = pc.toValueArray();
        }
        int[] nArray = new int[runInstancesIdx.size()];
        for (int j2 = 0; j2 < runInstancesIdx.size(); ++j2) {
            nArray[j2] = (Integer)runInstancesIdx.get(j2);
        }
        List<AlgorithmRunResult> runs = runHistory.getAlgorithmRunsExcludingRedundant();
        double[] runResponseValues = RunHistoryHelper.getRunResponseValues(runs, runHistory.getRunObjective());
        boolean[] censored = RunHistoryHelper.getCensoredEarlyFlagForRuns(runs);
        if (mbOptions.maskCensoredDataAsKappaMax) {
            for (j = 0; j < runResponseValues.length; ++j) {
                if (!censored[j]) continue;
                runResponseValues[j] = runHistory.getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime();
            }
        }
        block8: for (j = 0; j < runResponseValues.length; ++j) {
            switch (runHistory.getRunObjective()) {
                case RUNTIME: {
                    if (!(runResponseValues[j] >= runHistory.getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime())) continue block8;
                    runResponseValues[j] = runHistory.getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime() * runHistory.getIntraInstanceObjective().getPenaltyFactor();
                    continue block8;
                }
                case QUALITY: {
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Not sure what objective this is: " + (Object)((Object)runHistory.getRunObjective()));
                }
            }
        }
        AbstractSanitizedModelData sanitizedData = new PCAModelDataSanitizer(instanceFeatureMatrix, thetaMatrix, numPCA, runResponseValues, logModel, runHistory.getParameterConfigurationInstancesRanByIndexExcludingRedundant(), censored, configSpace);
        if (mbOptions.maskCensoredDataAsUncensored) {
            sanitizedData = new MaskCensoredDataAsUncensored(sanitizedData);
        }
        if (mbOptions.maskInactiveConditionalParametersAsDefaultValue) {
            sanitizedData = new MaskInactiveConditionalParametersWithDefaults(sanitizedData, configSpace);
        }
        ModelBuilder mb = adaptiveCapping ? new AdaptiveCappingModelBuilder(sanitizedData, randomForestOptions, randomForestBuildingPRNG, mbOptions.imputationIterations, runHistory.getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime(), runHistory.getIntraInstanceObjective().getPenaltyFactor(), subsamplePercentage) : new BasicModelBuilder(sanitizedData, randomForestOptions, subsamplePercentage, randomForestBuildingPRNG);
        return mb;
    }
}

