/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.model.data;

import ca.ubc.cs.beta.aeatk.misc.math.ArrayMathOps;
import ca.ubc.cs.beta.aeatk.misc.math.MessyMathHelperClass;
import ca.ubc.cs.beta.aeatk.model.data.AbstractSanitizedModelData;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCAModelDataSanitizer
extends AbstractSanitizedModelData {
    private final double[][] pcaVec;
    private final double[] pcaCoeff;
    private final int[] sub;
    private final int[] constantColumnsAt10toMinus6;
    private final double[] means;
    private final double[] stdDevs;
    private final double[][] pcaFeatures;
    private final double[][] prePCAInstanceFeatures;
    private final double[] responseValues;
    private final ParameterConfigurationSpace configSpace;
    private final double[][] configs;
    private final boolean emptyFeatures;
    private final boolean logModel;
    public static int index = 0;
    public static final String filename = "/tmp/lastoutput-mds";
    static boolean writeOutput = true;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private int[][] theta_inst_idxs;
    private boolean[] censoredResponseValues;
    public static boolean printFeatures = false;

    public static String explode(String s) {
        return s.replaceAll("]", "}\n").replaceAll("\\[", "{");
    }

    public PCAModelDataSanitizer(double[][] instanceFeatures, double[][] paramValues, int numPCA, double[] responseValues, boolean logModel, int[][] theta_inst_idxs, boolean[] censoredResponseValues) {
        this(instanceFeatures, paramValues, numPCA, responseValues, logModel, theta_inst_idxs, censoredResponseValues, null);
    }

    public PCAModelDataSanitizer(double[][] instanceFeatures, double[][] paramValues, int numPCA, double[] responseValues, boolean logModel, int[][] theta_inst_idxs, boolean[] censoredResponseValues, ParameterConfigurationSpace configSpace) {
        int[] mySub;
        TreeSet<Integer> usedInstIdxs = new TreeSet<Integer>();
        for (int i = 0; i < theta_inst_idxs.length; ++i) {
            usedInstIdxs.add(theta_inst_idxs[i][1]);
        }
        int[] usedInstancesIdxs = new int[usedInstIdxs.size()];
        int count = 0;
        Iterator iterator = usedInstIdxs.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            usedInstancesIdxs[count++] = idx - 1;
        }
        this.configSpace = configSpace;
        this.configs = paramValues;
        this.responseValues = responseValues;
        this.theta_inst_idxs = theta_inst_idxs;
        this.censoredResponseValues = censoredResponseValues;
        this.prePCAInstanceFeatures = ArrayMathOps.copy(instanceFeatures);
        double[][] instanceFeaturesGreaterThan10toMinus6 = ArrayMathOps.copy(instanceFeatures);
        MessyMathHelperClass pca = new MessyMathHelperClass();
        double[][] usedInstanceFeatures = new double[usedInstancesIdxs.length][];
        for (int i = 0; i < usedInstanceFeatures.length; ++i) {
            usedInstanceFeatures[i] = instanceFeaturesGreaterThan10toMinus6[usedInstancesIdxs[i]];
        }
        int[] constFeaturesAt10toMinus6 = pca.constantColumnsWithMissingValues(usedInstanceFeatures);
        instanceFeaturesGreaterThan10toMinus6 = pca.copyMatrixAndRemoveColumns(instanceFeaturesGreaterThan10toMinus6, constFeaturesAt10toMinus6);
        this.constantColumnsAt10toMinus6 = constFeaturesAt10toMinus6;
        this.log.trace("Discarding {} constant inputs of {} in total.", (Object)constFeaturesAt10toMinus6.length, (Object)this.prePCAInstanceFeatures[0].length);
        double[][] instanceFeaturesT = pca.transpose(instanceFeaturesGreaterThan10toMinus6);
        double[] firstStdDev = pca.getRowStdDev(instanceFeaturesT);
        this.logModel = logModel;
        if (logModel) {
            pca.max(responseValues, 0.005);
            pca.log10(responseValues);
        }
        if ((mySub = pca.getSub(firstStdDev)).length == 0) {
            this.sub = new int[0];
            this.means = new double[0];
            this.stdDevs = new double[0];
            this.pcaCoeff = new double[0];
            this.pcaVec = new double[0][];
            this.pcaFeatures = new double[instanceFeaturesGreaterThan10toMinus6.length][1];
            this.emptyFeatures = true;
            return;
        }
        if (instanceFeaturesGreaterThan10toMinus6[0].length < numPCA) {
            this.sub = new int[0];
            this.means = new double[0];
            this.stdDevs = new double[0];
            this.pcaCoeff = new double[0];
            this.pcaVec = new double[0][];
            this.pcaFeatures = instanceFeaturesGreaterThan10toMinus6;
            this.emptyFeatures = false;
            return;
        }
        this.emptyFeatures = false;
        this.sub = mySub;
        double[][] instanceFeaturesGreaterThan10toMinus5 = pca.copyMatrixAndKeepColumns(instanceFeaturesGreaterThan10toMinus6, this.sub);
        instanceFeaturesT = pca.transpose(instanceFeaturesGreaterThan10toMinus5);
        this.means = pca.getRowMeans(instanceFeaturesT);
        this.stdDevs = pca.getRowStdDev(instanceFeaturesT);
        pca.perColumnOperation(instanceFeaturesGreaterThan10toMinus5, this.means, MessyMathHelperClass.Operation.SUBTRACT);
        pca.perColumnOperation(instanceFeaturesGreaterThan10toMinus5, this.stdDevs, MessyMathHelperClass.Operation.DIVIDE);
        this.pcaCoeff = pca.getPCACoeff(instanceFeaturesGreaterThan10toMinus5, numPCA);
        this.pcaVec = pca.getPCA(instanceFeaturesGreaterThan10toMinus5, numPCA);
        this.pcaFeatures = PCAModelDataSanitizer.applyTransformation(this.prePCAInstanceFeatures, this.emptyFeatures, this.constantColumnsAt10toMinus6, this.sub, this.means, this.stdDevs, this.pcaVec);
    }

    public static double[][] applyTransformation(double[][] instanceFeatures, boolean emptyFeatures, int[] constantColumns, int[] sub, double[] means, double[] stdDevs, double[][] pcaVec) {
        if (emptyFeatures) {
            return new double[instanceFeatures.length][1];
        }
        MessyMathHelperClass pca = new MessyMathHelperClass();
        double[][] result = pca.copyMatrixAndRemoveColumns(instanceFeatures, constantColumns);
        if (sub.length == 0) {
            return result;
        }
        result = pca.copyMatrixAndKeepColumns(result, sub);
        pca.perColumnOperation(result, means, MessyMathHelperClass.Operation.SUBTRACT);
        pca.perColumnOperation(result, stdDevs, MessyMathHelperClass.Operation.DIVIDE);
        return pca.matrixMultiply(result, pcaVec);
    }

    @Override
    public double[][] getPrePCAInstanceFeatures() {
        return this.prePCAInstanceFeatures;
    }

    @Override
    public double[][] getPCAVectors() {
        return this.pcaVec;
    }

    @Override
    public double[] getPCACoefficients() {
        return this.pcaCoeff;
    }

    @Override
    public int[] getDataRichIndexes() {
        return this.sub;
    }

    @Override
    public double[] getMeans() {
        return this.means;
    }

    @Override
    public double[] getStdDev() {
        return this.stdDevs;
    }

    @Override
    public double[][] getPCAFeatures() {
        return this.pcaFeatures;
    }

    @Override
    public double[][] getConfigs() {
        return this.configs;
    }

    @Override
    public double[] getResponseValues() {
        return this.responseValues;
    }

    @Override
    public int[] getCategoricalSize() {
        return this.configSpace.getCategoricalSize();
    }

    @Override
    public Map<Integer, int[][]> getNameConditionsMapParentsArray() {
        return this.configSpace.getNameConditionsMapParentsArray();
    }

    @Override
    public Map<Integer, double[][][]> getNameConditionsMapParentsValues() {
        return this.configSpace.getNameConditionsMapParentsValues();
    }

    @Override
    public Map<Integer, int[][]> getNameConditionsMapOp() {
        return this.configSpace.getNameConditionsMapOp();
    }

    @Override
    public double transformResponseValue(double d) {
        if (this.logModel) {
            return Math.log10(Math.max(d, 0.005));
        }
        return d;
    }

    @Override
    public int[][] getThetaInstIdxs() {
        int[][] theta_inst_idxs = new int[this.theta_inst_idxs.length][0];
        for (int i = 0; i < theta_inst_idxs.length; ++i) {
            theta_inst_idxs[i] = (int[])this.theta_inst_idxs[i].clone();
        }
        return theta_inst_idxs;
    }

    @Override
    public boolean[] getCensoredResponses() {
        return this.censoredResponseValues;
    }

    @Override
    public int[] getConstantColumns() {
        return this.constantColumnsAt10toMinus6;
    }

    @Override
    public boolean isEmptyFeatures() {
        return this.emptyFeatures;
    }
}

