/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.initialization.table;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aeatk.initialization.table.UnbiasChallengerInitializationProcedureOptions;
import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.aeatk.objectives.ObjectiveHelper;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.termination.TerminationCondition;
import com.beust.jcommander.ParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class UnbiasChallengerInitializationProcedure
implements InitializationProcedure {
    private final ThreadSafeRunHistory runHistory;
    private final ParameterConfiguration initialIncumbent;
    private final TargetAlgorithmEvaluator tae;
    private final UnbiasChallengerInitializationProcedureOptions opts;
    private final Logger log = LoggerFactory.getLogger(UnbiasChallengerInitializationProcedure.class);
    private final List<ProblemInstance> instances;
    private final InstanceSeedGenerator insc;
    private volatile ParameterConfiguration incumbent;
    private final double cutoffTime;
    private final SeedableRandomPool pool;
    private final ParameterConfigurationSpace configSpace;
    private final int numberOfChallengers;
    private final int numberOfRunsPerChallenger;
    private final ObjectiveHelper objHelp;
    private final double cpuTimeLimit;
    private final AlgorithmExecutionConfiguration execConfig;

    public UnbiasChallengerInitializationProcedure(ThreadSafeRunHistory runHistory, ParameterConfiguration initialIncumbent, TargetAlgorithmEvaluator tae, AlgorithmExecutionConfiguration execConfig, UnbiasChallengerInitializationProcedureOptions opts, InstanceSeedGenerator insc, List<ProblemInstance> instances, int maxIncumbentRuns, TerminationCondition termCond, double cutoffTime, SeedableRandomPool pool, boolean deterministicInstanceOrdering, ObjectiveHelper objHelp) {
        this.runHistory = runHistory;
        this.initialIncumbent = initialIncumbent;
        this.tae = tae;
        this.opts = opts;
        this.instances = instances;
        this.execConfig = execConfig;
        this.insc = insc;
        this.incumbent = initialIncumbent;
        this.cutoffTime = cutoffTime;
        this.pool = pool;
        if (deterministicInstanceOrdering) {
            throw new IllegalArgumentException("Deterministic Instance Ordering is not supported at this time with the UnbiasChallengerInitializationProcedure");
        }
        this.configSpace = initialIncumbent.getParameterConfigurationSpace();
        this.cpuTimeLimit = opts.cpulimit;
        if (this.cpuTimeLimit <= 0.0) {
            throw new ParameterException("Time must be greater than zero");
        }
        this.numberOfRunsPerChallenger = opts.numberOfRunsPerChallenger;
        this.numberOfChallengers = opts.numberOfChallengers;
        if (maxIncumbentRuns < this.numberOfRunsPerChallenger) {
            throw new ParameterException("Number of runs per challenger is less than the number permitted:" + maxIncumbentRuns);
        }
        if (!insc.allInstancesHaveSameNumberOfSeeds()) {
            throw new ParameterException("All instances are required to have the same number of seeds available");
        }
        if ((double)this.numberOfChallengers > this.configSpace.getUpperBoundOnSize()) {
            throw new ParameterException("Too many challengers have been requested, configuration space size is at most " + this.configSpace.getUpperBoundOnSize() + " but we want to use " + this.numberOfChallengers);
        }
        if ((double)this.numberOfChallengers > this.configSpace.getLowerBoundOnSize() / 10.0) {
            this.log.warn("Configuration space size ({}) isn't much bigger than the number of challengers we are using in initialization ({}), this isn't an error but depending on conditionality and forbidden rules, we may not be able to satisfy this requirement", (Object)this.configSpace.getLowerBoundOnSize(), (Object)this.numberOfChallengers);
        }
        if (this.numberOfRunsPerChallenger * this.numberOfChallengers <= 0) {
            throw new ParameterException("Challengers requested " + this.numberOfChallengers + " runsPerChallenger:" + this.numberOfRunsPerChallenger + " must both be positive");
        }
        this.objHelp = objHelp;
    }

    @Override
    public void run() {
        try {
            Random rand = this.pool.getRandom("UNBIASED_CHALLENGER_TABLE_INITIALIZATION");
            List<ProblemInstanceSeedPair> selectedPisps = this.getProblemInstanceSeedPairs(rand);
            HashSet<ProblemInstance> selectedPis = new HashSet<ProblemInstance>();
            for (ProblemInstanceSeedPair pisp : selectedPisps) {
                selectedPis.add(pisp.getProblemInstance());
            }
            Set<ParameterConfiguration> thetas = this.getParameterConfigurations(rand, Collections.singleton(this.initialIncumbent));
            List<Pair<ProblemInstanceSeedPair, ParameterConfiguration>> pispConfigs = this.createPairs(rand, selectedPisps, thetas);
            List<AlgorithmRunResult> incumbentRuns = this.scheduleInitialIncumbent(selectedPisps);
            this.initializeRuns(pispConfigs);
            this.log.trace("Waiting for all outstanding evaluations to complete");
            this.tae.waitForOutstandingEvaluations();
            this.log.debug("All outstanding runs completed, inspecting best configuration");
            if (incumbentRuns.size() == 0) {
                throw new IllegalStateException("Expected Default Configuration to have finished running at this point");
            }
            try {
                this.runHistory.append(incumbentRuns);
            }
            catch (DuplicateRunException e) {
                throw new IllegalStateException(e);
            }
            ParameterConfiguration bestConfiguration = this.selectMinimumConfiguration(selectedPis, thetas);
            double minCost = this.runHistory.getEmpiricalCostUpperBound(bestConfiguration, selectedPis, this.cutoffTime);
            double incCost = this.runHistory.getEmpiricalCost(this.initialIncumbent, selectedPis, this.cutoffTime);
            if (incCost > minCost) {
                this.log.debug("Challenger {} ({}) looks better than initial incumbent {} ({}) scheduling censored runs ( {} vs. {} )", new Object[]{this.runHistory.getThetaIdx(bestConfiguration), bestConfiguration, this.runHistory.getThetaIdx(this.initialIncumbent), this.initialIncumbent, minCost, incCost});
                HashSet<ProblemInstanceSeedPair> pispsToRun = new HashSet<ProblemInstanceSeedPair>();
                pispsToRun.addAll(this.runHistory.getEarlyCensoredProblemInstanceSeedPairs(bestConfiguration));
                ArrayList<AlgorithmRunConfiguration> rcs = new ArrayList<AlgorithmRunConfiguration>();
                for (ProblemInstanceSeedPair pisp : pispsToRun) {
                    rcs.add(new AlgorithmRunConfiguration(pisp, this.cutoffTime, bestConfiguration, this.execConfig));
                }
                this.log.debug("Solved runs {} ", this.runHistory.getAlgorithmRunsExcludingRedundant(bestConfiguration));
                this.log.debug("Unsolved {}", rcs);
                this.log.debug("Scheduling {} incomplete runs for {} ({}) ", new Object[]{rcs.size(), this.runHistory.getThetaIdx(bestConfiguration), bestConfiguration});
                List<AlgorithmRunResult> completedRuns = this.tae.evaluateRun(rcs);
                try {
                    this.runHistory.append(completedRuns);
                }
                catch (DuplicateRunException e) {
                    throw new IllegalStateException(e);
                }
                minCost = this.runHistory.getEmpiricalCostUpperBound(bestConfiguration, selectedPis, this.cutoffTime);
            }
            if (incCost > minCost) {
                this.log.debug("Best challengers performance on set is {} versus initial incumbent {}, setting new incumbent", (Object)minCost, (Object)incCost);
                this.incumbent = bestConfiguration;
            } else {
                this.log.debug("Best challengers performance on set is {} versus initial incumbent {}, leaving incumbent alone", (Object)minCost, (Object)incCost);
                this.incumbent = this.initialIncumbent;
            }
            this.log.debug("Initialization procedure completed ({} total runs, total cpu time used {}), selected incumbent is {} ({})", new Object[]{this.runHistory.getAlgorithmRunDataExcludingRedundant().size(), this.runHistory.getTotalRunCost(), this.runHistory.getThetaIdx(this.incumbent), this.incumbent.getFriendlyIDHex()});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.incumbent = this.initialIncumbent;
            return;
        }
    }

    private ParameterConfiguration selectMinimumConfiguration(Set<ProblemInstance> selectedPis, Set<ParameterConfiguration> thetas) {
        double minCost = Double.MAX_VALUE;
        ParameterConfiguration bestConfiguration = null;
        for (ParameterConfiguration config : thetas) {
            double cost = this.runHistory.getEmpiricalCost(config, selectedPis, this.cutoffTime);
            if (bestConfiguration == null) {
                bestConfiguration = config;
            }
            if (!(minCost > cost)) continue;
            bestConfiguration = config;
            minCost = cost;
        }
        return bestConfiguration;
    }

    private void initializeRuns(List<Pair<ProblemInstanceSeedPair, ParameterConfiguration>> pispConfigs) throws InterruptedException {
        final LinkedBlockingQueue<Pair<ProblemInstanceSeedPair, ParameterConfiguration>> unSolvedPispThetasQueue = new LinkedBlockingQueue<Pair<ProblemInstanceSeedPair, ParameterConfiguration>>();
        unSolvedPispThetasQueue.addAll(pispConfigs);
        final Set solvedPisps = Collections.newSetFromMap(new ConcurrentHashMap());
        final AtomicBoolean killNow = new AtomicBoolean(false);
        TargetAlgorithmEvaluatorRunObserver killAtTimeoutObserver = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (killNow.get()) {
                    for (AlgorithmRunResult algorithmRunResult : runs) {
                        if (algorithmRunResult.getRunStatus() != RunStatus.RUNNING) continue;
                        UnbiasChallengerInitializationProcedure.this.log.trace("Killing run {} ", (Object)algorithmRunResult);
                        algorithmRunResult.kill();
                    }
                }
            }
        };
        int allPairsSize = pispConfigs.size();
        final Semaphore runCompleted = new Semaphore(unSolvedPispThetasQueue.size());
        ConcurrentHashMap<Pair, Double> nextCutoffTime = new ConcurrentHashMap<Pair, Double>();
        for (Pair<ProblemInstanceSeedPair, ParameterConfiguration> p : pispConfigs) {
            nextCutoffTime.put(p, -1.0);
        }
        block1: while (true) {
            int i = 0;
            while (true) {
                if (i >= pispConfigs.size()) continue block1;
                while (!runCompleted.tryAcquire(1L, TimeUnit.SECONDS)) {
                }
                final Pair pair = (Pair)unSolvedPispThetasQueue.poll();
                if (pair == null) {
                    if (solvedPisps.size() == allPairsSize) {
                        this.log.trace("All runs are considered done");
                        break block1;
                    }
                    --i;
                } else {
                    TargetAlgorithmEvaluatorCallback taeCallback = new TargetAlgorithmEvaluatorCallback(){

                        @Override
                        public void onSuccess(List<AlgorithmRunResult> runs) {
                            try {
                                UnbiasChallengerInitializationProcedure.this.runHistory.append(runs);
                            }
                            catch (DuplicateRunException e) {
                                throw new IllegalStateException(e);
                            }
                            if (runs.get(0).getRunStatus().isDecided() || !runs.get(0).getAlgorithmRunConfiguration().hasCutoffLessThanMax()) {
                                if (runs.get(0).getRunStatus().isDecided()) {
                                    UnbiasChallengerInitializationProcedure.this.log.debug("Run completed successfully: {} ", (Object)runs.get(0));
                                }
                                solvedPisps.add(pair);
                            } else {
                                unSolvedPispThetasQueue.add(pair);
                            }
                            runCompleted.release();
                        }

                        @Override
                        public void onFailure(RuntimeException e) {
                            UnbiasChallengerInitializationProcedure.this.log.error("Error occurred during initialization", (Throwable)e);
                        }
                    };
                    double kappa = this.getNextKappa(pair, allPairsSize, solvedPisps.size(), (Double)nextCutoffTime.get(pair));
                    if (this.runHistory.getTotalRunCost() > this.cpuTimeLimit) {
                        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss.SSS");
                        this.log.debug("Initialization procedure has used {}, time limit: {}, halting procedure at {}...", new Object[]{this.runHistory.getTotalRunCost(), this.cpuTimeLimit, sdf.format(new Date())});
                        killNow.set(true);
                        break block1;
                    }
                    if (kappa < 0.0) {
                        throw new IllegalStateException("Still continuing with run, but the kappa time is zero.");
                    }
                    nextCutoffTime.put(pair, kappa);
                    this.tae.evaluateRunsAsync(Collections.singletonList(new AlgorithmRunConfiguration((ProblemInstanceSeedPair)pair.getFirst(), kappa, (ParameterConfiguration)pair.getSecond(), this.execConfig)), taeCallback, killAtTimeoutObserver);
                }
                ++i;
            }
            break;
        }
    }

    public double getNextKappa(Pair<ProblemInstanceSeedPair, ParameterConfiguration> pair, int allPairsSize, int solvedPisSize, double lastKappa) {
        double kappaFromShareRemaining = (this.cpuTimeLimit - this.runHistory.getTotalRunCost()) / (double)(allPairsSize - solvedPisSize);
        double kappaNextStep = 2.0 * lastKappa;
        double kappaMax = this.cutoffTime;
        double kappa = Math.min(Math.max(kappaNextStep, kappaFromShareRemaining), kappaMax);
        return Math.max(kappa, 1.0);
    }

    @Override
    public ParameterConfiguration getIncumbent() {
        return this.incumbent;
    }

    private List<AlgorithmRunResult> scheduleInitialIncumbent(List<ProblemInstanceSeedPair> selectedPisps) {
        final List<AlgorithmRunResult> incumbentRuns = Collections.synchronizedList(new ArrayList(selectedPisps.size()));
        ArrayList<AlgorithmRunConfiguration> rcs = new ArrayList<AlgorithmRunConfiguration>(selectedPisps.size());
        for (ProblemInstanceSeedPair pisp : selectedPisps) {
            rcs.add(new AlgorithmRunConfiguration(pisp, this.cutoffTime, this.initialIncumbent, this.execConfig));
        }
        this.runHistory.getOrCreateThetaIdx(this.initialIncumbent);
        this.log.debug("Scheduling {} runs for initial configuration", (Object)rcs.size());
        this.tae.evaluateRunsAsync(rcs, new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                UnbiasChallengerInitializationProcedure.this.log.debug("Default configuration runs are done");
                incumbentRuns.addAll(runs);
            }

            @Override
            public void onFailure(RuntimeException e) {
                UnbiasChallengerInitializationProcedure.this.log.error("Error occurred during initialization", (Throwable)e);
            }
        });
        return incumbentRuns;
    }

    private List<Pair<ProblemInstanceSeedPair, ParameterConfiguration>> createPairs(Random rand, List<ProblemInstanceSeedPair> selectedPisps, Set<ParameterConfiguration> thetas) {
        ArrayList<Pair<ProblemInstanceSeedPair, ParameterConfiguration>> pispConfigs = new ArrayList<Pair<ProblemInstanceSeedPair, ParameterConfiguration>>(thetas.size() * selectedPisps.size());
        for (ParameterConfiguration config : thetas) {
            for (ProblemInstanceSeedPair pisp : selectedPisps) {
                pispConfigs.add(new Pair<ProblemInstanceSeedPair, ParameterConfiguration>(pisp, config));
            }
        }
        Collections.shuffle(pispConfigs, rand);
        return pispConfigs;
    }

    private Set<ParameterConfiguration> getParameterConfigurations(Random rand, Set<ParameterConfiguration> excluded) {
        this.log.debug("Generating {} configurations for use in initialization", (Object)this.numberOfChallengers);
        HashSet<ParameterConfiguration> thetas = new HashSet<ParameterConfiguration>(this.numberOfChallengers);
        thetas.addAll(excluded);
        while (thetas.size() - excluded.size() < this.numberOfChallengers) {
            boolean created = false;
            for (int i = 0; i < 1000; ++i) {
                ParameterConfiguration config = this.configSpace.getRandomParameterConfiguration(rand);
                if (config.equals(this.configSpace.getDefaultConfiguration())) {
                    --i;
                    continue;
                }
                boolean newConfiguration = thetas.add(config);
                if (!newConfiguration) continue;
                created = true;
                break;
            }
            if (created) continue;
            throw new IllegalStateException("After 1000 attempts we were unable to generate another unique configuration. We already have " + thetas.size() + " this can happen if you request too many configurations in initialization, or if the space is incredibly conditional / has many forbidden configurations.");
        }
        thetas.removeAll(excluded);
        return thetas;
    }

    private List<ProblemInstanceSeedPair> getProblemInstanceSeedPairs(Random rand) {
        ArrayList<ProblemInstanceSeedPair> selectedPisps = new ArrayList<ProblemInstanceSeedPair>();
        this.log.debug("Generating {} Problem Instance Seed Pairs for use in initialization", (Object)this.numberOfRunsPerChallenger);
        ArrayList<ProblemInstance> shuffledPis = new ArrayList<ProblemInstance>(this.instances);
        Collections.shuffle(shuffledPis, rand);
        block0: while (selectedPisps.size() < this.numberOfRunsPerChallenger) {
            for (ProblemInstance pi : shuffledPis) {
                if (!this.insc.hasNextSeed(pi)) {
                    throw new IllegalStateException("Should not have been able to generate this many requests for configurations");
                }
                long seed = this.insc.getNextSeed(pi);
                ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, seed);
                selectedPisps.add(pisp);
                if (selectedPisps.size() < this.numberOfRunsPerChallenger) continue;
                continue block0;
            }
        }
        return selectedPisps;
    }
}

