/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.jsonexecutor;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.example.jsonexecutor.JSONExecutorOptions;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.WaitableTAECallback;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONExecutor {
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JSONExecutorOptions mainOptions = new JSONExecutorOptions();
        Map<String, AbstractOptions> taeOptions = mainOptions.taeOptions.getAvailableTargetAlgorithmEvaluators();
        try {
            try {
                JCommander jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, mainOptions, taeOptions);
                mainOptions.logOpts.initializeLogging();
            }
            finally {
                log = LoggerFactory.getLogger(JSONExecutor.class);
            }
            try (TargetAlgorithmEvaluator tae = mainOptions.taeOptions.getTargetAlgorithmEvaluator(taeOptions);){
                log.info("Waiting for an array of AlgorithmRunConfiguration in JSON format to be recieved on STDIN. You can use the algo-test utility --print-json true to get example JSON.");
                JsonFactory jfactory = new JsonFactory();
                ObjectMapper map = new ObjectMapper(jfactory);
                SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
                map.registerModule((Module)sModule);
                JsonParser jParser = jfactory.createParser(System.in);
                ArrayList<Object> runsToDo = new ArrayList<Object>(Arrays.asList((Object[])map.readValue(jParser, AlgorithmRunConfiguration[].class)));
                final AtomicBoolean outputCompleted = new AtomicBoolean(false);
                TargetAlgorithmEvaluatorRunObserver taeRunObserver = new TargetAlgorithmEvaluatorRunObserver(){

                    @Override
                    public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                        int total = runs.size();
                        int completed = 0;
                        int notStarted = 0;
                        int started = 0;
                        for (AlgorithmRunResult algorithmRunResult : runs) {
                            if (algorithmRunResult.isRunCompleted()) {
                                ++completed;
                                continue;
                            }
                            if (algorithmRunResult.getRuntime() > 0.0 || algorithmRunResult.getWallclockExecutionTime() > 0.0) {
                                ++started;
                                continue;
                            }
                            ++notStarted;
                        }
                        if (!outputCompleted.get()) {
                            log.info("Current Run Status, Total: {} , Started: {} , Completed: {}, Not Started: {}", new Object[]{total, started, completed, notStarted});
                        }
                    }
                };
                WaitableTAECallback taeCallback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

                    @Override
                    public void onSuccess(List<AlgorithmRunResult> runs) {
                        ObjectMapper map = new ObjectMapper();
                        JsonFactory factory = new JsonFactory();
                        factory.setCodec((ObjectCodec)map);
                        try {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            JsonGenerator g = factory.createGenerator((OutputStream)bout);
                            SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
                            map.configure(SerializationFeature.INDENT_OUTPUT, true);
                            map.registerModule((Module)sModule);
                            ArrayList<AlgorithmRunResult> results2 = new ArrayList<AlgorithmRunResult>(runs);
                            g.writeObject(results2);
                            g.flush();
                            System.out.flush();
                            System.out.println("******JSON******\n" + bout.toString("UTF-8") + "\n********");
                            System.out.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onFailure(RuntimeException e) {
                        e.printStackTrace();
                    }
                });
                if (mainOptions.printStatus) {
                    log.info("Periodically printing status, use --print-status false to disable");
                    tae.evaluateRunsAsync(runsToDo, taeCallback, taeRunObserver);
                } else {
                    tae.evaluateRunsAsync(runsToDo, (TargetAlgorithmEvaluatorCallback)taeCallback);
                }
                if (!tae.areRunsPersisted() || mainOptions.waitForPersistedRunCompletion) {
                    log.debug("Waiting until validation completion");
                    taeCallback.waitForCompletion();
                } else if (tae.getNumberOfOutstandingBatches() > 1 && mainOptions.printStatus) {
                    System.out.flush();
                    System.out.println("Runs Submitted... Re-execute this utility to get the results.");
                    System.out.flush();
                }
                outputCompleted.set(true);
            }
        }
        catch (ParameterException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", (Throwable)e);
            }
            System.exit(1);
        }
        catch (Exception e) {
            System.exit(255);
        }
    }
}

