/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public strictfp class RegtreeBuildParams
implements Serializable {
    private static final long serialVersionUID = -6803645785543626390L;
    public int[] catDomainSizes;
    public Map<Integer, int[][]> nameConditionsMapParentsArray;
    public Map<Integer, double[][][]> nameConditionsMapParentsValues;
    public Map<Integer, int[][]> nameConditionsMapOp;
    public double minVariance;
    public int splitMin;
    public boolean doBootstrapping = true;
    public double ratioFeatures;
    public int logModel;
    public boolean storeResponses;
    public long seed = -1L;
    public Random random = null;
    public boolean brokenVarianceCalculation = true;

    public RegtreeBuildParams(int numVars, boolean doBootstrapping) {
        this(numVars, doBootstrapping, 10);
    }

    public RegtreeBuildParams(int numVars, boolean doBootstrapping, int splitMin) {
        this(numVars, doBootstrapping, splitMin, 0.6666666666666666);
    }

    public RegtreeBuildParams(boolean doBootstrapping, int splitMin, int[] catDomainSizes) {
        this(doBootstrapping, splitMin, 0.6666666666666666, catDomainSizes);
    }

    public RegtreeBuildParams(int numVars, boolean doBootstrapping, int splitMin, double ratioFeatures) {
        this(doBootstrapping, splitMin, ratioFeatures, new int[numVars]);
    }

    public RegtreeBuildParams(boolean doBootstrapping, int splitMin, double ratioFeatures, int[] catDomainSizes) {
        this.catDomainSizes = catDomainSizes;
        this.doBootstrapping = doBootstrapping;
        this.splitMin = splitMin;
        this.ratioFeatures = ratioFeatures;
        this.random = new Random(3L);
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("catDomain: (" + (this.catDomainSizes != null ? Integer.valueOf(this.catDomainSizes.length) : "null") + ")");
            sb.append(Arrays.toString(this.catDomainSizes));
            sb.append("\n");
            sb.append("\n");
            sb.append("\n");
            sb.append("\nSplitMin:" + this.splitMin);
            sb.append("\nRatioFeatures:" + this.ratioFeatures);
            sb.append("\nLogModel:" + this.logModel);
            sb.append("\nStoreResponses:" + this.storeResponses);
            return sb.toString();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "RuntimeException occured building RegtreeBuildPalams";
        }
    }

    public void setSplitMin(int splitMin) {
        this.splitMin = splitMin;
    }

    public void setLogModel(int logModel) {
        this.logModel = logModel;
    }

    public static RegtreeBuildParams copy(RegtreeBuildParams bp, int size) {
        RegtreeBuildParams bpNew = new RegtreeBuildParams(size, bp.doBootstrapping);
        bpNew.logModel = bp.logModel;
        bpNew.brokenVarianceCalculation = bp.brokenVarianceCalculation;
        bpNew.catDomainSizes = new int[size];
        System.arraycopy(bp.catDomainSizes, 0, bpNew.catDomainSizes, 0, size);
        bpNew.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>(bp.nameConditionsMapParentsArray);
        bpNew.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>(bp.nameConditionsMapParentsValues);
        bpNew.nameConditionsMapOp = new HashMap<Integer, int[][]>(bp.nameConditionsMapOp);
        bpNew.random = bp.random;
        bpNew.ratioFeatures = bp.ratioFeatures;
        bpNew.minVariance = bp.minVariance;
        bpNew.splitMin = bp.splitMin;
        bpNew.storeResponses = bp.storeResponses;
        bpNew.seed = bp.seed;
        return bpNew;
    }
}

