import java.io.*;
import java.net.*;
import java.util.Vector;

public class Pdb {
    
    private String PdbID;
    
    public Pdb() {
    }
    
    public Pdb(String id) {
	this.PdbID = id;
    }
    
    public String getID(){
	return PdbID;
    }
    
    public Protein getAtomicCoord(){
	String Line;
	Vector Atoms = new Vector();
	
	try{
	    URL url = new URL("http://www.rcsb.org/pdb/cgi/export.cgi/"+PdbID+".pdb?format=PDB&pdbId="+PdbID+"&compression=None");
	    BufferedReader Buffer = new BufferedReader(new InputStreamReader(url.openStream()));
	    
	    while((Line = Buffer.readLine()) != null){
		if(((Line.substring(0,6)).trim()).equals(new String("ATOM"))){
		Atom a = new Atom(Integer.parseInt(Line.substring(22,26).trim()),Line.charAt(21),Line.substring(12,16).trim(),Line.substring(17,20).trim(),Double.parseDouble(Line.substring(30,38).trim()),Double.parseDouble(Line.substring(38,46).trim()),Double.parseDouble(Line.substring(46,54).trim()));
		Atoms.add(a);
		}
	    }
	}catch(UnknownHostException e){System.out.println(e);}
	catch(MalformedURLException e){System.out.println(e);}
	catch(IOException e){System.out.println(e);}
	
	return new Protein(PdbID,Atoms);
    }
    
    public static Protein getAtomicCoord(String PdbID){
	String Line;
	Vector Atoms = new Vector();
	
	try{
	    URL url = new URL("http://www.rcsb.org/pdb/cgi/export.cgi/"+PdbID+".pdb?format=PDB&pdbId="+PdbID+"&compression=None");
	    BufferedReader Buffer = new BufferedReader(new InputStreamReader(url.openStream()));
	    
	    while((Line = Buffer.readLine()) != null){
		if(((Line.substring(0,6)).trim()).equals(new String("ATOM"))){
		Atom a = new Atom(Integer.parseInt(Line.substring(22,26).trim()),Line.charAt(21),Line.substring(12,16).trim(),Line.substring(17,20).trim(),Double.parseDouble(Line.substring(30,38).trim()),Double.parseDouble(Line.substring(38,46).trim()),Double.parseDouble(Line.substring(46,54).trim()));
		Atoms.add(a);
		}
	    }
	}catch(UnknownHostException e){System.out.println(e);}
	catch(MalformedURLException e){System.out.println(e);}
	catch(IOException e){System.out.println(e);}
	
	return new Protein(PdbID,Atoms);
    }   
}
