import java.io.*;
import java.util.Vector;
import java.util.Iterator;

public class Domain {

    private String DomainName;
    private Vector Atoms;
    private BBox B;

    public Domain() {
	DomainName = null;
	Atoms = new Vector();
	B = new BBox();
    }

    public Domain(String DomainName) {
	this.DomainName = DomainName;
	Atoms = new Vector();
	B = new BBox();
    }

    public Domain(String DomainName, Vector Atoms) {
	this.DomainName = DomainName;
	this.Atoms = Atoms;
	B = new BBox();
    }

    public String getDomainName() {
	return DomainName;
    }

    public void setDomainName(String DomainName) {
	this.DomainName = DomainName;
    }

    public int getNoAtoms(){
	return Atoms.size();
    }

    public Object [] getAtomsArray() {
        return Atoms.toArray();
    }

    public Vector getAtomsVector() {
	return Atoms;
    }

    public Domain cloneDomain() {
	return new Domain(getDomainName(),copyAtoms());
    }
    
    public Vector copyAtoms() {
	Vector newAtoms = new Vector();
	for (Iterator i = Atoms.iterator(); i.hasNext();){
	    Atom atom = (Atom)i.next();
	    Atom newAtom = new Atom(atom.getAtomID(),atom.getChainID(),atom.getElement(),atom.getResidue(),atom.x,atom.y,atom.z);
	    newAtoms.addElement(newAtom);
	}
	return newAtoms;
    }
    
    public void addAtom(Atom a) {
	Atoms.add(a);
    }
    
    public void deleteAtoms(BBox C){
	int j=0;
	int size=this.getNoAtoms();
	Atom atom = new Atom();
	boolean[] flag = new boolean[size];
	
	for (Iterator i = Atoms.iterator(); i.hasNext();){
	    atom=(Atom)i.next();
	    if(!(atom.x>=C.xmin&&atom.x<=C.xmax&&atom.y>=C.ymin&&atom.y<=C.ymax&&atom.z>=C.zmin&&atom.z<=C.zmax)){
		flag[j++]=true;
	    }else{
		flag[j++]=false;
	    }
	}
	
	int pad=0;
	for(j=0;j<size;j++){
	    if(flag[j]){
		Atoms.removeElementAt(j+pad);
		pad--;
	    }
	}
    }
    
    public BBox getBBox(){
	B.resetBBox();
	for (Iterator i = Atoms.iterator(); i.hasNext();){
	    Atom P = (Atom)i.next();
	    if(P.x>=B.xmax)
		B.xmax=P.x;
	    if(P.x<=B.xmin)
		B.xmin=P.x;
	    if(P.y>=B.ymax)
		B.ymax=P.y;
	    if(P.y<=B.ymin)
		B.ymin=P.y;
	    if(P.z>=B.zmax)
		B.zmax=P.z;
	    if(P.z<=B.zmin)
		B.zmin=P.z;
	}
	B.xmax=B.xmax+DomainInter.THRES;
	B.xmin=B.xmin-DomainInter.THRES;
	B.ymax=B.ymax+DomainInter.THRES;
	B.ymin=B.ymin-DomainInter.THRES;
	B.zmax=B.zmax+DomainInter.THRES;
	B.zmin=B.zmin-DomainInter.THRES;
	return B;
    }
    
    public int getNoAtoms(BBox C){
	int counter = 0;
	for (Iterator i = Atoms.iterator(); i.hasNext();){
	    Atom atom = (Atom)i.next();
	    if(atom.x>=C.xmin&&atom.x<=C.xmax&&atom.y>=C.ymin&&atom.y<=C.ymax&&atom.z>=C.zmin&&atom.z<=C.zmax){
		atom.setInteraction(true);
		counter++;
	    }
	}
	return counter;
    }
    
    public void print2File(){
	try{
	PrintWriter fileOut = new PrintWriter(new FileWriter(this.DomainName+".txt"));
	fileOut.println("Protein Domain: "+DomainName+", Size: "+this.getNoAtoms()+" ,List of X Y Z Coordinates:");
	for (Iterator i = Atoms.iterator(); i.hasNext();)
	      fileOut.println(i.next().toString());
	fileOut.println("Bounded Box: "+B.toString());
	fileOut.close();
	}catch(IOException e){System.out.println(e);}
    }
   
   public void print2File(String postfix){
	try{
	PrintWriter fileOut = new PrintWriter(new FileWriter(this.DomainName+"_"+postfix+".txt"));
	fileOut.println("Protein Domain: "+DomainName+", Size: "+this.getNoAtoms()+" ,List of X Y Z Coordinates:");
	for (Iterator i = Atoms.iterator(); i.hasNext();)
	      fileOut.println(i.next().toString());
	fileOut.println("Bounded Box: "+B.toString());
	fileOut.close();
	}catch(IOException e){System.out.println(e);}
    }

    //Known bug, write terminates before finish
    public void printVRML(){
	try{
	    PrintWriter pw = new PrintWriter(new FileWriter(this.DomainName+".wrl"));
	    
	    //Write header
	    pw.println("#VRML V1.0 ascii");
	    pw.println("Separator {");
	    pw.println("DirectionalLight {");
	    pw.println("direction 0 0 -1");
	    pw.println("}");
	    
	    //Write atoms of domain
	    for (Iterator i = Atoms.iterator(); i.hasNext();){
		Atom a = (Atom)i.next();
		pw.println("Separator {");
		pw.println("Material {");
		pw.println("diffuseColor 1 0.8 0.4");
		pw.println("}");
		pw.println("Translation { translation "+a.x+" "+a.y+" "+a.z+" }");
		pw.println("Sphere{radius 1}");
		pw.println("}");
	    }
	    
	    pw.println("}");
	}catch(IOException e){System.out.println(e);}
    }
}
