/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.racing.statistics;

import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.racing.statistics.ConfidenceIntervals;
import ca.ubc.cs.beta.racing.statistics.TestResult;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Statistics {
    public static final int MEAN = -1;
    public static final int MEDIAN = 50;
    public static final int STDEV = -2;
    public static final int MIN = 0;
    public static final int MAX = 100;

    public static final int PERCENTILE(int pct) {
        return pct;
    }

    public TestResult wilcoxonTest(List<Double> listA, List<Double> listB, Double mu, Alternative alternative, Boolean paired) {
        if (listA == null) {
            throw new IllegalArgumentException("listA cannot be null");
        }
        double[] x = new double[listA.size()];
        double[] y = null;
        int i = 0;
        while (i < listA.size()) {
            x[i] = listA.get(i);
            ++i;
        }
        if (listB != null) {
            y = new double[listB.size()];
            i = 0;
            while (i < listB.size()) {
                y[i] = listB.get(i);
                ++i;
            }
        }
        return this.wilcoxonTest(x, y, mu, alternative, paired);
    }

    public TestResult spearmanTest(List<Double> listA, List<Double> listB, Alternative alternative) {
        if (listA == null || listB == null) {
            throw new IllegalArgumentException("listA and listB cannot be null");
        }
        double[] x = new double[listA.size()];
        double[] y = null;
        int i = 0;
        while (i < listA.size()) {
            x[i] = listA.get(i);
            ++i;
        }
        if (listB != null) {
            y = new double[listB.size()];
            i = 0;
            while (i < listB.size()) {
                y[i] = listB.get(i);
                ++i;
            }
        }
        return this.spearmanTest(x, y, alternative);
    }

    public TestResult friedmanTest(List<List<Double>> lists) {
        Pair<TestResult, double[][]> result = this.friedmanTestWithRanks(lists);
        return (TestResult)result.getFirst();
    }

    public Pair<TestResult, double[][]> friedmanTestWithRanks(List<List<Double>> lists) {
        if (lists.size() < 2) {
            throw new IllegalArgumentException("Must have at least 2 paired samples");
        }
        int i = 1;
        while (i < lists.size()) {
            if (lists.get(i).size() != lists.get(0).size()) {
                throw new IllegalArgumentException("all data sets must be the same length");
            }
            ++i;
        }
        double[][] data = new double[lists.get(0).size()][lists.size()];
        int i2 = 0;
        while (i2 < lists.size()) {
            List<Double> l = lists.get(i2);
            int j = 0;
            while (j < l.size()) {
                data[j][i2] = l.get(j);
                ++j;
            }
            ++i2;
        }
        System.out.println(this.getClass() + " : calling friedmanTest()");
        return this.friedmanTestWithRanks(data);
    }

    protected boolean getNormal(double[] x, double[] y, boolean paired) {
        if (x.length < 50 && (y == null || y.length < 50)) {
            HashSet<Double> xset = new HashSet<Double>();
            HashSet<Double> yset = new HashSet<Double>();
            if (y == null) {
                double[] dArray = x;
                int n = x.length;
                int n2 = 0;
                while (n2 < n) {
                    double d = dArray[n2];
                    xset.add(d);
                    ++n2;
                }
                if (xset.size() < 50) {
                    return false;
                }
            } else if (paired) {
                int i = 0;
                while (i < x.length) {
                    xset.add(x[i] - y[i]);
                    ++i;
                }
                if (xset.size() < 50) {
                    return false;
                }
            } else {
                double d;
                double[] dArray = x;
                int n = x.length;
                int n3 = 0;
                while (n3 < n) {
                    d = dArray[n3];
                    xset.add(d);
                    ++n3;
                }
                dArray = y;
                n = y.length;
                n3 = 0;
                while (n3 < n) {
                    d = dArray[n3];
                    yset.add(d);
                    ++n3;
                }
                if (yset.size() < 50 && xset.size() < 50) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean getPaired(double[] x, double[] y) {
        return x != null && y != null && x.length == y.length;
    }

    public abstract TestResult wilcoxonTest(double[] var1, double[] var2, Double var3, Alternative var4, Boolean var5);

    public abstract TestResult spearmanTest(double[] var1, double[] var2, Alternative var3);

    public abstract TestResult friedmanTest(double[][] var1);

    public abstract Pair<TestResult, double[][]> friedmanTestWithRanks(double[][] var1);

    public abstract boolean isPermutationTestSupported();

    public abstract TestResult permutationTest(double[] var1, double[] var2, Alternative var3, Boolean var4);

    public abstract TestResult permutationTest(double[] var1, double[] var2, Alternative var3, PermutationTestMethod var4);

    public abstract Set<String> getSupportedBootstrapCISemantics();

    public abstract ConfidenceIntervals bootstrapCI(double[] var1, int var2, double var3, Set<String> var5);

    public abstract double studentTQuantile(double var1, double var3);

    public static enum Alternative {
        TWO_SIDED,
        GREATER,
        LESS;

    }

    public static enum PermutationTestMethod {
        PCLT,
        EXACT_NETWORK,
        EXACT_MONTE_CARLO,
        EXACT_COMPLETE_ENUMERATION;

    }
}

