/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.racing.statistics;

import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.racing.statistics.ConfidenceIntervals;
import ca.ubc.cs.beta.racing.statistics.Statistics;
import ca.ubc.cs.beta.racing.statistics.TestResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import jsc.correlation.SpearmanCorrelation;
import jsc.datastructures.MatchedData;
import jsc.datastructures.PairedData;
import jsc.distributions.StudentsT;
import jsc.independentsamples.MannWhitneyTest;
import jsc.onesample.WilcoxonTest;
import jsc.relatedsamples.FriedmanTest;
import jsc.tests.H1;

public final class JscStatistics
extends Statistics {
    private static final JscStatistics inst = new JscStatistics();

    private JscStatistics() {
    }

    public static JscStatistics getInstance() {
        return inst;
    }

    @Override
    public Pair<TestResult, double[][]> friedmanTestWithRanks(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Must provide data");
        }
        FriedmanTest test = null;
        try {
            test = new FriedmanTest(new MatchedData(data));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error in JSC doign Freiedman test for: " + Arrays.deepToString((Object[])data) + " trying the chi-squared approximation instead.", e);
        }
        try {
            test = new FriedmanTest(new MatchedData(data), 0.0, false);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error in JSC backup Friedman test using Chi-squared calculation...", e);
        }
        try {
            TestResult ret = new TestResult();
            ret.setP(Math.max(0.0, Math.min(1.0, test.getSP())));
            ret.setStatistic(test.getTestStatistic());
            MatchedData rankData = test.getRanks();
            double[][] ranks = rankData.getData();
            return new Pair((Object)ret, (Object)ranks);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error in JSC doing Friedman test post-processing.", e);
        }
    }

    @Override
    public TestResult friedmanTest(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Must provide data");
        }
        try {
            FriedmanTest test = new FriedmanTest(new MatchedData(data));
            TestResult ret = new TestResult();
            ret.setP(Math.max(0.0, Math.min(1.0, test.getSP())));
            ret.setStatistic(test.getTestStatistic());
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error in JSC doign Freiedman test for: " + Arrays.deepToString((Object[])data), e);
        }
    }

    @Override
    public TestResult spearmanTest(double[] x, double[] y, Statistics.Alternative alternative) {
        if (x == null || y == null || x.length != y.length) {
            throw new IllegalArgumentException("x and y must be equal-length lists");
        }
        if (alternative == null) {
            alternative = Statistics.Alternative.TWO_SIDED;
        }
        H1 alt = alternative == null || alternative == Statistics.Alternative.TWO_SIDED ? H1.NOT_EQUAL : (alternative == Statistics.Alternative.LESS ? H1.LESS_THAN : H1.GREATER_THAN);
        PairedData data = new PairedData(x, y);
        SpearmanCorrelation out = new SpearmanCorrelation(data, alt);
        TestResult ret = new TestResult();
        ret.setP(Math.max(0.0, Math.min(out.getSP(), 1.0)));
        ret.setStatistic(out.getTestStatistic());
        return ret;
    }

    @Override
    public TestResult wilcoxonTest(double[] x, double[] y, Double mu, Statistics.Alternative alternative, Boolean paired) {
        H1 alt;
        WilcoxonTest out = null;
        paired = paired == null ? this.getPaired(x, y) : paired.booleanValue();
        boolean normal = this.getNormal(x, y, paired);
        if (alternative != null && alternative != Statistics.Alternative.GREATER && alternative != Statistics.Alternative.LESS && alternative != Statistics.Alternative.TWO_SIDED) {
            throw new IllegalArgumentException("Unrecognized alternative; use Statistics.GREATER, Statistics.LESS, or Statistics.TWO_SIDED");
        }
        if (mu == null) {
            mu = 0.0;
        }
        if (alternative == null) {
            alternative = Statistics.Alternative.TWO_SIDED;
        }
        H1 h1 = alternative == null || alternative == Statistics.Alternative.TWO_SIDED ? H1.NOT_EQUAL : (alt = alternative == Statistics.Alternative.LESS ? H1.LESS_THAN : H1.GREATER_THAN);
        if (y == null) {
            out = new WilcoxonTest(x, mu.doubleValue(), alt, 0.0, true, normal);
        } else if (!Boolean.FALSE.equals(paired) && x.length == y.length) {
            if (mu != 0.0) {
                throw new IllegalArgumentException("can't handle nonzero mu in paired data jsc mode");
            }
            PairedData data = new PairedData(x, y);
            out = new WilcoxonTest(data, alt, 0.0, true, normal);
        } else if (y != null && (x.length != y.length || paired != null && !paired.booleanValue())) {
            if (mu != 0.0) {
                throw new IllegalArgumentException("can't handle nonzero mu in unpaired data jsc mode");
            }
            out = new MannWhitneyTest(x, y, alt, 0.0, normal);
        } else {
            throw new IllegalArgumentException("Can't seem to run your request");
        }
        TestResult ret = new TestResult();
        ret.setP(Math.max(0.0, Math.min(out.getSP(), 1.0)));
        ret.setStatistic(out.getTestStatistic());
        return ret;
    }

    @Override
    public boolean isPermutationTestSupported() {
        return false;
    }

    @Override
    public TestResult permutationTest(double[] x, double[] y, Statistics.Alternative alternative, Boolean exact) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TestResult permutationTest(double[] x, double[] y, Statistics.Alternative alternative, Statistics.PermutationTestMethod method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getSupportedBootstrapCISemantics() {
        return Collections.emptySet();
    }

    @Override
    public ConfidenceIntervals bootstrapCI(double[] data, int reps, double confidenceLevel, Set<String> semantics) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double studentTQuantile(double p, double dof) {
        StudentsT distribution = new StudentsT(dof);
        return distribution.inverseCdf(p);
    }
}

