/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.racing.statistics;

public class ConfidenceInterval {
    private final double lowerLimit;
    private final double upperLimit;
    private final double confidenceCoeff;

    public ConfidenceInterval(double lowerLimit, double upperLimit, double confidenceCoeff) {
        if (confidenceCoeff < 0.0 || confidenceCoeff > 1.0) {
            throw new IllegalArgumentException("Invalid confidenceCoeff: " + confidenceCoeff);
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.confidenceCoeff = confidenceCoeff;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public double getConfidenceCoeff() {
        return this.confidenceCoeff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<coeff:").append(this.confidenceCoeff).append(" [").append(this.lowerLimit).append(",").append(this.upperLimit).append("]>");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !ConfidenceInterval.class.equals(obj.getClass())) {
            return false;
        }
        ConfidenceInterval other = (ConfidenceInterval)obj;
        return Double.doubleToLongBits(this.confidenceCoeff) == Double.doubleToLongBits(other.confidenceCoeff) && Double.doubleToLongBits(this.lowerLimit) == Double.doubleToLongBits(other.lowerLimit) && Double.doubleToLongBits(this.upperLimit) == Double.doubleToLongBits(other.upperLimit);
    }
}

