/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.racing;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.eventsystem.EventManager;
import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.WaitableTAECallback;
import ca.ubc.cs.beta.racing.FRaceOptions;
import ca.ubc.cs.beta.racing.statistics.JscStatistics;
import ca.ubc.cs.beta.racing.statistics.Statistics;
import ca.ubc.cs.beta.racing.statistics.TestResult;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FRace {
    private static Logger log = LoggerFactory.getLogger(FRace.class);
    private EventManager eventManager;

    public void setEventManager(EventManager e) {
        this.eventManager = e;
    }

    public FRaceResult doRace(TargetAlgorithmEvaluator evaluator, AlgorithmExecutionConfiguration executionConfiguration, List<ParameterConfiguration> configurations, List<ProblemInstance> instances, InstanceSeedGenerator instanceSeedGenerator, FRaceOptions options) {
        double runtimeCutoff = options.cutoffTime;
        int maximumRounds = options.maximumRacingRounds != -1 ? options.maximumRacingRounds : instances.size();
        int roundsBeforeFirstElimination = options.racingRoundsBeforeFirstElimination;
        final RunObjective runObjective = options.runObj;
        JscStatistics statistics = JscStatistics.getInstance();
        Random rand = new Random(options.seed);
        List reorderedInstances = instanceSeedGenerator.getProblemInstanceOrder(instances);
        ArrayList<ProblemInstanceSeedPair> instanceSeedPairs = new ArrayList<ProblemInstanceSeedPair>(maximumRounds);
        int i = 0;
        while (i < maximumRounds) {
            int instanceIndex = rand.nextInt(reorderedInstances.size());
            ProblemInstance instance = (ProblemInstance)reorderedInstances.get(instanceIndex);
            instanceSeedPairs.add(new ProblemInstanceSeedPair(instance, (long)instanceSeedGenerator.getNextSeed(instance)));
            ++i;
        }
        log.info("Performing F-Race over {} configurations", (Object)configurations.size());
        for (ParameterConfiguration config : configurations) {
            log.info("\t{} : {}", new Object[]{config.hashCode(), config.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX)});
        }
        ArrayList allRoundResults = new ArrayList();
        ArrayList<ParameterConfiguration> candidates = new ArrayList<ParameterConfiguration>(configurations);
        int currentRound = 1;
        while (candidates.size() > 1 && currentRound <= maximumRounds) {
            final ConcurrentHashMap currentRoundResults = new ConcurrentHashMap();
            allRoundResults.add(currentRound - 1, currentRoundResults);
            final int round = currentRound;
            final AtomicReference exception = new AtomicReference();
            WaitableTAECallback callback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

                public void onSuccess(List<AlgorithmRunResult> runs) {
                    for (AlgorithmRunResult run : runs) {
                        ParameterConfiguration config = run.getAlgorithmRunConfiguration().getParameterConfiguration();
                        double value = runObjective.getObjective(run);
                        currentRoundResults.put(config, value);
                        log.warn("Round {}: \tCandidate {} had performance {} and result string [{}].", new Object[]{round, run.toString(), value, run.getResultLine()});
                    }
                }

                public void onFailure(RuntimeException e) {
                    log.warn("Round {}: \t.onFailure() triggered in callback. Exception was: {}", new Object[]{round, e.getMessage()});
                    exception.set(e);
                }
            });
            ProblemInstanceSeedPair roundInstanceSeed = (ProblemInstanceSeedPair)instanceSeedPairs.get(currentRound - 1);
            ArrayList<AlgorithmRunConfiguration> runs = new ArrayList<AlgorithmRunConfiguration>();
            int i2 = 0;
            while (i2 < candidates.size()) {
                AlgorithmRunConfiguration run = new AlgorithmRunConfiguration(roundInstanceSeed, runtimeCutoff, (ParameterConfiguration)candidates.get(i2), executionConfiguration);
                runs.add(run);
                ++i2;
            }
            log.warn("Round {}: About to call evaluateRunsAsync() with {} runs", new Object[]{round, runs.size()});
            evaluator.evaluateRunsAsync(runs, (TargetAlgorithmEvaluatorCallback)callback);
            callback.waitForCompletion();
            log.warn("Round {}: Runs completed. CurrentRoundResults has {} results.", new Object[]{round, currentRoundResults.size()});
            if (currentRound >= roundsBeforeFirstElimination) {
                log.info("Round {}: Preparing blocks for the friedman test call.", (Object)round);
                NumberFormat format = NumberFormat.getNumberInstance();
                format.setMaximumFractionDigits(3);
                format.setMinimumFractionDigits(3);
                ArrayList<List<Double>> blocks = new ArrayList<List<Double>>(candidates.size());
                int j = 0;
                while (j < candidates.size()) {
                    StringBuffer buf = new StringBuffer();
                    ArrayList<Double> candidateResults = new ArrayList<Double>(allRoundResults.size());
                    int k = 0;
                    while (k < allRoundResults.size()) {
                        ConcurrentMap results = (ConcurrentMap)allRoundResults.get(k);
                        ParameterConfiguration cand = (ParameterConfiguration)candidates.get(j);
                        Double performance = (Double)results.get(cand);
                        candidateResults.add(k, performance);
                        buf.append(format.format(performance)).append(" ");
                        ++k;
                    }
                    log.info("Candidate {}: {}", new Object[]{j, buf.toString()});
                    blocks.add(j, candidateResults);
                    ++j;
                }
                log.info("Round {}: Performing F-test", (Object)round);
                Pair<TestResult, double[][]> friedmanResult = null;
                TestResult result = null;
                double p = 1.0;
                double statistic = Double.MAX_VALUE;
                try {
                    friedmanResult = statistics.friedmanTestWithRanks(blocks);
                    result = (TestResult)friedmanResult.getFirst();
                    p = result.getP();
                    statistic = result.getStatistic();
                }
                catch (Exception e) {
                    log.error("Round {}: Caught exception from the friedman test... {}", new Object[]{round, e.getMessage()});
                }
                log.info("Round {}: friedman p value = {}, test statistic = {}", new Object[]{round, p, round, statistic});
                if (p < 0.05) {
                    log.info("Round {}: p value was sufficient to reject the null. Proceeding to pairwise eliminations.", (Object)round);
                    double[][] ranks = (double[][])friedmanResult.getSecond();
                    double studentsTquantile = ((Statistics)statistics).studentTQuantile(0.975, candidates.size() - 1);
                    int bestCandidate = -1;
                    double bestRankSum = Double.MAX_VALUE;
                    double[] rankSums = new double[candidates.size()];
                    double squaredRanksSum = 0.0;
                    int j2 = 0;
                    while (j2 < candidates.size()) {
                        double sum = 0.0;
                        int k = 0;
                        while (k < allRoundResults.size()) {
                            sum += ranks[k][j2];
                            squaredRanksSum += ranks[k][j2] * ranks[k][j2];
                            ++k;
                        }
                        rankSums[j2] = sum;
                        if (sum < bestRankSum) {
                            bestCandidate = j2;
                            bestRankSum = sum;
                        }
                        ++j2;
                    }
                    ArrayList<ParameterConfiguration> toEliminate = new ArrayList<ParameterConfiguration>();
                    if (candidates.size() == 2) {
                        int candToEliminate = 1 - bestCandidate;
                        toEliminate.add((ParameterConfiguration)candidates.get(candToEliminate));
                        log.info("Round {}: Best candidate by rank sum is {} with sum {}. Eliminating the only other remaining candidate: {}.", new Object[]{round, bestCandidate, candToEliminate});
                    } else {
                        log.info("Round {}: Best candidate by rank sum is {} with sum {}. Comparing to all others.", new Object[]{round, bestCandidate, bestRankSum});
                        double m = candidates.size();
                        double k = allRoundResults.size();
                        double A = 1.0 - statistic / (k * (m - 1.0));
                        double B = k * m * (m + 1.0) * (m + 1.0) / 4.0;
                        double C = (k - 1.0) * (m - 1.0);
                        double denominator = Math.sqrt(2.0 * k * A * (squaredRanksSum - B) / C);
                        int j3 = 0;
                        while (j3 < candidates.size()) {
                            if (j3 != bestCandidate) {
                                double test = Math.abs(rankSums[j3] - bestRankSum) / denominator;
                                log.info("Round {}: Comparing to candidate {}: {} vs {}: {} vs {}", new Object[]{round, j3, bestRankSum, rankSums[j3], test, studentsTquantile});
                                if (test > studentsTquantile) {
                                    log.info("Round {}: Adding candidate {} to the elimination list.", new Object[]{round, j3});
                                    toEliminate.add((ParameterConfiguration)candidates.get(j3));
                                }
                            }
                            ++j3;
                        }
                    }
                    log.info("Round {}: Eliminating {} candidates in round {}", new Object[]{round, toEliminate.size(), currentRound});
                    for (ParameterConfiguration alg : toEliminate) {
                        candidates.remove(alg);
                    }
                    log.info("Round {}: {} remaining candidates...", new Object[]{round, candidates.size()});
                }
            }
            ++currentRound;
        }
        ParameterConfiguration winner = null;
        double quality = -1.0;
        if (candidates.size() > 1) {
            log.info("{} candidates remained after finishing the race. Choosing a winner based on mean performance.", (Object)candidates.size());
            double bestMean = Double.MAX_VALUE;
            ParameterConfiguration bestCandidate = null;
            for (ParameterConfiguration candidate : candidates) {
                quality = 0.0;
                int i3 = 0;
                while (i3 < allRoundResults.size()) {
                    ConcurrentMap roundResult = (ConcurrentMap)allRoundResults.get(i3);
                    quality += ((Double)roundResult.get(candidate)).doubleValue();
                    ++i3;
                }
                if (!((quality /= (double)allRoundResults.size()) < bestMean)) continue;
                bestMean = quality;
                bestCandidate = candidate;
            }
            quality = bestMean;
            winner = bestCandidate;
        } else {
            winner = (ParameterConfiguration)candidates.get(0);
            quality = 0.0;
            int i4 = 0;
            while (i4 < allRoundResults.size()) {
                ConcurrentMap roundResult = (ConcurrentMap)allRoundResults.get(i4);
                quality += ((Double)roundResult.get(winner)).doubleValue();
                ++i4;
            }
            quality /= (double)allRoundResults.size();
        }
        FRaceResult finalResult = new FRaceResult();
        finalResult.approximatePerformance = quality;
        finalResult.selectedConfiguration = winner;
        this.eventManager.flush();
        return finalResult;
    }

    public class FRaceResult {
        public ParameterConfiguration selectedConfiguration;
        public double approximatePerformance;
    }
}

