/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf.utils;

import ca.ubc.cs.beta.models.fastrf.utils.ArrayWithSensibleEquals;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class RfData {
    public double[][] Theta;
    public double[][] X;
    public double[] y;
    public int[][] theta_inst_idxs;
    public int[] catDomainSizes;

    public void makeUnique(boolean makeThetaUnique) {
        Object x;
        ArrayWithSensibleEquals array2;
        int i;
        HashSet<ArrayWithSensibleEquals> uniqueArrays = new HashSet<ArrayWithSensibleEquals>();
        HashMap<ArrayWithSensibleEquals, Integer> mapArrayToUniqueIndex = new HashMap<ArrayWithSensibleEquals, Integer>();
        Vector newIndices = new Vector();
        if (makeThetaUnique) {
            for (i = 0; i < this.Theta.length; ++i) {
                double[] theta = this.Theta[i];
                array2 = new ArrayWithSensibleEquals(theta);
                if (!uniqueArrays.contains(array2)) {
                    mapArrayToUniqueIndex.put(array2, uniqueArrays.size());
                    uniqueArrays.add(array2);
                }
                newIndices.add(i, mapArrayToUniqueIndex.get(array2));
            }
        } else {
            for (i = 0; i < this.X.length; ++i) {
                x = this.X[i];
                array2 = new ArrayWithSensibleEquals((double[])x);
                if (!uniqueArrays.contains(array2)) {
                    mapArrayToUniqueIndex.put(array2, uniqueArrays.size());
                    uniqueArrays.add(array2);
                }
                newIndices.add(i, mapArrayToUniqueIndex.get(array2));
            }
        }
        if (makeThetaUnique) {
            double[][] uniqueTheta = new double[uniqueArrays.size()][];
            x = uniqueArrays.iterator();
            while (x.hasNext()) {
                array2 = (ArrayWithSensibleEquals)x.next();
                uniqueTheta[((Integer)mapArrayToUniqueIndex.get((Object)array2)).intValue()] = array2.values;
            }
            this.Theta = uniqueTheta;
            for (int i2 = 0; i2 < newIndices.size(); ++i2) {
                this.theta_inst_idxs[i2][0] = (Integer)newIndices.get(i2);
            }
        } else {
            double[][] uniqueX = new double[uniqueArrays.size()][];
            for (ArrayWithSensibleEquals array2 : uniqueArrays) {
                uniqueX[((Integer)mapArrayToUniqueIndex.get((Object)array2)).intValue()] = array2.values;
            }
            this.X = uniqueX;
            for (int i3 = 0; i3 < newIndices.size(); ++i3) {
                this.theta_inst_idxs[i3][1] = (Integer)newIndices.get(i3);
            }
        }
    }

    public double[][] buildMatrixForApply() {
        assert (this.Theta.length > 0);
        assert (this.X.length > 0);
        int numPoints = this.theta_inst_idxs.length;
        int dimTheta = this.Theta[0].length;
        int dimX = this.X[0].length;
        double[][] combinedMatrix = new double[numPoints][dimTheta + dimX];
        for (int i = 0; i < numPoints; ++i) {
            int j;
            for (j = 0; j < dimTheta; ++j) {
                combinedMatrix[i][j] = this.Theta[this.theta_inst_idxs[i][0]][j];
            }
            for (j = dimTheta; j < dimTheta + dimX; ++j) {
                combinedMatrix[i][j] = this.X[this.theta_inst_idxs[i][1]][j - dimTheta];
            }
        }
        return combinedMatrix;
    }
}

