/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf.utils;

import ca.ubc.cs.beta.models.fastrf.utils.RfData;
import com.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CsvToDataConverter {
    private HashMap<Integer, Integer> csvColToModelDimMap;
    private HashMap<Integer, Map<String, Integer>> catDomainValueMaps;
    private int[] catDomainSizes;
    private String[] csvHeader;
    private int[] thetaColIdxs;
    private int[] xColIdxs;
    private int yColIdx;
    private int[] catColIdxs;
    private String[] parameterNames;
    private String[] featureNames;

    public CsvToDataConverter(String filename) throws IOException {
        this.getColIdxsFromCsvHeader(filename);
        this.prepareConverter(filename, this.thetaColIdxs, this.xColIdxs, this.yColIdx, this.catColIdxs);
    }

    public CsvToDataConverter(String filename, int[] thetaColIdxs, int[] xColIdxs, int yColIdx, int[] catColIdxs) throws IOException {
        this.prepareConverter(filename, thetaColIdxs, xColIdxs, yColIdx, catColIdxs);
    }

    public HashMap<Integer, Map<String, Integer>> getCatDomainValueMaps() {
        return this.catDomainValueMaps;
    }

    public int[] getCatDomainSizes() {
        return this.catDomainSizes;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public String[] getFeatureNames() {
        return this.featureNames;
    }

    private void getColIdxsFromCsvHeader(String csvFilename) throws IOException {
        int i;
        CSVReader csvReader = new CSVReader((Reader)new FileReader(csvFilename));
        this.csvHeader = csvReader.readNext();
        csvReader.close();
        Vector<Integer> paramIndices = new Vector<Integer>();
        Vector<Integer> featureIndices = new Vector<Integer>();
        Vector<Integer> categoricalIndices = new Vector<Integer>();
        int responseIndex = -1;
        for (i = 0; i < this.csvHeader.length; ++i) {
            if (this.csvHeader[i].trim().toLowerCase().startsWith("parameter")) {
                paramIndices.add(i);
            }
            if (this.csvHeader[i].trim().toLowerCase().startsWith("feature")) {
                featureIndices.add(i);
            }
            if (this.csvHeader[i].toLowerCase().contains("categorical")) {
                categoricalIndices.add(i);
            }
            if (!this.csvHeader[i].trim().toLowerCase().startsWith("performance")) continue;
            if (responseIndex != -1) {
                System.out.println("ERROR. Only one column in the input CSV is allowed to start with the string performance, but there are multiple ones. Please fix this; I'm exiting.");
                System.exit(-1);
            }
            responseIndex = i;
        }
        if (responseIndex == -1) {
            System.out.println("ERROR. In the input CSV, the header for the column with the response to be optimized must start with the string performance (that's how it is detected). Please fix this; I'm exiting.");
            System.exit(-1);
        }
        if (paramIndices.isEmpty()) {
            System.out.println("ERROR. At least one column in the input CSV has to hold a parameter (the header for parameter columns starts with the string Parameter). Please fix this; I'm exiting.");
            System.exit(-1);
        }
        if (featureIndices.isEmpty()) {
            System.out.println("ERROR. At least one column in the input CSV has to hold a feature (the header for feature columns starts with the string Feature). Please fix this; I'm exiting.");
            System.exit(-1);
        }
        this.thetaColIdxs = new int[paramIndices.size()];
        for (i = 0; i < this.thetaColIdxs.length; ++i) {
            this.thetaColIdxs[i] = (Integer)paramIndices.get(i);
        }
        this.xColIdxs = new int[featureIndices.size()];
        for (i = 0; i < this.xColIdxs.length; ++i) {
            this.xColIdxs[i] = (Integer)featureIndices.get(i);
        }
        this.catColIdxs = new int[categoricalIndices.size()];
        for (i = 0; i < this.catColIdxs.length; ++i) {
            this.catColIdxs[i] = (Integer)categoricalIndices.get(i);
        }
        this.yColIdx = responseIndex;
    }

    private List<String[]> readEntriesFromCsv(String filename, boolean overWriteHeader) throws IOException {
        CSVReader csvReader = new CSVReader((Reader)new FileReader(filename));
        List entries = csvReader.readAll();
        csvReader.close();
        if (overWriteHeader) {
            this.csvHeader = (String[])entries.get(0);
        } else {
            for (int i = 0; i < this.csvHeader.length; ++i) {
                assert (this.csvHeader[i].equals(((String[])entries.get(0))[i]));
            }
        }
        entries.remove(0);
        return entries;
    }

    private void computeCsvToModelIdxMap(int[] thetaColIdxs, int[] xColIdxs) {
        this.csvColToModelDimMap = CsvToDataConverter.readOutCsvToModelIdxMap(thetaColIdxs, xColIdxs);
    }

    public static HashMap<Integer, Integer> readOutCsvToModelIdxMap(int[] thetaColIdxs, int[] xColIdxs) {
        int i;
        HashMap<Integer, Integer> localCsvColToModelDimMap = new HashMap<Integer, Integer>();
        for (i = 0; i < thetaColIdxs.length; ++i) {
            localCsvColToModelDimMap.put(thetaColIdxs[i], i);
        }
        for (i = 0; i < xColIdxs.length; ++i) {
            localCsvColToModelDimMap.put(xColIdxs[i], thetaColIdxs.length + i);
        }
        return localCsvColToModelDimMap;
    }

    private void computeCatDomainValueMap(List<String[]> lines, int[] catColIdxs, Map<Integer, Integer> csvColToModelDimMap) {
        this.catDomainValueMaps = CsvToDataConverter.readOutCatDomainValueMap(lines, catColIdxs, csvColToModelDimMap);
    }

    public static HashMap<Integer, Map<String, Integer>> readOutCatDomainValueMap(List<String[]> lines, int[] catColIdxs, Map<Integer, Integer> csvColToModelDimMap) {
        HashMap<Integer, Map<String, Integer>> localCatDomainValueMaps = new HashMap<Integer, Map<String, Integer>>();
        for (int i = 0; i < catColIdxs.length; ++i) {
            int csvColIdx = catColIdxs[i];
            int modelColIdx = csvColToModelDimMap.get(csvColIdx);
            HashMap<String, Integer> domainValueMap = new HashMap<String, Integer>();
            for (int j = 0; j < lines.size(); ++j) {
                String valueString = lines.get(j)[csvColIdx].trim();
                if (domainValueMap.get(valueString) != null) continue;
                domainValueMap.put(valueString, domainValueMap.size() + 1);
            }
            localCatDomainValueMaps.put(modelColIdx, domainValueMap);
        }
        return localCatDomainValueMaps;
    }

    private void computeCatDomainSizes(HashMap<Integer, Map<String, Integer>> catDomainValueMaps, int numDim) {
        this.catDomainSizes = CsvToDataConverter.readOutCatDomainSizes(catDomainValueMaps, numDim);
    }

    public static int[] readOutCatDomainSizes(HashMap<Integer, Map<String, Integer>> catDomainValueMaps, int numDim) {
        int[] localCatDomainSizes = new int[numDim];
        for (int i = 0; i < numDim; ++i) {
            localCatDomainSizes[i] = 0;
            if (catDomainValueMaps.get(i) == null) continue;
            localCatDomainSizes[i] = catDomainValueMaps.get(i).size();
        }
        return localCatDomainSizes;
    }

    private void prepareConverter(String filename, int[] thetaColIdxs, int[] xColIdxs, int yColIdx, int[] catColIdxs) throws IOException {
        int i;
        this.thetaColIdxs = thetaColIdxs;
        this.xColIdxs = xColIdxs;
        this.yColIdx = yColIdx;
        this.catColIdxs = catColIdxs;
        this.computeCsvToModelIdxMap(thetaColIdxs, xColIdxs);
        List<String[]> lines = this.readEntriesFromCsv(filename, true);
        this.computeCatDomainValueMap(lines, catColIdxs, this.csvColToModelDimMap);
        this.computeCatDomainSizes(this.catDomainValueMaps, thetaColIdxs.length + xColIdxs.length);
        this.parameterNames = new String[thetaColIdxs.length];
        for (i = 0; i < thetaColIdxs.length; ++i) {
            this.parameterNames[i] = this.csvHeader[thetaColIdxs[i]].trim();
        }
        this.featureNames = new String[xColIdxs.length];
        for (i = 0; i < xColIdxs.length; ++i) {
            this.featureNames[i] = this.csvHeader[xColIdxs[i]].trim();
        }
    }

    public RfData readDataFromCsvFile(String filename) throws IOException {
        List<String[]> lines = this.readEntriesFromCsv(filename, false);
        RfData data = new RfData();
        data.y = new double[lines.size()];
        data.Theta = new double[lines.size()][this.thetaColIdxs.length];
        data.X = new double[lines.size()][this.xColIdxs.length];
        data.theta_inst_idxs = new int[lines.size()][2];
        for (int i = 0; i < data.y.length; ++i) {
            String valueString;
            int modelColIdx;
            int csvColIdx;
            int j;
            String[] line = lines.get(i);
            for (j = 0; j < this.thetaColIdxs.length; ++j) {
                csvColIdx = this.thetaColIdxs[j];
                modelColIdx = this.csvColToModelDimMap.get(csvColIdx);
                valueString = line[csvColIdx].trim();
                if (this.catDomainSizes[modelColIdx] == 0) {
                    data.Theta[i][modelColIdx] = Double.parseDouble(valueString);
                    continue;
                }
                int thetaValue = this.catDomainValueMaps.get(modelColIdx).get(valueString);
                data.Theta[i][modelColIdx] = thetaValue;
            }
            for (j = 0; j < this.xColIdxs.length; ++j) {
                csvColIdx = this.xColIdxs[j];
                modelColIdx = this.csvColToModelDimMap.get(csvColIdx);
                valueString = line[csvColIdx].trim();
                if (this.catDomainSizes[modelColIdx] == 0) {
                    data.X[i][modelColIdx - this.thetaColIdxs.length] = Double.parseDouble(valueString);
                    continue;
                }
                if (this.catDomainValueMaps.get(modelColIdx).containsKey(valueString)) {
                    int xValue = this.catDomainValueMaps.get(modelColIdx).get(valueString);
                    data.X[i][modelColIdx - this.thetaColIdxs.length] = xValue;
                    continue;
                }
                throw new IllegalArgumentException("Error in reading csv file: value for column " + csvColIdx + " (" + this.csvHeader[csvColIdx] + ") is " + valueString + "; the domain only has the values " + this.catDomainValueMaps.get(modelColIdx).keySet());
            }
            data.y[i] = Double.parseDouble(line[this.yColIdx]);
            data.theta_inst_idxs[i][0] = i;
            data.theta_inst_idxs[i][1] = i;
        }
        data.catDomainSizes = this.catDomainSizes;
        return data;
    }

    public String getPcsString(String filename) throws IOException {
        List<String[]> lines = this.readEntriesFromCsv(filename, false);
        String pcsString = "";
        for (int i = 0; i < this.thetaColIdxs.length; ++i) {
            if (this.catDomainSizes[i] == 0) {
                double minValue = Double.POSITIVE_INFINITY;
                double maxValue = Double.NEGATIVE_INFINITY;
                for (int j = 1; j < lines.size(); ++j) {
                    double value = Double.parseDouble(lines.get(j - 1)[this.thetaColIdxs[i]].trim());
                    minValue = Math.min(minValue, value);
                    maxValue = Math.max(maxValue, value);
                }
                pcsString = pcsString + this.csvHeader[this.thetaColIdxs[i]] + "[" + minValue + "," + maxValue + "] [" + (minValue + maxValue) / 2.0 + "]\n";
                continue;
            }
            Set<String> valueSet = this.catDomainValueMaps.get(i).keySet();
            Vector<String> valuesSorted = new Vector<String>(valueSet.size());
            for (String valueString : valueSet) {
                valuesSorted.add(this.catDomainValueMaps.get(i).get(valueString), valueString);
            }
            pcsString = pcsString + this.csvHeader[this.thetaColIdxs[i]] + "{";
            for (int j = 0; j < valuesSorted.size() - 1; ++j) {
                pcsString = pcsString + (String)valuesSorted.get(j) + ",";
            }
            pcsString = pcsString + (String)valuesSorted.get(valuesSorted.size() - 1) + "} [" + (String)valuesSorted.get(0) + "]\n";
        }
        return pcsString;
    }

    public double[][] readXFromOtherCsvFile(String testFileCsvName) throws IOException {
        CSVReader csvReader = new CSVReader((Reader)new FileReader(testFileCsvName));
        String[] testHeader = csvReader.readNext();
        csvReader.close();
        int[] testXColIdxs = new int[this.xColIdxs.length];
        for (int i = 0; i < this.xColIdxs.length; ++i) {
            testXColIdxs[i] = -1;
            for (int j = 0; j < testHeader.length; ++j) {
                if (!testHeader[j].equals(this.csvHeader[this.xColIdxs[i]])) continue;
                testXColIdxs[i] = j;
            }
            if (testXColIdxs[i] != -1) continue;
            System.out.println("Error: test CSV does not contain one of the features of the training file: " + this.csvHeader[this.xColIdxs[i]] + ". Please fix this; I'm exiting.");
            System.exit(-1);
        }
        csvReader = new CSVReader((Reader)new FileReader(testFileCsvName));
        List testLines = csvReader.readAll();
        csvReader.close();
        double[][] X = new double[testLines.size() - 1][testXColIdxs.length];
        for (int i = 0; i < X.length; ++i) {
            for (int j = 0; j < testXColIdxs.length; ++j) {
                double value;
                X[i][j] = value = Double.parseDouble(((String[])testLines.get(i + 1))[testXColIdxs[j]].trim());
            }
        }
        return X;
    }
}

