/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class IntegerFormat {
    protected DecimalFormat decimalFormat;

    public IntegerFormat() {
        this(Locale.getDefault());
    }

    public IntegerFormat(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (!(numberFormat instanceof DecimalFormat)) {
            throw new IllegalArgumentException("DecimalFormat not available for locale.");
        }
        this.decimalFormat = (DecimalFormat)numberFormat;
        this.decimalFormat.setParseIntegerOnly(true);
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.setGroupingUsed(false);
    }

    public String format(int n) {
        return this.decimalFormat.format(n);
    }

    public Number parse(String string) throws ParseException {
        return this.decimalFormat.parse(string);
    }

    public void setGroupingSeparator(char c) {
        DecimalFormatSymbols decimalFormatSymbols = this.decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(c);
        this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    public void setGroupingUsed(boolean bl) {
        this.decimalFormat.setGroupingUsed(bl);
    }
}

