/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.mdi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jsc.swt.mdi.MDIWindow;

public class MDIEditorWindow
extends MDIWindow {
    protected JTextArea ta;

    public MDIEditorWindow(File file, String string) {
        super(file);
        this.ta = new JTextArea(string);
        this.ta.setEditable(true);
        this.ta.setLineWrap(true);
        this.ta.getDocument().addDocumentListener(new TextListener());
        this.ta.addCaretListener(new SelectionListener());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(1, 1));
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        container.add((Component)jScrollPane, "Center");
    }

    public void clear() {
        this.ta.replaceRange("", this.ta.getSelectionStart(), this.ta.getSelectionEnd());
    }

    public void copy() {
        this.ta.copy();
    }

    public void cut() {
        this.ta.cut();
    }

    public void paste() {
        this.ta.paste();
    }

    public void selectAll() {
        this.setSelection(true);
        this.ta.selectAll();
    }

    public void selectNone() {
        this.setSelection(false);
        this.ta.select(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean write(File file) {
        FileWriter fileWriter = null;
        fileWriter = new FileWriter(file);
        String string = this.ta.getText();
        fileWriter.write(string, 0, string.length());
        boolean bl = true;
        Object var6_6 = null;
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            try {
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException3) {}
        }
        return false;
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            MDIEditorWindow.this.setChanged(true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            MDIEditorWindow.this.setChanged(true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            MDIEditorWindow.this.setChanged(true);
        }
    }

    class SelectionListener
    implements CaretListener {
        SelectionListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            MDIEditorWindow.this.getParentApp().setEditEnabled(caretEvent.getDot() != caretEvent.getMark());
        }
    }
}

