/*
 * Decompiled with CFR 0.152.
 */
package jsc.numerical;

public class Spline {
    private int n;
    private double[] x;
    private double[] y;
    private double[] y2;

    public Spline(int n, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[n + 1];
        this.x = new double[n + 1];
        this.y = new double[n + 1];
        this.y2 = new double[n + 1];
        this.n = n;
        this.x[0] = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        while (n2 < this.n) {
            this.x[n2 + 1] = dArray[n2];
            if (this.x[n2 + 1] <= this.x[n2]) {
                throw new IllegalArgumentException("x values not in ascending order or distinct.");
            }
            this.y[n2 + 1] = dArray2[n2];
            ++n2;
        }
        this.y2[1] = 0.0;
        dArray3[1] = 0.0;
        n2 = 2;
        while (n2 <= this.n - 1) {
            double d = (this.x[n2] - this.x[n2 - 1]) / (this.x[n2 + 1] - this.x[n2 - 1]);
            double d2 = d * this.y2[n2 - 1] + 2.0;
            this.y2[n2] = (d - 1.0) / d2;
            dArray3[n2] = (this.y[n2 + 1] - this.y[n2]) / (this.x[n2 + 1] - this.x[n2]) - (this.y[n2] - this.y[n2 - 1]) / (this.x[n2] - this.x[n2 - 1]);
            dArray3[n2] = (6.0 * dArray3[n2] / (this.x[n2 + 1] - this.x[n2 - 1]) - d * dArray3[n2 - 1]) / d2;
            ++n2;
        }
        double d = 0.0;
        double d3 = 0.0;
        this.y2[this.n] = (d - d3 * dArray3[this.n - 1]) / (d3 * this.y2[this.n - 1] + 1.0);
        int n3 = this.n - 1;
        while (n3 >= 1) {
            this.y2[n3] = this.y2[n3] * this.y2[n3 + 1] + dArray3[n3];
            --n3;
        }
    }

    public double getMaxX() {
        return this.x[this.n];
    }

    public double getMinX() {
        return this.x[1];
    }

    public int getN() {
        return this.n;
    }

    public double getX(int n) {
        return this.x[n + 1];
    }

    public double getY(int n) {
        return this.y[n + 1];
    }

    public double[] evalDerivative(double d) {
        double[] dArray = new double[2];
        int n = 1;
        int n2 = this.n;
        while (n2 - n > 1) {
            int n3 = n2 + n >> 1;
            if (this.x[n3] > d) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        double d2 = this.x[n2] - this.x[n];
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Cannot evaluate spline at " + d);
        }
        double d3 = (this.x[n2] - d) / d2;
        double d4 = (d - this.x[n]) / d2;
        double d5 = d3 * d3;
        double d6 = d4 * d4;
        dArray[0] = d3 * this.y[n] + d4 * this.y[n2] + ((d5 * d3 - d3) * this.y2[n] + (d6 * d4 - d4) * this.y2[n2]) * (d2 * d2) / 6.0;
        dArray[1] = (this.y[n2] - this.y[n]) / d2 + ((3.0 * d6 - 1.0) * this.y2[n2] - (3.0 * d5 - 1.0) * this.y2[n]) * d2 / 6.0;
        return dArray;
    }

    public double splint(double d) {
        int n = 1;
        int n2 = this.n;
        while (n2 - n > 1) {
            int n3 = n2 + n >> 1;
            if (this.x[n3] > d) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        double d2 = this.x[n2] - this.x[n];
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Cannot evaluate spline at " + d);
        }
        double d3 = (this.x[n2] - d) / d2;
        double d4 = (d - this.x[n]) / d2;
        return d3 * this.y[n] + d4 * this.y[n2] + ((d3 * d3 * d3 - d3) * this.y2[n] + (d4 * d4 * d4 - d4) * this.y2[n2]) * (d2 * d2) / 6.0;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 1000;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = n2;
                dArray2[n2] = Math.sin(n2);
                ++n2;
            }
            Spline spline = new Spline(n, dArray, dArray2);
            double d = 3.5;
            System.out.println("f(" + d + ") = " + spline.splint(d));
        }
    }
}

