/*
 * Decompiled with CFR 0.152.
 */
package jsc.mathfunction;

import jsc.mathfunction.MathFunctionVariables;

public final class SubscriptedVariable
implements MathFunctionVariables {
    private final int n;
    private final int firstSubscript;
    private final int lastSubscript;
    private final String name;
    private double[] x;

    public SubscriptedVariable(String string, int n, int n2) {
        this.n = 1 + n2 - n;
        if (this.n < 1) {
            throw new IllegalArgumentException("Invalid subscripts.");
        }
        this.x = new double[this.n];
        this.name = string;
        this.firstSubscript = n;
        this.lastSubscript = n2;
    }

    public SubscriptedVariable(String string, int n) {
        this(string, 1, n);
    }

    public int getNumberOfVariables() {
        return this.n;
    }

    public String getVariableName(int n) {
        return this.name + (n + this.firstSubscript);
    }

    public int getVariableSubscript(int n) {
        return n + this.firstSubscript;
    }

    public double getVariableValue(int n) {
        return this.x[n];
    }

    public void setVariableValue(int n, double d) {
        if (n < 0 || n >= this.n) {
            throw new IllegalArgumentException("Invalid variable index.");
        }
        this.x[n] = d;
    }
}

