/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import java.util.Arrays;
import jsc.ci.DistributionFreeCI;
import jsc.distributions.MannWhitneyU;
import jsc.distributions.Normal;

public class MannWhitneyMedianDifferenceCI
extends DistributionFreeCI {
    public static final int AUTO = 0;
    public static final int EXACT = 1;
    public static final int APPROX = 2;
    public static final int FAST_APPROX = 3;
    int method;
    static final int SMALL_SAMPLE_SIZE_PRODUCT = 400;
    static final int MEDIUM_SAMPLE_SIZE_PRODUCT = 10000;
    double[] xA;
    double[] xB;
    static final double TOL1 = 1.0E-16;
    static final double TOL2 = 1.0E-16;
    static final double TOL3 = 1.0E-15;
    double dpoint;
    double x1;
    double fx1;
    double x2;
    double fx2;

    public MannWhitneyMedianDifferenceCI(double[] dArray, double[] dArray2, double d, int n) {
        super(d);
        int n2 = dArray.length;
        int n3 = dArray2.length;
        if (n == 0) {
            long l = n2 * n3;
            n = l <= 400L ? 1 : (l <= 10000L ? 2 : 3);
        }
        this.method = n;
        if (n == 3) {
            this.rankCI(dArray2, dArray, d);
        } else {
            double d2;
            if (n == 2) {
                double d3 = Normal.inverseStandardCdf(0.5 + 0.5 * d);
                this.d = (int)Math.round(0.5 * ((double)(n2 * n3) + 1.0 - d3 * Math.sqrt((double)(n2 * n3) * ((double)(n2 + n3) + 1.0) / 3.0)));
                Normal normal = MannWhitneyU.normalApproximation(n2, n3, 0);
                d2 = normal.cdf((double)this.d - 1.0);
            } else if (n == 1) {
                MannWhitneyU mannWhitneyU = new MannWhitneyU(n2, n3);
                d2 = 0.5 * (1.0 - d);
                long l = mannWhitneyU.getMinValue();
                double d4 = mannWhitneyU.pdf(l);
                while (l < mannWhitneyU.getMaxValue() && d4 < d2) {
                    d4 += mannWhitneyU.pdf(++l);
                }
                this.d = (int)(--l + 1L);
                d2 = d4 - mannWhitneyU.pdf(l + 1L);
            } else {
                throw new IllegalArgumentException("Invalid method parameter.");
            }
            this.achievedConfidence = 1.0 - 2.0 * d2;
            this.computeInterval(2, this.d, dArray, dArray2);
            this.xA = dArray;
            this.xB = dArray2;
        }
    }

    public MannWhitneyMedianDifferenceCI(double[] dArray, double[] dArray2, double d) {
        this(dArray, dArray2, d, 0);
    }

    private void rankCI(double[] dArray, double[] dArray2, double d) {
        double d2;
        int n = dArray.length;
        int n2 = dArray2.length;
        double[] dArray3 = new double[1 + n];
        double[] dArray4 = new double[1 + n2];
        System.arraycopy(dArray, 0, dArray3, 1, n);
        System.arraycopy(dArray2, 0, dArray4, 1, n2);
        dArray3[0] = Double.NEGATIVE_INFINITY;
        dArray4[0] = Double.NEGATIVE_INFINITY;
        Arrays.sort(dArray3);
        Arrays.sort(dArray4);
        this.dpoint = 0.0;
        this.lowerLimit = 0.0;
        this.upperLimit = 0.0;
        boolean bl = false;
        double d3 = n;
        double d4 = n2;
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException("Too few data values.");
        }
        TrimmedMean trimmedMean = new TrimmedMean(dArray3, n);
        double d5 = trimmedMean.getMean();
        double d6 = trimmedMean.getVariance();
        TrimmedMean trimmedMean2 = new TrimmedMean(dArray4, n2);
        double d7 = trimmedMean2.getMean();
        double d8 = trimmedMean2.getVariance();
        double d9 = d7 - d5;
        double d10 = d6 + d8;
        double d11 = Math.sqrt(d10);
        d11 = Math.max(d11, 1.0E-20);
        double d12 = 2.0;
        if (n < 10 || n2 < 10 || d > 0.96) {
            d12 = 3.0;
        }
        double d13 = d9 - d12 * d11;
        double d14 = d9 + d12 * d11;
        double d15 = dArray3[n] - dArray3[1];
        double d16 = dArray4[n2] - dArray4[1];
        double d17 = 1.0E-16 * Math.max(d15, d16);
        int n3 = n / 2;
        d15 = dArray3[n3];
        n3 = n2 / 2;
        d16 = dArray4[n3];
        double d18 = 1.0E-16 * Math.max(Math.max(d15, -d15), Math.max(d16, -d16));
        d17 = Math.max(d17, d18);
        d18 = d11 * 1.0E-15;
        d17 = Math.max(d17, d18);
        d17 = Math.max(d17, 1.0E-20);
        d18 = 10.0 * d17;
        boolean bl2 = true;
        double d19 = 0.0;
        if (n * n2 % 2 == 0) {
            d2 = d3 * d4 / 2.0 - 0.5;
            d19 = d2 + 1.0;
            bl2 = false;
        } else {
            d2 = d3 * d4 / 2.0;
        }
        double d20 = (1.0 - d) / 2.0;
        double d21 = d3 * d4 / 2.0;
        double d22 = d3 * d4 * (d3 + d4 + 1.0) / 12.0;
        double d23 = Math.sqrt(d22);
        double d24 = d23 * Normal.inverseStandardCdf(d20) + d21 - 0.5;
        int n4 = (int)d24;
        if (n4 < 0) {
            n4 = 0;
        }
        d24 = n4;
        d15 = (d24 + 0.5 - d21) / d23;
        d20 = Normal.standardTailProb(d15, false);
        this.achievedConfidence = 1.0 - 2.0 * d20;
        double d25 = d3 * d4 - (d24 += 0.5);
        int n5 = (int)(d24 + 0.5);
        int n6 = (int)(d25 + 0.5);
        this.d = n5;
        double d26 = Math.abs(d15) * Math.sqrt(d3 * d4 * (d3 + d4)) / ((d14 - d13) * Math.sqrt(3.0));
        this.brack(d13, d24, d26, dArray3, n, dArray4, n2);
        this.lowerLimit = this.ill(d24, dArray3, n, dArray4, n2, d18);
        this.brack(d14, d25, d26, dArray3, n, dArray4, n2);
        this.upperLimit = this.ill(d25, dArray3, n, dArray4, n2, d18);
        if (this.upperLimit > this.lowerLimit + d18) {
            d26 = (d14 - d13) / (this.upperLimit - this.lowerLimit) * d26;
        }
        d9 = (this.lowerLimit + this.upperLimit) / 2.0;
        this.brack(d9, d2, d26, dArray3, n, dArray4, n2);
        this.dpoint = this.ill(d2, dArray3, n, dArray4, n2, d17);
        if (bl2) {
            return;
        }
        this.brack(this.dpoint, d19, d26, dArray3, n, dArray4, n2);
        double d27 = this.ill(d19, dArray3, n, dArray4, n2, d17);
        this.dpoint = (this.dpoint + d27) / 2.0;
    }

    private double ill(double d, double[] dArray, int n, double[] dArray2, int n2, double d2) {
        this.fx1 -= d;
        this.fx2 -= d;
        boolean bl = false;
        while (Math.abs(this.x2 - this.x1) >= d2) {
            double d3 = this.x2 - this.fx2 * (this.x2 - this.x1) / (this.fx2 - this.fx1);
            if (bl) {
                d3 = (this.x1 + this.x2) / 2.0;
            }
            bl = false;
            double d4 = this.fmann(d3, dArray, n, dArray2, n2);
            if ((d4 -= d) * this.fx2 <= 0.0) {
                this.x1 = this.x2;
                this.fx1 = this.fx2;
                this.x2 = d3;
                this.fx2 = d4;
                continue;
            }
            this.x2 = d3;
            this.fx2 = d4;
            this.fx1 /= 2.0;
            if (!(Math.abs(this.fx2) > Math.abs(this.fx1))) continue;
            this.fx1 = 2.0 * this.fx1;
            bl = true;
        }
        double d5 = (this.x1 + this.x2) / 2.0;
        return d5;
    }

    private void brack(double d, double d2, double d3, double[] dArray, int n, double[] dArray2, int n2) {
        this.x1 = d;
        this.fx1 = this.fmann(this.x1, dArray, n, dArray2, n2);
        double d4 = 1.5 * ((d2 - this.fx1) / d3);
        while (true) {
            this.x2 = this.x1 + d4;
            this.fx2 = this.fmann(this.x2, dArray, n, dArray2, n2);
            if ((this.fx1 - d2) * (this.fx2 - d2) < 0.0) {
                return;
            }
            this.x1 = this.x2;
        }
    }

    private double fmann(double d, double[] dArray, int n, double[] dArray2, int n2) {
        double d2 = d;
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        while (n7 <= n3) {
            double d3 = dArray[n7] + d2;
            while (d3 >= dArray2[n5 + 1]) {
                if (++n5 < n4) continue;
                double d4 = n6 += (n3 - n7 + 1) * n4;
                return d4;
            }
            n6 += n5;
            ++n7;
        }
        double d5 = n6;
        return d5;
    }

    public double getPointEstimate() {
        if (this.method == 3) {
            return this.dpoint;
        }
        return MannWhitneyMedianDifferenceCI.getPointEstimate(this.xA, this.xB);
    }

    public static double getPointEstimate(double[] dArray, double[] dArray2) {
        double[] dArray3 = DistributionFreeCI.differences(dArray, dArray2);
        int n = dArray3.length;
        int n2 = n / 2;
        if (n % 2 == 0) {
            return (dArray3[n2 - 1] + dArray3[n2]) / 2.0;
        }
        return dArray3[n2];
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 200;
            int n2 = n + 1;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n2];
            Normal normal = new Normal(2.0, 1.0);
            Normal normal2 = new Normal(1.0, 1.0);
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = normal.random();
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                dArray2[n3] = normal2.random();
                ++n3;
            }
            long l = System.currentTimeMillis();
            MannWhitneyMedianDifferenceCI mannWhitneyMedianDifferenceCI = new MannWhitneyMedianDifferenceCI(dArray, dArray2, 0.9, 3);
            long l2 = System.currentTimeMillis();
            System.out.println("n = " + n + " Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("CI=[" + mannWhitneyMedianDifferenceCI.getLowerLimit() + "," + mannWhitneyMedianDifferenceCI.getUpperLimit() + "]" + " d = " + mannWhitneyMedianDifferenceCI.getD() + " Point estimate = " + mannWhitneyMedianDifferenceCI.getPointEstimate() + " Achieved conf = " + mannWhitneyMedianDifferenceCI.getAchievedConfidence());
        }
    }

    class TrimmedMean {
        double zbar;
        double varzb;

        TrimmedMean(double[] dArray, int n) {
            double d = 0.1;
            double d2 = n;
            int n2 = (int)(d * d2);
            int n3 = n2 + 1;
            int n4 = n - n2;
            double d3 = 0.0;
            int n5 = n3;
            while (n5 <= n4) {
                d3 += dArray[n5];
                ++n5;
            }
            double d4 = n - 2 * n2;
            this.zbar = d3 / d4;
            d3 = 0.0;
            n5 = n3;
            while (n5 <= n4) {
                d3 += (dArray[n5] - this.zbar) * (dArray[n5] - this.zbar);
                ++n5;
            }
            if (n2 != 0) {
                double d5 = n2;
                d3 += d5 * (dArray[n3 - 1] - this.zbar) * (dArray[n3 - 1] - this.zbar) + d5 * (dArray[n4 + 1] - this.zbar) * (dArray[n4 + 1] - this.zbar);
            }
            this.varzb = d3 / (d2 * d2);
        }

        double getMean() {
            return this.zbar;
        }

        double getVariance() {
            return this.varzb;
        }
    }
}

