/*
 * Decompiled with CFR 0.152.
 */
package jsc.goodnessfit;

import jsc.distributions.Distribution;
import jsc.goodnessfit.SampleDistributionFunction;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public abstract class KolmogorovTypeTest
implements SignificanceTest {
    protected int n;
    protected Distribution F;
    protected double D;
    protected double positiveD;
    protected double negativeD;
    protected int indexOfD;
    protected int indexOfPositiveD;
    protected int indexOfNegativeD;
    protected double testStatistic;
    protected SampleDistributionFunction sdf;

    public KolmogorovTypeTest(double[] dArray, Distribution distribution, H1 h1) {
        double d = 0.0;
        this.sdf = new SampleDistributionFunction(dArray);
        this.n = this.sdf.getN();
        this.F = distribution;
        this.indexOfD = 0;
        this.indexOfPositiveD = 0;
        this.indexOfNegativeD = 0;
        double[] dArray2 = new double[this.n];
        int n = 0;
        while (n < this.n) {
            dArray2[n] = distribution.cdf(this.sdf.getOrderedX(n));
            if (dArray2[n] < 0.0 || dArray2[n] > 1.0) {
                throw new IllegalArgumentException("Invalid distribution cdf.");
            }
            double d2 = this.sdf.getOrderedS(n);
            double d3 = distribution.isDiscrete() ? 0.0 : d - dArray2[n];
            double d4 = Math.max(Math.abs(d3), Math.abs(d2 - dArray2[n]));
            if (d4 > this.D) {
                this.D = d4;
                this.indexOfD = n;
            }
            if ((d4 = Math.max(d3, d2 - dArray2[n])) > this.positiveD) {
                this.positiveD = d4;
                this.indexOfPositiveD = n;
            }
            if ((d4 = Math.max(-d3, dArray2[n] - d2)) > this.negativeD) {
                this.negativeD = d4;
                this.indexOfNegativeD = n;
            }
            d = d2;
            ++n;
        }
        this.testStatistic = h1 == H1.NOT_EQUAL ? this.D : (h1 == H1.LESS_THAN ? this.positiveD : this.negativeD);
    }

    public KolmogorovTypeTest(double[] dArray, Distribution distribution) {
        this(dArray, distribution, H1.NOT_EQUAL);
    }

    public double getD() {
        return this.D;
    }

    public double getPositiveD() {
        return this.positiveD;
    }

    public double getNegativeD() {
        return this.negativeD;
    }

    public double getTestStatistic() {
        return this.testStatistic;
    }

    public int getN() {
        return this.n;
    }

    public Distribution getF() {
        return this.F;
    }

    public SampleDistributionFunction getSdf() {
        return this.sdf;
    }

    public int indexOfD() {
        return this.indexOfD;
    }

    public int indexOfPositiveD() {
        return this.indexOfPositiveD;
    }

    public int indexOfNegativeD() {
        return this.indexOfNegativeD;
    }

    public double xOfD() {
        return this.sdf.getOrderedX(this.indexOfD);
    }

    public double xOfPositiveD() {
        return this.sdf.getOrderedX(this.indexOfPositiveD);
    }

    public double xOfNegativeD() {
        return this.sdf.getOrderedX(this.indexOfNegativeD);
    }
}

