/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractContinuousDistribution;
import jsc.distributions.Beta;
import jsc.distributions.ChiSquared;
import jsc.distributions.Gamma;
import jsc.distributions.NoncentralChiSquared;
import jsc.distributions.Normal;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class NoncentralBeta
extends AbstractContinuousDistribution {
    static final int ITRMAX = 200;
    private double p;
    private double q;
    private double lambda;
    private double emhl;
    private double halfLambda;
    private double logHalfLambda;
    private double logP;
    private ChiSquared Cq;
    private NoncentralChiSquared Cp;
    private double beta;
    private double logGammaQ;
    private Beta centralBeta;

    public NoncentralBeta(double d, double d2, double d3) {
        super(0.0, 1.0, false);
        this.setParameters(d, d2, d3);
    }

    private double betanc(double d) {
        double d2;
        double d3 = this.p;
        double d4 = this.q;
        double d5 = Beta.incompleteBeta(d, d3, d4, this.beta);
        double d6 = Math.exp(d3 * Math.log(d) + d4 * Math.log(1.0 - d) - this.beta - this.logP);
        double d7 = this.emhl;
        double d8 = 0.0;
        double d9 = d7 * d5;
        double d10 = 1.0 - d7;
        double d11 = d9;
        do {
            d6 = d * (d3 + d4 + (d8 += 1.0) - 1.0) * d6 / (d3 + d8);
            d7 = d7 * this.halfLambda / d8;
            d9 = (d5 -= d6) * d7;
            d11 += d9;
            d2 = (d5 - d6) * (d10 -= d7);
        } while (d8 < 200.0 && d2 > this.tolerance);
        if (d2 > this.tolerance) {
            throw new RuntimeException("Cannot calculate cdf to required accuracy.");
        }
        return d11;
    }

    public double cdf(double d) {
        double d2;
        double d3;
        double d4;
        if (this.lambda == 0.0) {
            return this.centralBeta.cdf(d);
        }
        double d5 = this.p;
        double d6 = this.q;
        double d7 = 0.0;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0 || d == 1.0) {
            return d;
        }
        double d8 = this.halfLambda;
        int n = 0;
        if (this.lambda < 54.0) {
            return this.betanc(d);
        }
        int n2 = (int)Maths.truncate(d8 + 0.5);
        int n3 = (int)((double)n2 - 5.0 * Math.sqrt(n2));
        int n4 = (int)((double)n2 + 5.0 * Math.sqrt(n2));
        double d9 = -d8 + (double)n2 * this.logHalfLambda - Maths.logGamma((double)n2 + 1.0);
        double d10 = d4 = Math.exp(d9);
        double d11 = d4;
        double d12 = Maths.lnB(d5 + (double)n2, d6);
        double d13 = (d5 + (double)n2) * Math.log(d) + d6 * Math.log(1.0 - d) - Math.log(d5 + (double)n2) - d12;
        double d14 = d3 = Math.exp(d13);
        double d15 = d2 = Beta.incompleteBeta(d, d5 + (double)n2, d6, d12);
        ++n;
        double d16 = d4 * d2;
        int n5 = n2;
        while (n5 >= n3 && d4 >= this.tolerance) {
            d4 = d4 * (double)n5 / d8;
            ++n;
            d3 = (d5 + (double)n5) / (d * (d5 + d6 + (double)n5 - 1.0)) * d3;
            --n5;
            d11 += d4;
            d16 += d4 * (d2 += d3);
        }
        double d17 = Maths.logGamma(d5 + d6) - Maths.logGamma(d5 + 1.0) - Maths.logGamma(d6);
        double d18 = d5 * Math.log(d) + d6 * Math.log(1.0 - d);
        int n6 = 1;
        while (n6 <= n5) {
            double d19;
            int n7 = n6 - 1;
            d7 += Math.exp(d17 + d18 + (double)n7 * Math.log(d));
            d17 = d19 = Math.log(d5 + d6 + (double)n7) - Math.log(d5 + 1.0 + (double)n7) + d17;
            ++n6;
        }
        if (n5 <= 0) {
            n5 = 1;
        }
        double d20 = (1.0 - Gamma.incompleteGamma(d8, n5)) * (d2 + d7);
        d4 = d10;
        d2 = d15;
        d3 = d14;
        int n8 = n2;
        double d21;
        while (!((d21 = d20 + (1.0 - d11) * d2) < this.tolerance) && n8 < n4) {
            ++n;
            d4 = d4 * d8 / (double)(++n8);
            d11 += d4;
            d3 = d * (d5 + d6 + (double)n8 - 1.0) / (d5 + (double)n8) * d3;
            d16 += d4 * (d2 -= d3);
        }
        return d16;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getP() {
        return this.p;
    }

    public double getQ() {
        return this.q;
    }

    public double inverseCdf(double d) {
        if (this.lambda == 0.0) {
            return this.centralBeta.inverseCdf(d);
        }
        return super.inverseCdf(d);
    }

    public double mean() {
        if (this.lambda == 0.0) {
            return this.centralBeta.mean();
        }
        double d = 0.0;
        int n = 0;
        while (n < 1000) {
            double d2 = Math.exp(-this.halfLambda + (double)n * this.logHalfLambda - Maths.logGamma(n + 1) + Math.log(this.p + (double)n) - Math.log(this.p + (double)n + this.q));
            d += d2;
            if (Math.abs(d2) < this.tolerance * d) {
                return d;
            }
            ++n;
        }
        throw new RuntimeException("Cannot calculate mean to required accuracy.");
    }

    public Normal normalApproximation() {
        double d = this.halfLambda;
        double d2 = d * d;
        double d3 = d * d2;
        double d4 = d * d3;
        double d5 = this.p + this.q;
        double d6 = d5 * d5;
        double d7 = this.q * this.q;
        double d8 = d5 + d;
        double d9 = 1.0 - this.q / d8 * (1.0 + this.lambda / (2.0 * d8 * d8));
        double d10 = d8 * (d8 + 1.0) + d;
        double d11 = (d5 + d5 + 1.0) * (d5 + d5 + 1.0) + 1.0;
        double d12 = 3.0 * d6 + 5.0 * d5 + 2.0;
        double d13 = d6 * (d5 + 1.0) + d12 * d + (3.0 * d5 + 4.0) * d2 + d3;
        double d14 = (3.0 * d5 + 1.0) * (9.0 * d5 + 17.0) + 2.0 * d5 * (3.0 * d5 + 2.0) * (3.0 * d5 + 4.0) + 15.0;
        double d15 = 54.0 * d6 + 162.0 * d5 + 130.0;
        double d16 = 6.0 * (6.0 * d5 + 11.0);
        double d17 = d * (d12 * d12 + 2.0 * d14 * d + d15 * d2 + d16 * d3 + 9.0 * d4);
        double d18 = d * d7 / (d8 * d8 * d8 * d8);
        double d19 = this.q / d10 * (1.0 + d * (this.lambda * this.lambda + 3.0 * this.lambda + d11) / (d10 * d10)) - d7 / d13 * (1.0 + d17 / (d13 * d13));
        return new Normal(d9, Math.sqrt(d18 + d19));
    }

    public double pdf(double d) {
        if (this.lambda == 0.0) {
            return this.centralBeta.pdf(d);
        }
        if (d > 0.0 && d < 1.0 || d == 0.0 && this.p >= 1.0 || d == 1.0 && this.q >= 1.0) {
            if (d == 0.0) {
                return this.p == 1.0 ? this.q : 0.0;
            }
            if (d == 1.0) {
                return this.q == 1.0 ? this.p : 0.0;
            }
            double d2 = 0.0;
            double d3 = -this.halfLambda + (this.q - 1.0) * Math.log(1.0 - d) - this.logGammaQ;
            double d4 = Math.log(d);
            int n = 0;
            while (n < 1000) {
                double d5 = Math.exp(d3 + (double)n * this.logHalfLambda - Maths.logGamma(n + 1) + (this.p + (double)n - 1.0) * d4 + Maths.logGamma(this.p + this.q + (double)n) - Maths.logGamma(this.p + (double)n));
                d2 += d5;
                if (Math.abs(d5) < this.tolerance * d2) {
                    return d2;
                }
                ++n;
            }
            throw new RuntimeException("Cannot calculate pdf to required accuracy.");
        }
        throw new IllegalArgumentException("Invalid variate-value.");
    }

    public double random() {
        if (this.lambda == 0.0) {
            return this.centralBeta.random();
        }
        double d = this.Cp.random();
        return d / (d + this.Cq.random());
    }

    public void setParameters(double d, double d2, double d3) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid shape parameter.");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Invalid noncentrality parameter.");
        }
        this.p = d;
        this.q = d2;
        this.lambda = d3;
        this.setOpen(d < 1.0 || d2 < 1.0);
        if (d3 == 0.0) {
            this.centralBeta = new Beta(d, d2);
        } else {
            this.centralBeta = null;
            this.halfLambda = 0.5 * d3;
            this.logHalfLambda = Math.log(this.halfLambda);
            this.Cp = new NoncentralChiSquared(d + d, d3);
            this.Cq = new ChiSquared(d2 + d2);
            this.Cq.setSeed(this.rand.nextLong());
            this.logP = Math.log(d);
            this.logGammaQ = Maths.logGamma(d2);
            this.beta = Maths.logGamma(d) + this.logGammaQ - Maths.logGamma(d + d2);
            this.emhl = Math.exp(-this.halfLambda);
        }
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
        if (this.lambda == 0.0) {
            this.centralBeta.setSeed(this.rand.nextLong());
        } else {
            this.Cp.setSeed(this.rand.nextLong());
            this.Cq.setSeed(this.rand.nextLong());
        }
    }

    public String toString() {
        return new String("Noncentral beta distribution: p = " + this.p + ", q = " + this.q + ", lambda = " + this.lambda + ".");
    }

    public double variance() {
        if (this.lambda == 0.0) {
            return this.centralBeta.variance();
        }
        double d = 0.0;
        double d2 = this.mean();
        int n = 0;
        while (n < 1000) {
            double d3 = Math.exp(-this.halfLambda + (double)n * this.logHalfLambda - Maths.logGamma(n + 1) + Math.log(this.p + (double)n) + Math.log(this.p + (double)n + 1.0) - Math.log(this.p + (double)n + this.q + 1.0) - Math.log(this.p + (double)n + this.q));
            d += d3;
            if (Math.abs(d3) < this.tolerance * d) {
                return d - d2 * d2;
            }
            ++n;
        }
        throw new RuntimeException("Cannot calculate variance to required accuracy.");
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            NoncentralBeta noncentralBeta = new NoncentralBeta(5.0, 1.5, 4.0);
            noncentralBeta.setTolerance(1.0E-11);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = noncentralBeta.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, noncentralBeta, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

