/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.distributions.ChiSquared;
import jsc.distributions.Normal;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class Gamma
extends AbstractDistribution {
    private static final double ELIMIT = Math.log(Double.MIN_VALUE);
    private static final double OFLO = Math.sqrt(Double.MAX_VALUE);
    private double A;
    private double B;
    private double C;
    double logGammaShape;
    double logScale;
    double shape;
    double scale;

    public Gamma(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.shape = d;
        this.scale = d2;
        this.logGammaShape = Maths.logGamma(d);
        this.logScale = Math.log(d2);
        if (d > 1.0) {
            this.A = 1.0 / Math.sqrt(d + d - 1.0);
            this.B = d - Math.log(4.0);
            this.C = d + 1.0 / this.A;
        } else {
            this.A = 1.0 - d;
            this.B = (d + Math.E) / Math.E;
            this.C = 1.0 / d;
        }
    }

    public double cdf(double d) {
        return Gamma.incompleteGamma(d / this.scale, this.shape);
    }

    private double gamvar() {
        double d;
        double d2;
        double d3;
        int n;
        if (this.shape < 4.0 && (double)(n = (int)this.shape) == this.shape) {
            double d4 = 1.0;
            int n2 = 1;
            while (n2 <= n) {
                d4 *= 1.0 - this.rand.nextDouble();
                ++n2;
            }
            return -Math.log(d4);
        }
        if (this.shape > 1.0) {
            double d5;
            while (true) {
                double d6;
                if ((d6 = this.rand.nextDouble()) == 0.0) {
                    continue;
                }
                double d7 = 1.0 - this.rand.nextDouble();
                double d8 = this.A * Math.log(d6 / (1.0 - d6));
                if (!(this.B + this.C * d8 - (d5 = this.shape * Math.exp(d8)) < Math.log(d6 * d6 * d7))) break;
            }
            return d5;
        }
        do {
            d3 = this.B * this.rand.nextDouble();
            d = -Math.log(1.0 - this.rand.nextDouble());
        } while (!(d3 > 1.0 ? this.A * Math.log(d2 = -Math.log((this.B - d3) / this.shape)) <= d : (d2 = Math.pow(d3, this.C)) <= d));
        return d2;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public static double incompleteGamma(double d, double d2) {
        double d3 = 0.0;
        if (d2 <= 0.0 || d < 0.0) {
            throw new IllegalArgumentException("Invalid argument of incomplete gamma integral.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d2 > 1000.0) {
            double d4 = 3.0 * Math.sqrt(d2) * (Math.pow(d / d2, 0.3333333333333333) + 1.0 / (9.0 * d2) - 1.0);
            return Normal.standardTailProb(d4, false);
        }
        if (d > 1000000.0) {
            return 1.0;
        }
        if (d <= 1.0 || d < d2) {
            double d5 = d2 * Math.log(d) - d - Maths.logGamma(d2 + 1.0);
            double d6 = 1.0;
            d3 = 1.0;
            double d7 = d2;
            do {
                d3 += (d6 *= d / (d7 += 1.0));
            } while (d6 > 1.0E-17);
            d5 += Math.log(d3);
            d3 = 0.0;
            if (d5 >= ELIMIT) {
                d3 = Math.exp(d5);
            }
        } else {
            double d8 = d2 * Math.log(d) - d - Maths.logGamma(d2);
            double d9 = 1.0 - d2;
            double d10 = d9 + d + 1.0;
            double d11 = 0.0;
            double d12 = 1.0;
            double d13 = d;
            double d14 = d + 1.0;
            double d15 = d * d10;
            d3 = d14 / d15;
            while (true) {
                double d16 = (d9 += 1.0) * (d11 += 1.0);
                double d17 = (d10 += 2.0) * d14 - d16 * d12;
                double d18 = d10 * d15 - d16 * d13;
                if (Math.abs(d18) > 0.0) {
                    double d19 = d17 / d18;
                    if (Math.abs(d3 - d19) <= Math.min(1.0E-17, 1.0E-17 * d19)) break;
                    d3 = d19;
                }
                d12 = d14;
                d13 = d15;
                d14 = d17;
                d15 = d18;
                if (!(Math.abs(d17) >= OFLO)) continue;
                d12 /= OFLO;
                d13 /= OFLO;
                d14 /= OFLO;
                d15 /= OFLO;
            }
            d8 += Math.log(d3);
            d3 = 1.0;
            if (d8 >= ELIMIT) {
                d3 = 1.0 - Math.exp(d8);
            }
        }
        return d3;
    }

    public double inverseCdf(double d) {
        return 0.5 * this.scale * ChiSquared.inverseCdf(d, this.shape + this.shape, this.logGammaShape);
    }

    public double mean() {
        return this.shape * this.scale;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return Math.exp((this.shape - 1.0) * Math.log(d) - d / this.scale - this.logGammaShape - this.shape * this.logScale);
    }

    public double random() {
        return this.scale * this.gamvar();
    }

    public String toString() {
        return new String("Gamma distribution: shape = " + this.shape + ", scale = " + this.scale + ".");
    }

    public double variance() {
        return this.shape * this.scale * this.scale;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 50.0;
            double d2 = 20.0;
            Gamma gamma = new Gamma(d, d2);
            int n = 10000;
            gamma = new Gamma(0.01, 1.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = gamma.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, gamma, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

