/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

import java.util.Arrays;

public final class OrderStatistics
implements Cloneable {
    private final int n;
    private double maximum;
    private double minimum;
    private final double median;
    private final double lowerQuartile;
    private final double upperQuartile;

    public OrderStatistics(double[] dArray) {
        this.n = dArray.length;
        if (this.n < 1) {
            throw new IllegalArgumentException("No values");
        }
        this.minimum = dArray[0];
        this.maximum = dArray[this.n - 1];
        if (this.n == 1) {
            this.lowerQuartile = dArray[0];
            this.upperQuartile = dArray[0];
            this.median = dArray[0];
        } else if (this.n == 2) {
            if (dArray[0] > dArray[1]) {
                dArray[0] = this.maximum;
                dArray[1] = this.minimum;
                this.minimum = dArray[0];
                this.maximum = dArray[this.n - 1];
            }
            this.lowerQuartile = dArray[0];
            this.upperQuartile = dArray[1];
            this.median = (dArray[0] + dArray[1]) / 2.0;
        } else {
            int n;
            Arrays.sort(dArray);
            this.minimum = dArray[0];
            this.maximum = dArray[this.n - 1];
            int n2 = (this.n + 1) % 4;
            if (n2 != 0) {
                n = (this.n + 1) / 4 - 1;
                this.lowerQuartile = dArray[n] + (double)n2 * (dArray[n + 1] - dArray[n]) / 4.0;
            } else {
                this.lowerQuartile = dArray[(this.n + 1) / 4 - 1];
            }
            n2 = 3 * (this.n + 1) % 4;
            if (n2 != 0) {
                n = 3 * (this.n + 1) / 4 - 1;
                this.upperQuartile = dArray[n] + (double)n2 * (dArray[n + 1] - dArray[n]) / 4.0;
            } else {
                this.upperQuartile = dArray[3 * (this.n + 1) / 4 - 1];
            }
            n2 = n = this.n / 2;
            this.median = this.n % 2 != 0 ? dArray[n2] : 0.5 * (dArray[n - 1] + dArray[n2]);
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("OrderStatistics can't clone");
        }
        return object;
    }

    public double getLowerQuartile() {
        return this.lowerQuartile;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public int getN() {
        return this.n;
    }

    public double getUpperQuartile() {
        return this.upperQuartile;
    }

    public double getInterquartileRange() {
        return this.upperQuartile - this.lowerQuartile;
    }

    public double getRange() {
        return this.maximum - this.minimum;
    }

    private static void swap(double d, double d2) {
        double d3 = d;
        d = d2;
        d2 = d3;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{73.0, 62.7, 59.3, 68.2, 63.9};
            int n = 2;
            OrderStatistics orderStatistics = new OrderStatistics(dArray);
            System.out.println("N = " + orderStatistics.getN());
            System.out.println("Median = " + orderStatistics.getMedian());
            System.out.println("Minimum = " + orderStatistics.getMinimum());
            System.out.println("Maximum = " + orderStatistics.getMaximum());
            System.out.println("Lower quartile = " + orderStatistics.getLowerQuartile());
            System.out.println("Upper quartile = " + orderStatistics.getUpperQuartile());
        }
    }
}

