/*
 * Decompiled with CFR 0.152.
 */
package jsc.contingencytables;

import jsc.contingencytables.ContingencyTable2x2;
import jsc.distributions.ChiSquared;
import jsc.tests.SignificanceTest;

public class McNemarTest
implements SignificanceTest {
    private double chiSquared;
    private double SP;

    public McNemarTest(ContingencyTable2x2 contingencyTable2x2) {
        this(contingencyTable2x2, true);
    }

    public McNemarTest(ContingencyTable2x2 contingencyTable2x2, boolean bl) {
        int n = contingencyTable2x2.getFrequency(0, 1);
        int n2 = contingencyTable2x2.getFrequency(1, 0);
        if (n + n2 == 0) {
            throw new IllegalArgumentException("Frequencies are zero.");
        }
        if (bl) {
            double d = Math.abs(n - n2) - 1;
            this.chiSquared = d * d / (double)(n + n2);
        } else {
            double d = n - n2;
            this.chiSquared = d * d / (double)(n + n2);
        }
        this.SP = ChiSquared.upperTailProb(this.chiSquared, 1.0);
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.chiSquared;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "C", "C", "C", "C", "C", "C", "C"};
            String[] stringArray3 = new String[]{"A", "A", "A", "A", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "A", "A", "A", "A"};
            int n = 2;
            ContingencyTable2x2[] contingencyTable2x2Array = new ContingencyTable2x2[n];
            contingencyTable2x2Array[0] = new ContingencyTable2x2(14, 5, 2, 2);
            contingencyTable2x2Array[1] = new ContingencyTable2x2(stringArray2, stringArray3);
            int n2 = 0;
            while (n2 < n) {
                System.out.println(contingencyTable2x2Array[n2].toString());
                McNemarTest mcNemarTest = new McNemarTest(contingencyTable2x2Array[n2]);
                System.out.println("Chi-squared = " + mcNemarTest.getTestStatistic() + " SP = " + mcNemarTest.getSP());
                ++n2;
            }
        }
    }
}

