/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.trajectoryfile;

import ca.ubc.cs.beta.aeatk.eventsystem.EventHandler;
import ca.ubc.cs.beta.aeatk.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.AutomaticConfigurationEnd;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.model.ModelBuildStartEvent;
import ca.ubc.cs.beta.aeatk.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.termination.TerminationCondition;
import ca.ubc.cs.beta.aeatk.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryFileLogger
implements EventHandler<AutomaticConfiguratorEvent> {
    private double lastEmpericalPerformance = 0.0;
    private ParameterConfiguration lastIncumbent;
    private final RunHistory runHistory;
    private final TerminationCondition terminationCondition;
    private final FileWriter trajectoryFileWriter;
    private final FileWriter trajectoryFileWriterCSV;
    private final String fileNamePrefix;
    private static final Logger log = LoggerFactory.getLogger(TrajectoryFileLogger.class);
    private final CPUTime cpuTime;
    boolean closed = false;
    private volatile SoftReference<Object> softModel = new SoftReference<Object>(null);
    private volatile Object hardModel;
    private volatile Boolean logModel;
    private AtomicBoolean modelPredictionErrorLogged = new AtomicBoolean(false);
    IncumbentPerformanceChangeEvent lastIevent;
    private final List<TrajectoryFileEntry> tfes = new ArrayList<TrajectoryFileEntry>();

    public TrajectoryFileLogger(RunHistory runHistory, TerminationCondition terminationCondition, String fileNamePrefix, ParameterConfiguration initialIncumbent, CPUTime cpuTime) {
        this.fileNamePrefix = fileNamePrefix;
        this.runHistory = runHistory;
        this.terminationCondition = terminationCondition;
        this.cpuTime = cpuTime;
        try {
            this.trajectoryFileWriter = new FileWriter(fileNamePrefix + ".txt");
            File f = new File(fileNamePrefix);
            this.trajectoryFileWriterCSV = new FileWriter(f.getParentFile().getAbsolutePath() + File.separator + "detailed-" + f.getName() + ".csv");
            this.trajectoryFileWriter.append("\"CPU Time Used\",\"Estimated Training Performance\",\"Wallclock Time\",\"Incumbent ID\",\"Automatic Configurator (CPU) Time\",\"Configuration...\"\n");
            this.trajectoryFileWriterCSV.append("\"CPU Time Used\",\"Estimated Training Performance\",\"Wallclock Time\",\"Incumbent ID\",\"Automatic Configurator (CPU) Time\",\"Full Configuration\",\"Predicted Performance (if available)\",\n");
            this.writeIncumbent(0.0, Double.MAX_VALUE, 0.0, initialIncumbent, 0.0);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error occured creating files", e);
        }
    }

    @Override
    public synchronized void handleEvent(AutomaticConfiguratorEvent event) {
        if (event instanceof IncumbentPerformanceChangeEvent) {
            IncumbentPerformanceChangeEvent ievent;
            if (this.closed) {
                log.error("Got Another Event After shutdown:{} ", (Object)event.getClass().getCanonicalName());
            }
            this.lastIevent = ievent = (IncumbentPerformanceChangeEvent)event;
            this.writeIncumbent(ievent.getTunerTime(), ievent.getEmpiricalPerformance(), ievent.getWallTime(), ievent.getIncumbent(), ievent.getAutomaticConfiguratorCPUTime());
        } else if (event instanceof AutomaticConfigurationEnd) {
            this.hardModel = null;
            log.debug("Writing trajectory file to {}", (Object)new File(this.fileNamePrefix).getAbsolutePath());
            if (this.lastIevent != null) {
                this.writeIncumbent(this.terminationCondition.getTunerTime(), this.lastIevent.getEmpiricalPerformance(), this.terminationCondition.getWallTime(), this.lastIevent.getIncumbent(), this.cpuTime.getCPUTime());
            }
            try {
                this.trajectoryFileWriter.close();
                this.trajectoryFileWriterCSV.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.closed = true;
        } else if (event instanceof ModelBuildStartEvent) {
            this.hardModel = null;
        } else if (event instanceof ModelBuildEndEvent) {
            Object theModel = ((ModelBuildEndEvent)event).getModelIfAvailable();
            this.softModel = new SoftReference<Object>(theModel);
            this.hardModel = theModel;
            this.logModel = ((ModelBuildEndEvent)event).isLogModel();
        } else {
            log.error("Got an event I wasn't expecting: {}", (Object)event.getClass().getCanonicalName());
        }
    }

    private synchronized void writeIncumbent(double tunerTime, double empiricalPerformance, double wallclockTime, ParameterConfiguration incumbent, double acTime) {
        double predictedPerformance;
        String outLine;
        String escapedParamString;
        double wallClockTime;
        int thetaIdxInc;
        block12: {
            this.tfes.add(new TrajectoryFileEntry(incumbent, tunerTime, wallclockTime, empiricalPerformance, acTime));
            boolean outOfTime = this.terminationCondition.haveToStop();
            if (incumbent.equals(this.lastIncumbent) && this.lastEmpericalPerformance == empiricalPerformance && !outOfTime) {
                log.trace("No change in performance");
                return;
            }
            log.trace("Incumbent Performance changed");
            this.lastEmpericalPerformance = empiricalPerformance;
            this.lastIncumbent = incumbent;
            thetaIdxInc = this.runHistory.getThetaIdx(incumbent);
            if (thetaIdxInc == -1) {
                thetaIdxInc = 1;
            }
            wallClockTime = wallclockTime;
            String paramString = incumbent.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.STATEFILE_SYNTAX);
            escapedParamString = paramString.replaceAll(",", "\\,");
            outLine = tunerTime + ", " + empiricalPerformance + ", " + wallClockTime + ", " + thetaIdxInc + ", " + acTime + ", " + paramString + "\n";
            predictedPerformance = Double.NaN;
            Object theModel = this.hardModel;
            if (theModel == null) {
                theModel = this.softModel.get();
            }
            if (theModel != null) {
                if (theModel instanceof RandomForest) {
                    RandomForest rf = (RandomForest)theModel;
                    try {
                        predictedPerformance = this.applyMarginalModel(Collections.singletonList(incumbent), rf)[0][0];
                        if (this.logModel == null || this.logModel.booleanValue()) {
                            predictedPerformance = Math.pow(10.0, predictedPerformance);
                        }
                        break block12;
                    }
                    catch (RuntimeException e) {
                        if (this.modelPredictionErrorLogged.compareAndSet(false, true)) {
                            log.error("Couldn't log predicted performance of model see error (possibly because model wasn't preprocessed marginal version (no further errors will be logged):", (Throwable)e);
                        }
                        break block12;
                    }
                }
                if (this.modelPredictionErrorLogged.compareAndSet(false, true)) {
                    log.warn("New Model Type Detected {}, not sure how to make predictions on it in ", (Object)theModel.getClass().getCanonicalName());
                }
            }
        }
        String escapedOutLine = "\"" + tunerTime + "\",\" " + empiricalPerformance + "\",\"" + wallClockTime + "\",\"" + thetaIdxInc + "\",\"" + acTime + "\", \"" + escapedParamString + "\",\"" + predictedPerformance + "\"\n";
        log.trace("Logging incumbent: (Runs {}): {}", this.lastIevent != null ? Long.valueOf(this.lastIevent.getIncumbentRunCount()) : "?", (Object)outLine.trim());
        try {
            this.trajectoryFileWriter.write(outLine);
            this.trajectoryFileWriter.flush();
            this.trajectoryFileWriterCSV.write(escapedOutLine);
            this.trajectoryFileWriterCSV.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not update trajectory file", e);
        }
    }

    public final synchronized List<TrajectoryFileEntry> getTrajectoryFileEntries() {
        return Collections.unmodifiableList(this.tfes);
    }

    protected double[][] applyMarginalModel(double[][] configArrays, RandomForest forest) {
        int[] treeIdxsToUse = new int[forest.numTrees];
        for (int i = 0; i < forest.numTrees; ++i) {
            treeIdxsToUse[i] = i;
        }
        return RandomForest.applyMarginal((RandomForest)forest, (int[])treeIdxsToUse, (double[][])configArrays);
    }

    protected double[][] applyMarginalModel(List<ParameterConfiguration> configs, RandomForest forest) {
        double[][] configArrays = new double[configs.size()][];
        int i = 0;
        for (ParameterConfiguration config : configs) {
            configArrays[i] = config.toValueArray();
            ++i;
        }
        return this.applyMarginalModel(configArrays, forest);
    }
}

