/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.trajectoryfile;

import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;

public class TrajectoryFileEntry
implements Comparable<TrajectoryFileEntry> {
    private final ParameterConfiguration config;
    private final double empiricalPerformance;
    private final double acOverhead;
    private final double tunerTime;
    private final double wallTime;

    public TrajectoryFileEntry(ParameterConfiguration config, double tunerTime, double walltime, double empiricalPerformance, double acOverhead) {
        this.config = config;
        this.empiricalPerformance = empiricalPerformance;
        this.acOverhead = acOverhead;
        this.wallTime = walltime;
        this.tunerTime = tunerTime;
    }

    public ParameterConfiguration getConfiguration() {
        return this.config;
    }

    public double getEmpericalPerformance() {
        return this.empiricalPerformance;
    }

    public double getACOverhead() {
        return this.acOverhead;
    }

    public double getTunerTime() {
        return this.tunerTime;
    }

    public double getWallTime() {
        return this.wallTime;
    }

    @Override
    public int compareTo(TrajectoryFileEntry o) {
        if (this.tunerTime - o.tunerTime < 0.0) {
            return -1;
        }
        if (this.tunerTime - o.tunerTime == 0.0) {
            if (this.config.equals(o.config)) {
                return 0;
            }
            return this.config.getFriendlyID() - o.config.getFriendlyID();
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof TrajectoryFileEntry) {
            TrajectoryFileEntry oTFE = (TrajectoryFileEntry)o;
            if (oTFE.acOverhead != this.acOverhead) {
                return false;
            }
            if (oTFE.empiricalPerformance != this.empiricalPerformance) {
                return false;
            }
            if (oTFE.wallTime != oTFE.wallTime) {
                return false;
            }
            if (oTFE.tunerTime != oTFE.tunerTime) {
                return false;
            }
            return oTFE.config.equals(this.config);
        }
        return false;
    }

    public int hashCode() {
        long val = Double.doubleToLongBits(this.tunerTime) ^ Double.doubleToLongBits(this.acOverhead) ^ Double.doubleToLongBits(this.wallTime) ^ Double.doubleToLongBits(this.empiricalPerformance);
        int hash = (int)(val >> 32) ^ (int)val;
        return hash ^ this.config.hashCode();
    }

    public String toString() {
        return "<" + this.getTunerTime() + "," + this.getEmpericalPerformance() + "," + this.getWallTime() + "," + this.config.getFriendlyIDHex() + ">";
    }
}

