/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FileCacheTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final Map<AlgorithmRunConfiguration, AlgorithmRunResult> cache;
    private final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> learnedRuns = new ConcurrentHashMap();
    private final File output;
    private final int numRun;
    private final AtomicInteger collisions = new AtomicInteger(0);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean learntRunsWritten = new AtomicBoolean();
    private final AtomicInteger cacheHits = new AtomicInteger(0);
    private final AtomicInteger runRequests = new AtomicInteger(0);
    private final boolean crashOnCacheMiss;

    public FileCacheTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, File source, File output, int numRun, boolean crashOnCacheMiss) {
        super(tae);
        this.output = output;
        this.numRun = numRun;
        this.crashOnCacheMiss = crashOnCacheMiss;
        if (output == null && source == null) {
            throw new ParameterException("Both source and output options for the file cache are null, you must set at least one of them.");
        }
        if (output != null) {
            if (output.exists() && !output.canWrite()) {
                throw new ParameterException("Cannot write to output, check permissions: " + output.getAbsolutePath());
            }
            if (!output.exists() && !output.getParentFile().mkdirs()) {
                throw new ParameterException("Could not create directory: " + output.getAbsolutePath());
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    String name = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("FileCacheTargetAlgorithmEvaluator Fallback writing thread");
                        FileCacheTargetAlgorithmEvaluatorDecorator.this.writeLearnedRuns();
                    }
                    finally {
                        Thread.currentThread().setName(name);
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(run));
        }
        ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> cacheLoading = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
        this.cache = Collections.unmodifiableMap(cacheLoading);
        if (source != null) {
            if (!source.exists()) {
                throw new ParameterException("Could not read source:" + source.getAbsolutePath());
            }
            if (source.isDirectory()) {
                TreeMap files = new TreeMap();
                for (File f : source.listFiles()) {
                    long lastModified = f.lastModified();
                    if (files.get(lastModified) == null) {
                        files.put(lastModified, new TreeMap());
                    }
                    ((Map)files.get(lastModified)).put(f.getAbsolutePath(), f);
                }
                ArrayList<File> fileList = new ArrayList<File>();
                for (Map val : files.values()) {
                    for (File valFile : val.values()) {
                        fileList.add(valFile);
                    }
                }
                for (File f : fileList) {
                    this.readFile(f, cacheLoading);
                }
            } else {
                this.readFile(source, cacheLoading);
            }
            this.log.info("File Cache of Runs has been initialized from {} ; {} entries prepopulated in cache; {} duplicates", new Object[]{source.getAbsolutePath(), this.cache.size(), this.collisions.get()});
        }
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> AlgorithmRunConfigurations, final TargetAlgorithmEvaluatorCallback handler, final TargetAlgorithmEvaluatorRunObserver obs) {
        ArrayList<AlgorithmRunConfiguration> runsToSubmit = new ArrayList<AlgorithmRunConfiguration>(AlgorithmRunConfigurations.size());
        final ConcurrentSkipListMap<Integer, AlgorithmRunConfiguration> AlgorithmRunConfigurationOrder = new ConcurrentSkipListMap<Integer, AlgorithmRunConfiguration>();
        final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> solvedRuns = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
        for (int i = 0; i < AlgorithmRunConfigurations.size(); ++i) {
            AlgorithmRunConfiguration rc = AlgorithmRunConfigurations.get(i);
            AlgorithmRunConfigurationOrder.put(i, rc);
            this.runRequests.incrementAndGet();
            if (this.cache.get(rc) != null) {
                this.cacheHits.incrementAndGet();
                solvedRuns.put(rc, this.cache.get(rc));
                continue;
            }
            runsToSubmit.add(rc);
        }
        TargetAlgorithmEvaluatorRunObserver myObs = new TargetAlgorithmEvaluatorRunObserver(){
            Map<AlgorithmRunConfiguration, AlgorithmRunResult> myRuns = new HashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (obs == null) {
                    return;
                }
                ArrayList<Object> runsToReport = new ArrayList<Object>(AlgorithmRunConfigurations.size());
                this.myRuns.clear();
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    this.myRuns.put(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult);
                }
                for (AlgorithmRunConfiguration algorithmRunConfiguration : AlgorithmRunConfigurationOrder.values()) {
                    if (solvedRuns.contains(algorithmRunConfiguration)) {
                        runsToReport.add(solvedRuns.get(algorithmRunConfiguration));
                        continue;
                    }
                    runsToReport.add(this.myRuns.get(algorithmRunConfiguration));
                }
                obs.currentStatus(runsToReport);
            }
        };
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                HashMap<AlgorithmRunConfiguration, AlgorithmRunResult> myRuns = new HashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
                ArrayList<AlgorithmRunResult> runsToReport = new ArrayList<AlgorithmRunResult>(AlgorithmRunConfigurations.size());
                for (AlgorithmRunResult run : runs) {
                    myRuns.put(run.getAlgorithmRunConfiguration(), run);
                }
                for (AlgorithmRunConfiguration rc : AlgorithmRunConfigurationOrder.values()) {
                    if (solvedRuns.containsKey(rc)) {
                        runsToReport.add((AlgorithmRunResult)solvedRuns.get(rc));
                        continue;
                    }
                    runsToReport.add((AlgorithmRunResult)myRuns.get(rc));
                    FileCacheTargetAlgorithmEvaluatorDecorator.this.learnedRuns.put(rc, myRuns.get(rc));
                }
                handler.onSuccess(runsToReport);
            }

            @Override
            public void onFailure(RuntimeException e) {
                handler.onFailure(e);
            }
        };
        if (runsToSubmit.size() > 0) {
            if (this.crashOnCacheMiss) {
                throw new IllegalStateException("We don't have a cache entry for the following runs: " + runsToSubmit);
            }
            this.tae.evaluateRunsAsync(runsToSubmit, myHandler, myObs);
        } else {
            try {
                ArrayList<AlgorithmRunResult> runs = new ArrayList<AlgorithmRunResult>();
                for (AlgorithmRunConfiguration rc : AlgorithmRunConfigurations) {
                    runs.add((AlgorithmRunResult)solvedRuns.get(rc));
                }
                myHandler.onSuccess(runs);
            }
            catch (RuntimeException e) {
                myHandler.onFailure(e);
            }
        }
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> AlgorithmRunConfigurations, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(AlgorithmRunConfigurations, this, obs);
    }

    private void readFile(File f, ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> cacheLoading) {
        block4: {
            boolean logError = false;
            if (f.getAbsolutePath().endsWith(".bin") || f.getAbsolutePath().endsWith(".json")) {
                logError = true;
            }
            try {
                List<AlgorithmRunResult> runs = this.getListFromFile(f);
                for (AlgorithmRunResult run : runs) {
                    if (cacheLoading.putIfAbsent(run.getAlgorithmRunConfiguration(), run) == null) continue;
                    this.collisions.incrementAndGet();
                }
            }
            catch (IOException e) {
                if (!logError) break block4;
                this.log.error("Coludn't read file {} ", (Object)f);
                this.log.error("Couldn't read data from file", (Throwable)e);
            }
        }
    }

    private List<AlgorithmRunResult> getListFromFile(File f) throws IOException {
        try {
            return this.getListFromJSONFile(f);
        }
        catch (IOException e) {
            try {
                return this.getListFromJavaSerializedFile(f);
            }
            catch (Exception e2) {
                this.log.trace("Trying to read from JSON file as binary file, exception:", (Throwable)e2);
                throw e;
            }
        }
    }

    private List<AlgorithmRunResult> getListFromJSONFile(File f) throws JsonParseException, IOException {
        JsonFactory jfactory = new JsonFactory();
        ObjectMapper map = new ObjectMapper(jfactory);
        SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
        map.registerModule((Module)sModule);
        JsonParser jParser = jfactory.createParser(f);
        ArrayList<Object> runs = new ArrayList<Object>(Arrays.asList((Object[])map.readValue(jParser, AlgorithmRunResult[].class)));
        return runs;
    }

    private List<AlgorithmRunResult> getListFromJavaSerializedFile(File f) throws IOException, ClassNotFoundException {
        FileInputStream fin = new FileInputStream(f);
        ObjectInputStream in = new ObjectInputStream(fin);
        return (List)in.readObject();
    }

    @Override
    public void postDecorateeNotifyShutdown() {
        try {
            this.log.info(this.getClass().getSimpleName() + ": Total Requests: {}, Cache Hits {}", (Object)this.runRequests.get(), (Object)this.cacheHits.get());
        }
        finally {
            this.writeLearnedRuns();
        }
    }

    private synchronized void writeLearnedRuns() {
        if (this.learntRunsWritten.compareAndSet(false, true)) {
            if (this.output != null && this.learnedRuns.size() > 0) {
                UUID uuid = UUID.randomUUID();
                File outFile = this.output.isDirectory() ? new File(this.output + File.separator + "rundata-" + this.numRun + "-" + uuid.toString() + ".json") : this.output;
                try {
                    outFile.createNewFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!outFile.canWrite()) {
                    this.log.error("Cannot write to output file : {} ", (Object)outFile.getAbsolutePath());
                }
                try (FileWriter fWrite = new FileWriter(outFile);){
                    ArrayList<AlgorithmRunResult> runs = new ArrayList<AlgorithmRunResult>(this.learnedRuns.size());
                    for (AlgorithmRunResult run : this.learnedRuns.values()) {
                        runs.add(run);
                    }
                    ObjectMapper map = new ObjectMapper();
                    SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
                    map.registerModule((Module)sModule);
                    map.writeValue((Writer)fWrite, runs);
                }
                catch (IOException e) {
                    this.log.error("Couldn't write data to file: {}", (Object)outFile);
                    this.log.error("Encountered Error while writing data {}", (Throwable)e);
                }
            }
        } else {
            return;
        }
    }
}

