/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.functionality.portfolio;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.functionality.portfolio.PortfolioRunKillingPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortfolioTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>> fPortfolio;
    private final RunObjective fRunObj;
    private final boolean fSubmitOriginalRun;
    private final PortfolioRunKillingPolicy fPortfolioRunKillingPolicy;

    public static PortfolioTargetAlgorithmEvaluatorDecorator constructParamConfigPortfolioTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator aTAE, List<ParameterConfiguration> aParamConfigs, RunObjective aRunObj, boolean aSubmitOriginalRun, PortfolioRunKillingPolicy aPortfolioRunKillingPolicy) {
        ArrayList<Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>> portfolio = new ArrayList<Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>>();
        for (ParameterConfiguration paramConfig : aParamConfigs) {
            portfolio.add(new Pair<Object, ParameterConfiguration>(null, paramConfig));
        }
        return new PortfolioTargetAlgorithmEvaluatorDecorator(aTAE, portfolio, aRunObj, aSubmitOriginalRun, aPortfolioRunKillingPolicy);
    }

    public static PortfolioTargetAlgorithmEvaluatorDecorator constructExecConfigPortfolioTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator aTAE, List<AlgorithmExecutionConfiguration> aExecConfig, RunObjective aRunObj, boolean aSubmitOriginalRun, PortfolioRunKillingPolicy aPortfolioRunKillingPolicy) {
        ArrayList<Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>> portfolio = new ArrayList<Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>>();
        for (AlgorithmExecutionConfiguration execConfig : aExecConfig) {
            portfolio.add(new Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>(execConfig, execConfig.getParameterConfigurationSpace().getDefaultConfiguration()));
        }
        return new PortfolioTargetAlgorithmEvaluatorDecorator(aTAE, portfolio, aRunObj, aSubmitOriginalRun, aPortfolioRunKillingPolicy);
    }

    public PortfolioTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator aTAE, List<Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>> aPortfolio, RunObjective aRunObj, boolean aSubmitOriginalRun, PortfolioRunKillingPolicy aPortfolioRunKillingPolicy) {
        super(aTAE);
        if (aPortfolio.size() == 0) {
            throw new IllegalArgumentException("Portfolio must contain at least one configuration");
        }
        if (new HashSet<Pair<AlgorithmExecutionConfiguration, ParameterConfiguration>>(aPortfolio).size() != aPortfolio.size()) {
            throw new IllegalArgumentException("Portfolio must be constructed with distinct execution configuration / parameter configuration pairs, duplicates detected.");
        }
        for (Pair<AlgorithmExecutionConfiguration, ParameterConfiguration> portfolioEntry : aPortfolio) {
            AlgorithmExecutionConfiguration execConfig = portfolioEntry.getFirst();
            ParameterConfiguration paramConfig = portfolioEntry.getSecond();
            if (paramConfig == null) {
                throw new IllegalArgumentException("Portfolio parameter configuration cannot be null.");
            }
            if (paramConfig.isForbiddenParameterConfiguration()) {
                throw new IllegalArgumentException("A portfolio entry contains a forbidden param configuration.");
            }
            if (execConfig == null || !execConfig.getParameterConfigurationSpace().getParameterConfigurationFromString(paramConfig.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX), ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX).isForbiddenParameterConfiguration()) continue;
            throw new IllegalArgumentException("A portfolio entry contains an incompatible exec config / param config pair.");
        }
        this.fPortfolio = aPortfolio;
        this.fRunObj = aRunObj;
        this.fSubmitOriginalRun = aSubmitOriginalRun;
        this.fPortfolioRunKillingPolicy = aPortfolioRunKillingPolicy;
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> aOriginalRunConfigs, TargetAlgorithmEvaluatorCallback aHandler, TargetAlgorithmEvaluatorRunObserver aObserver) {
        if (aOriginalRunConfigs.isEmpty()) {
            aHandler.onSuccess(Collections.emptyList());
            return;
        }
        int portfolioRunsPerOriginalRun = this.fSubmitOriginalRun ? this.fPortfolio.size() + 1 : this.fPortfolio.size();
        ArrayList<AlgorithmRunConfiguration> portfolioRunConfigs = new ArrayList<AlgorithmRunConfiguration>();
        for (AlgorithmRunConfiguration rc : aOriginalRunConfigs) {
            if (this.fSubmitOriginalRun) {
                portfolioRunConfigs.add(rc);
            }
            for (Pair<AlgorithmExecutionConfiguration, ParameterConfiguration> portfolioEntry : this.fPortfolio) {
                AlgorithmExecutionConfiguration execConfig = portfolioEntry.getFirst();
                AlgorithmExecutionConfiguration runExecConfig = execConfig != null ? execConfig : rc.getAlgorithmExecutionConfiguration();
                ParameterConfiguration runParamConfig = portfolioEntry.getSecond();
                if (runExecConfig.getParameterConfigurationSpace().getParameterConfigurationFromString(runParamConfig.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX), ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX).isForbiddenParameterConfiguration()) {
                    throw new IllegalArgumentException("Substituting paramater config and exec config for run ended in a forbidden configuration.");
                }
                portfolioRunConfigs.add(new AlgorithmRunConfiguration(rc.getProblemInstanceSeedPair(), rc.getCutoffTime(), runParamConfig, runExecConfig));
            }
        }
        if (new HashSet(portfolioRunConfigs).size() != portfolioRunConfigs.size()) {
            throw new IllegalStateException("Portfolio TAE decorator would submit duplicated runs.");
        }
        if (portfolioRunConfigs.size() != portfolioRunsPerOriginalRun * aOriginalRunConfigs.size()) {
            throw new IllegalStateException("The number of runs to submit is not a multiple of the portfolio size.");
        }
        TargetAlgorithmEvaluatorCallback myHandler = this.getPortfolioCallback(aHandler, aOriginalRunConfigs, portfolioRunsPerOriginalRun);
        TargetAlgorithmEvaluatorRunObserver myObs = this.getPortfolioObserver(aObserver, aOriginalRunConfigs, portfolioRunsPerOriginalRun);
        this.log.trace("Portfolio request translated runs {} to {} ", (Object)aOriginalRunConfigs.size(), (Object)portfolioRunConfigs.size());
        this.tae.evaluateRunsAsync(portfolioRunConfigs, myHandler, myObs);
    }

    private TargetAlgorithmEvaluatorCallback getPortfolioCallback(final TargetAlgorithmEvaluatorCallback aOriginalCallback, final List<AlgorithmRunConfiguration> aOriginalRunConfigs, final int aPortfolioRunsPerOriginalRun) {
        return new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback fHandler;
            {
                this.fHandler = aOriginalCallback;
            }

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                if (runs.size() != aOriginalRunConfigs.size() * aPortfolioRunsPerOriginalRun) {
                    throw new IllegalArgumentException("Provided " + runs.size() + " runs, not all the " + aOriginalRunConfigs.size() + "*" + aPortfolioRunsPerOriginalRun + " (=" + aOriginalRunConfigs.size() * aPortfolioRunsPerOriginalRun + ") portfolio runs submitted (from " + aOriginalRunConfigs.size() + " original runs).");
                }
                ArrayList<AlgorithmRunResult> listToReturn = new ArrayList<AlgorithmRunResult>();
                for (int i = 0; i < aOriginalRunConfigs.size(); ++i) {
                    listToReturn.add(this.getAlgorithmRunForCallback((AlgorithmRunConfiguration)aOriginalRunConfigs.get(i), runs.subList(i * aPortfolioRunsPerOriginalRun, (i + 1) * aPortfolioRunsPerOriginalRun)));
                }
                this.fHandler.onSuccess(listToReturn);
            }

            private AlgorithmRunResult getAlgorithmRunForCallback(AlgorithmRunConfiguration originalRunConfig, List<AlgorithmRunResult> runs) {
                AlgorithmRunResult bestRun = runs.get(0);
                for (AlgorithmRunResult run : runs) {
                    if (!(PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective(run) < PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective(bestRun))) continue;
                    bestRun = run;
                }
                if (PortfolioTargetAlgorithmEvaluatorDecorator.this.fPortfolioRunKillingPolicy.equals((Object)PortfolioRunKillingPolicy.SLOWERDIES)) {
                    Object bestSolvedRun = null;
                    for (AlgorithmRunResult run : runs) {
                        if (run.isCensoredEarly()) continue;
                        if (bestSolvedRun == null) {
                            bestSolvedRun = run;
                            continue;
                        }
                        if (!(PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective(run) < PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective((AlgorithmRunResult)bestSolvedRun))) continue;
                        bestSolvedRun = run;
                    }
                    if (bestSolvedRun != null && !bestSolvedRun.equals(bestRun)) {
                        PortfolioTargetAlgorithmEvaluatorDecorator.this.log.error("Best solved run {} doesn't equal best run {} in responses: {} ", new Object[]{bestSolvedRun, bestRun, runs});
                        throw new IllegalStateException("Values that are killed or timeout are better than those that are solved");
                    }
                }
                PortfolioTargetAlgorithmEvaluatorDecorator.this.log.trace("Best run is {} out of {}", (Object)bestRun, runs);
                String additionalRunData = bestRun.getAdditionalRunData().isEmpty() ? "Returned from from portfolio, configuration: " + bestRun.getAlgorithmRunConfiguration().getParameterConfiguration().getFriendlyID() + " my performance: " : bestRun.getAdditionalRunData();
                return new ExistingAlgorithmRunResult(originalRunConfig, bestRun.getRunStatus(), bestRun.getRuntime(), bestRun.getRunLength(), bestRun.getQuality(), bestRun.getResultSeed(), additionalRunData, bestRun.getWallclockExecutionTime());
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.fHandler.onFailure(t);
            }
        };
    }

    private TargetAlgorithmEvaluatorRunObserver getPortfolioObserver(final TargetAlgorithmEvaluatorRunObserver aOriginalObserver, final List<AlgorithmRunConfiguration> aOriginalRunConfigs, final int aPortfolioRunsPerOriginalRun) {
        return new TargetAlgorithmEvaluatorRunObserver(){
            Set<AlgorithmRunResult> killedRuns = Collections.newSetFromMap(new ConcurrentHashMap());

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (runs.size() != aOriginalRunConfigs.size() * aPortfolioRunsPerOriginalRun) {
                    throw new IllegalArgumentException("Provided " + runs.size() + " runs, not all the " + aOriginalRunConfigs.size() + "*" + aPortfolioRunsPerOriginalRun + " (=" + aOriginalRunConfigs.size() * aPortfolioRunsPerOriginalRun + ") portfolio runs submitted (from " + aOriginalRunConfigs.size() + " original runs).");
                }
                ArrayList<AlgorithmRunResult> kRunsToClient = new ArrayList<AlgorithmRunResult>();
                for (int i = 0; i < aOriginalRunConfigs.size(); ++i) {
                    kRunsToClient.add(this.getAlgorithmRunForPortfolioObserver((AlgorithmRunConfiguration)aOriginalRunConfigs.get(i), runs.subList(i * aPortfolioRunsPerOriginalRun, (i + 1) * aPortfolioRunsPerOriginalRun)));
                }
                if (aOriginalObserver != null) {
                    aOriginalObserver.currentStatus(kRunsToClient);
                }
            }

            private AlgorithmRunResult getAlgorithmRunForPortfolioObserver(AlgorithmRunConfiguration originalRunConfig, final List<? extends AlgorithmRunResult> runs) {
                boolean atleastOneRunStillRunning = false;
                AlgorithmRunResult bestSolvedRun = null;
                AlgorithmRunResult bestRun = runs.get(0);
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    if (algorithmRunResult.isRunCompleted()) {
                        if (bestSolvedRun == null || PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective(algorithmRunResult) < PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective(bestSolvedRun)) {
                            bestSolvedRun = algorithmRunResult;
                        }
                    } else {
                        atleastOneRunStillRunning = true;
                    }
                    if (!(PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective(algorithmRunResult) < PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj.getObjective(bestRun))) continue;
                    bestRun = algorithmRunResult;
                }
                if (bestSolvedRun != null) {
                    for (AlgorithmRunResult algorithmRunResult : runs) {
                        if (!algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING) || !PortfolioTargetAlgorithmEvaluatorDecorator.this.fPortfolioRunKillingPolicy.killRun(algorithmRunResult, bestSolvedRun, PortfolioTargetAlgorithmEvaluatorDecorator.this.fRunObj)) continue;
                        if (this.killedRuns.add(algorithmRunResult)) {
                            PortfolioTargetAlgorithmEvaluatorDecorator.this.log.trace("Run {} seems to be dominated by run {}, killing...", (Object)algorithmRunResult, (Object)bestSolvedRun);
                        }
                        algorithmRunResult.kill();
                    }
                }
                if (atleastOneRunStillRunning) {
                    KillHandler kh = new KillHandler(){
                        AtomicBoolean bKill = new AtomicBoolean(false);

                        @Override
                        public void kill() {
                            this.bKill.getAndSet(true);
                            for (AlgorithmRunResult run : runs) {
                                run.kill();
                            }
                        }

                        @Override
                        public boolean isKilled() {
                            return this.bKill.get();
                        }
                    };
                    return new RunningAlgorithmRunResult(originalRunConfig, bestRun.getRuntime(), bestRun.getRunLength(), bestRun.getQuality(), bestRun.getResultSeed(), bestRun.getWallclockExecutionTime(), kh);
                }
                return new ExistingAlgorithmRunResult(originalRunConfig, bestRun.getRunStatus(), bestRun.getRuntime(), bestRun.getRunLength(), bestRun.getQuality(), bestRun.getResultSeed(), bestRun.getWallclockExecutionTime());
            }
        };
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

