/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.functionality;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.StatusVariableKillHandler;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SimulatedDelayTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final long observerFrequencyMs;
    private final ExecutorService execService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("Simulated Delay Target Algorithm Evaluator Callback Thread"));
    private static final Logger log = LoggerFactory.getLogger(SimulatedDelayTargetAlgorithmEvaluatorDecorator.class);
    private final AtomicInteger threadsWaiting = new AtomicInteger(0);
    private double timeScalingFactor;

    public SimulatedDelayTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, long observerFrequencyMs, double scalingFactor) {
        super(tae);
        this.observerFrequencyMs = observerFrequencyMs;
        this.timeScalingFactor = scalingFactor;
        if (observerFrequencyMs <= 0L) {
            throw new IllegalArgumentException("Observer Frequency cannot be zero");
        }
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.evaluateRunConfigs(runConfigs, obs);
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, final TargetAlgorithmEvaluatorRunObserver obs) {
        this.execService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.onSuccess(SimulatedDelayTargetAlgorithmEvaluatorDecorator.this.evaluateRunConfigs(runConfigs, obs));
                }
                catch (RuntimeException e) {
                    handler.onFailure(e);
                }
            }
        });
    }

    @Override
    public boolean areRunsObservable() {
        return true;
    }

    @Override
    public boolean areRunsPersisted() {
        return false;
    }

    @Override
    public void postDecorateeNotifyShutdown() {
        this.execService.shutdown();
        try {
            this.execService.awaitTermination(24L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AlgorithmRunResult> evaluateRunConfigs(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        try {
            this.threadsWaiting.incrementAndGet();
            TimeSimulator timeSim = new TimeSimulator(this.timeScalingFactor);
            long startTimeInMS = System.currentTimeMillis();
            HashSet<String> configIDs = new HashSet<String>();
            for (AlgorithmRunConfiguration rc : runConfigs) {
                configIDs.add(rc.getParameterConfiguration().getFriendlyIDHex());
            }
            log.trace("Scheduling runs synchronously for configs {}", configIDs);
            List<AlgorithmRunResult> runsFromWrappedTAE = Collections.unmodifiableList(this.tae.evaluateRun(runConfigs, null));
            double timeToSleep = Double.NEGATIVE_INFINITY;
            LinkedHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> runConfigToAlgorithmRunMap = new LinkedHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
            LinkedHashMap<AlgorithmRunConfiguration, KillHandler> runConfigToKillHandlerMap = new LinkedHashMap<AlgorithmRunConfiguration, KillHandler>();
            AlgorithmRunResult mostExpensiveRun = null;
            Iterator<AlgorithmRunResult> iterator = runsFromWrappedTAE.iterator();
            while (iterator.hasNext()) {
                double oldTimeToSleep = timeToSleep;
                AlgorithmRunResult run = iterator.next();
                if (oldTimeToSleep != (timeToSleep = Math.max(timeToSleep, Math.max(run.getRuntime(), run.getWallclockExecutionTime())))) {
                    mostExpensiveRun = run;
                }
                runConfigToKillHandlerMap.put(run.getAlgorithmRunConfiguration(), new StatusVariableKillHandler());
                runConfigToAlgorithmRunMap.put(run.getAlgorithmRunConfiguration(), new RunningAlgorithmRunResult(run.getAlgorithmRunConfiguration(), 0.0, 0.0, 0.0, run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getSeed(), 0.0, null));
            }
            double oRigTimeToSleep = timeToSleep;
            Object[] args = new Object[]{oRigTimeToSleep, this.timeScalingFactor, timeToSleep /= this.timeScalingFactor, configIDs, this.getNicelyFormattedWakeUpTime(timeToSleep), this.threadsWaiting.get()};
            log.trace("Simulating {} elapsed with time scaling factor {} for a total of {} seconds of running for configs ({}) . Wake-up estimated in/at: {}  ( ~({}) threads currently waiting )", args);
            this.sleepAndNotifyObservers(timeSim, startTimeInMS, oRigTimeToSleep, obs, runsFromWrappedTAE, runConfigs, runConfigToKillHandlerMap, runConfigToAlgorithmRunMap);
            if (obs == null) {
                List<AlgorithmRunResult> list = runsFromWrappedTAE;
                return list;
            }
            ArrayList<AlgorithmRunResult> completedRuns = new ArrayList<AlgorithmRunResult>(runsFromWrappedTAE.size());
            for (AlgorithmRunResult run : runsFromWrappedTAE) {
                AlgorithmRunResult newRun = runConfigToAlgorithmRunMap.get(run.getAlgorithmRunConfiguration());
                if (!newRun.isRunCompleted()) {
                    log.error("Expected all runs to be returned would be done by now, however this run isn't {}.  ", (Object)newRun);
                    for (AlgorithmRunResult runFromTAE : runsFromWrappedTAE) {
                        log.error("Response from TAE was this run {}", (Object)runFromTAE);
                    }
                    throw new IllegalStateException("Expected that all runs would be completed by now, but not all are");
                }
                if (newRun.equals(mostExpensiveRun)) {
                    newRun = new ExistingAlgorithmRunResult(newRun.getAlgorithmRunConfiguration(), newRun.getRunStatus(), newRun.getRuntime(), newRun.getRunLength(), newRun.getQuality(), newRun.getResultSeed(), newRun.getAdditionalRunData(), timeToSleep);
                }
                completedRuns.add(newRun);
            }
            ArrayList<AlgorithmRunResult> arrayList = completedRuns;
            return arrayList;
        }
        finally {
            this.threadsWaiting.decrementAndGet();
        }
    }

    private void sleepAndNotifyObservers(TimeSimulator timeSimulator, long startTimeInMs, double maxRuntime, TargetAlgorithmEvaluatorRunObserver observer, List<AlgorithmRunResult> runsFromWrappedTAE, List<AlgorithmRunConfiguration> runConfigs, LinkedHashMap<AlgorithmRunConfiguration, KillHandler> khs, LinkedHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> runResults) {
        long sleepTimeInMS = (long)maxRuntime * 1000L;
        while (true) {
            long waitTimeRemainingMs;
            long currentTimeInMs = timeSimulator.time();
            if (observer != null) {
                this.updateRunsAndNotifyObserver(startTimeInMs, currentTimeInMs, maxRuntime, observer, runsFromWrappedTAE, runConfigs, khs, runResults);
            }
            if ((waitTimeRemainingMs = startTimeInMs - (currentTimeInMs = timeSimulator.time()) + sleepTimeInMS) <= 0L) break;
            long sleepTime = Math.min(this.observerFrequencyMs, waitTimeRemainingMs);
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TargetAlgorithmAbortException(e);
            }
        }
        long simulatedCurrentTimeInMs = Long.MAX_VALUE;
        this.updateRunsAndNotifyObserver(startTimeInMs, simulatedCurrentTimeInMs, maxRuntime, observer, runsFromWrappedTAE, runConfigs, khs, runResults);
    }

    private void updateRunsAndNotifyObserver(long startTimeInMs, long currentTimeInMs, double maxRuntime, TargetAlgorithmEvaluatorRunObserver observer, List<AlgorithmRunResult> runsFromWrappedTAE, List<AlgorithmRunConfiguration> runConfigs, LinkedHashMap<AlgorithmRunConfiguration, KillHandler> killHandlers, LinkedHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> runConfigToAlgorithmRunMap) {
        ArrayList<AlgorithmRunResult> kars = new ArrayList<AlgorithmRunResult>(runsFromWrappedTAE.size());
        for (AlgorithmRunResult run : runsFromWrappedTAE) {
            AlgorithmRunConfiguration rc = run.getAlgorithmRunConfiguration();
            double currentRuntime = (double)(currentTimeInMs - startTimeInMs) / 1000.0;
            if (!runConfigToAlgorithmRunMap.get(rc).isRunCompleted()) {
                if (currentRuntime >= run.getRuntime()) {
                    runConfigToAlgorithmRunMap.put(rc, run);
                } else if (killHandlers.get(rc).isKilled()) {
                    runConfigToAlgorithmRunMap.put(rc, new ExistingAlgorithmRunResult(rc, RunStatus.KILLED, currentRuntime, 0.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), currentRuntime));
                } else {
                    runConfigToAlgorithmRunMap.put(rc, new RunningAlgorithmRunResult(run.getAlgorithmRunConfiguration(), currentRuntime, 0.0, 0.0, run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getSeed(), currentRuntime, killHandlers.get(rc)));
                }
            }
            AlgorithmRunResult currentRun = runConfigToAlgorithmRunMap.get(rc);
            kars.add(currentRun);
        }
        if (observer != null) {
            observer.currentStatus(kars);
        }
    }

    private String getNicelyFormattedWakeUpTime(double timeToSleep) {
        long time = System.currentTimeMillis() + (long)(timeToSleep * 1000.0);
        Date d = new Date(time);
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        String releaseTime = df.format(d);
        if (timeToSleep * 1000.0 > 8.64E7) {
            releaseTime = timeToSleep * 1000.0 / 8.64E7 + " days " + releaseTime;
        }
        return releaseTime;
    }

    private static class TimeSimulator {
        private long initialTime = System.currentTimeMillis();
        private double scale;

        public TimeSimulator(double scale) {
            this.scale = scale;
        }

        public long time() {
            return (long)((double)this.initialTime + (double)(System.currentTimeMillis() - this.initialTime) * this.scale);
        }
    }
}

