/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.StatusVariableKillHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PartialResultsAggregator {
    private final List<AlgorithmRunConfiguration> runConfigurations;
    private final Set<AlgorithmRunConfiguration> outstandingRunConfigurationSet;
    private final ConcurrentMap<AlgorithmRunConfiguration, AlgorithmRunResult> observerRunStatus = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
    private final ConcurrentMap<AlgorithmRunConfiguration, AlgorithmRunResult> completedRunsMap = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
    private final ConcurrentMap<AlgorithmRunConfiguration, KillHandler> nonAuthorativekillHandlerMap = new ConcurrentHashMap<AlgorithmRunConfiguration, KillHandler>();

    public PartialResultsAggregator(List<AlgorithmRunConfiguration> initalRunConfigurations) {
        this.runConfigurations = Collections.unmodifiableList(new ArrayList<AlgorithmRunConfiguration>(initalRunConfigurations));
        this.outstandingRunConfigurationSet = new HashSet<AlgorithmRunConfiguration>(this.runConfigurations);
        if (this.runConfigurations.size() != this.outstandingRunConfigurationSet.size()) {
            HashSet<AlgorithmRunConfiguration> rcs = new HashSet<AlgorithmRunConfiguration>();
            HashSet<AlgorithmRunConfiguration> duplicates = new HashSet<AlgorithmRunConfiguration>();
            for (AlgorithmRunConfiguration rc : this.runConfigurations) {
                if (rcs.contains(rc)) {
                    duplicates.add(rc);
                }
                rcs.add(rc);
            }
            throw new IllegalArgumentException("Duplicate run configuration detected: " + duplicates);
        }
        for (AlgorithmRunConfiguration rc : this.runConfigurations) {
            StatusVariableKillHandler kh = new StatusVariableKillHandler();
            this.nonAuthorativekillHandlerMap.put(rc, kh);
            this.observerRunStatus.put(rc, new RunningAlgorithmRunResult(rc, 0.0, 0.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), 0.0, kh));
        }
    }

    public synchronized Set<AlgorithmRunConfiguration> getOutstandingRunConfigurations() {
        return Collections.unmodifiableSet(this.outstandingRunConfigurationSet);
    }

    public synchronized boolean isCompleted() {
        return this.outstandingRunConfigurationSet.isEmpty();
    }

    public synchronized List<AlgorithmRunResult> getCurrentRunStatusForObserver() {
        ArrayList<AlgorithmRunResult> results = new ArrayList<AlgorithmRunResult>();
        for (AlgorithmRunConfiguration rc : this.runConfigurations) {
            results.add((AlgorithmRunResult)this.observerRunStatus.get(rc));
        }
        return results;
    }

    public synchronized List<AlgorithmRunResult> getCurrentRunStatusOnCompletion() {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Runs are not completed yet");
        }
        ArrayList<AlgorithmRunResult> results = new ArrayList<AlgorithmRunResult>();
        for (AlgorithmRunConfiguration rc : this.runConfigurations) {
            results.add((AlgorithmRunResult)this.completedRunsMap.get(rc));
        }
        return results;
    }

    public synchronized boolean updateCurrentRunStatus(AlgorithmRunResult result) {
        return this._updateMap(result, this.observerRunStatus);
    }

    public synchronized boolean updateCurrentRunStatus(Collection<? extends AlgorithmRunResult> results) {
        return this._updateMap(results, this.observerRunStatus);
    }

    public synchronized boolean updateCompletedRun(AlgorithmRunResult result) {
        this.outstandingRunConfigurationSet.remove(result.getAlgorithmRunConfiguration());
        return this._updateMap(result, this.completedRunsMap);
    }

    public synchronized boolean updateCompletedRuns(Collection<? extends AlgorithmRunResult> results) {
        for (AlgorithmRunResult algorithmRunResult : results) {
            this.outstandingRunConfigurationSet.remove(algorithmRunResult.getAlgorithmRunConfiguration());
        }
        return this._updateMap(results, this.completedRunsMap);
    }

    private synchronized boolean _updateMap(AlgorithmRunResult result, Map<AlgorithmRunConfiguration, AlgorithmRunResult> map) {
        if (this.observerRunStatus.containsKey(result.getAlgorithmRunConfiguration())) {
            if (((KillHandler)this.nonAuthorativekillHandlerMap.get(result.getAlgorithmRunConfiguration())).isKilled() && !result.isRunCompleted()) {
                result.kill();
            }
        } else {
            throw new IllegalStateException("Attempted to add a run that we didn't request:" + result + " requests: " + this.runConfigurations);
        }
        map.put(result.getAlgorithmRunConfiguration(), result);
        return this.isCompleted();
    }

    private synchronized boolean _updateMap(Collection<? extends AlgorithmRunResult> results, Map<AlgorithmRunConfiguration, AlgorithmRunResult> map) {
        for (AlgorithmRunResult algorithmRunResult : results) {
            if (this.observerRunStatus.containsKey(algorithmRunResult.getAlgorithmRunConfiguration())) {
                if (((KillHandler)this.nonAuthorativekillHandlerMap.get(algorithmRunResult.getAlgorithmRunConfiguration())).isKilled() && !algorithmRunResult.isRunCompleted()) {
                    algorithmRunResult.kill();
                }
                map.put(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult);
                continue;
            }
            throw new IllegalStateException("Attempted to add a run that we didn't request:" + algorithmRunResult + " requests: " + this.runConfigurations);
        }
        return this.isCompleted();
    }
}

