/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator;

import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class SetInstanceSeedGenerator
implements InstanceSeedGenerator {
    private static final long serialVersionUID = 8634557199869232040L;
    private final LinkedHashMap<String, List<Long>> instances;
    private final Map<String, Integer> piKeyToIntMap = new HashMap<String, Integer>();
    private final List<Queue<Long>> seeds;
    private final List<String> instanceOrder;
    private final int initialSeedCount;
    private final boolean allInstanceHaveSameNumberOfSeeds;
    private final Map<Integer, Set<Long>> blacklistedSeeds = new HashMap<Integer, Set<Long>>();

    public SetInstanceSeedGenerator(LinkedHashMap<String, List<Long>> instances, List<String> instanceOrder, int maxSeedsPerConfig) {
        if (maxSeedsPerConfig < 0) {
            maxSeedsPerConfig = Integer.MAX_VALUE;
        }
        this.instances = instances;
        this.instanceOrder = instanceOrder;
        this.seeds = new ArrayList<Queue<Long>>(instances.size());
        int i = 0;
        int seedSum = 0;
        int lastSeedCount = -1;
        boolean allInstancesHaveSameNumberOfSeeds = true;
        for (Map.Entry<String, List<Long>> ent : instances.entrySet()) {
            this.piKeyToIntMap.put(ent.getKey(), i++);
            if (ent.getValue().size() > maxSeedsPerConfig) {
                ent.setValue(ent.getValue().subList(0, maxSeedsPerConfig));
            }
            seedSum += ent.getValue().size();
            if (lastSeedCount != -1) {
                if (!allInstancesHaveSameNumberOfSeeds) continue;
                allInstancesHaveSameNumberOfSeeds = lastSeedCount == ent.getValue().size();
                continue;
            }
            lastSeedCount = ent.getValue().size();
        }
        this.initialSeedCount = seedSum;
        this.allInstanceHaveSameNumberOfSeeds = allInstancesHaveSameNumberOfSeeds;
        this.reinit();
    }

    @Override
    public void reinit() {
        this.seeds.clear();
        for (Map.Entry<String, List<Long>> ent : this.instances.entrySet()) {
            this.seeds.add(new LinkedList(ent.getValue()));
        }
    }

    @Override
    public int getNextSeed(ProblemInstance pi) {
        if (this.hasNextSeed(pi)) {
            return (int)this.seeds.get(this.piKeyToIntMap.get(pi.getInstanceName())).poll().longValue();
        }
        throw new IllegalStateException("No more Seeds for Problem Instance: " + pi.getInstanceName());
    }

    @Override
    public boolean hasNextSeed(ProblemInstance pi) {
        if (this.blacklistedSeeds.get(pi.getInstanceID()) == null) {
            this.blacklistedSeeds.put(pi.getInstanceID(), new HashSet());
        }
        Collection blackListedSeeds = this.blacklistedSeeds.get(pi.getInstanceID());
        this.seeds.get(this.piKeyToIntMap.get(pi.getInstanceName())).removeAll(blackListedSeeds);
        return !this.seeds.get(this.piKeyToIntMap.get(pi.getInstanceName())).isEmpty();
    }

    @Override
    public List<ProblemInstance> getProblemInstanceOrder(Collection<ProblemInstance> c) {
        HashMap<String, ProblemInstance> instanceMap = new HashMap<String, ProblemInstance>();
        for (ProblemInstance pi : c) {
            instanceMap.put(pi.getInstanceName(), pi);
        }
        ArrayList<ProblemInstance> piOrder = new ArrayList<ProblemInstance>(this.instanceOrder.size());
        for (String instance : this.instanceOrder) {
            ProblemInstance pi = (ProblemInstance)instanceMap.get(instance);
            if (pi == null) {
                pi = (ProblemInstance)instanceMap.get(instance.replaceAll("//", "/"));
            }
            if (pi == null) {
                throw new IllegalStateException("Couldn't find instance that matches : " + instance);
            }
            piOrder.add(pi);
        }
        return piOrder;
    }

    @Override
    public int getInitialInstanceSeedCount() {
        return this.initialSeedCount;
    }

    @Override
    public boolean allInstancesHaveSameNumberOfSeeds() {
        return this.allInstanceHaveSameNumberOfSeeds;
    }

    @Override
    public void take(ProblemInstance instance, long seed) {
        if (this.blacklistedSeeds.get(instance.getInstanceID()) == null) {
            this.blacklistedSeeds.put(instance.getInstanceID(), new HashSet());
        }
        this.blacklistedSeeds.get(instance.getInstanceID()).add(seed);
    }
}

