/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TopologicalSorter {
    public static Set<Constraint<String>> getNumericConstraints(Collection<String> values) {
        TreeMap<Double, String> constraintKeys = new TreeMap<Double, String>();
        for (String s : values) {
            try {
                Double d = Double.valueOf(s);
                constraintKeys.put(d, s);
            }
            catch (RuntimeException e) {}
        }
        ArrayList sortedEntries = new ArrayList();
        sortedEntries.addAll(constraintKeys.entrySet());
        HashSet<Constraint<String>> results = new HashSet<Constraint<String>>();
        for (int i = 1; i < sortedEntries.size(); ++i) {
            results.add(new Constraint(((Map.Entry)sortedEntries.get(i - 1)).getValue(), ((Map.Entry)sortedEntries.get(i)).getValue()));
        }
        return results;
    }

    public static List<String> getTopologicalOrder(Collection<String> values, Collection<Constraint<String>> constraints) throws NoTopologicalOrderAvailableException {
        ArrayList<String> outputValues = new ArrayList<String>(values.size());
        ArrayList<String> inputValues = new ArrayList<String>(new TreeSet<String>(values));
        ArrayList<Constraint<String>> constraintValues = new ArrayList<Constraint<String>>(constraints);
        constraintValues.addAll(TopologicalSorter.getNumericConstraints(values));
        block0: for (int i = 0; i < inputValues.size(); ++i) {
            Constraint constraint;
            int j;
            String value = (String)inputValues.get(i);
            for (j = 0; j < constraintValues.size(); ++j) {
                constraint = (Constraint)constraintValues.get(j);
                if (((String)constraint.getGreater()).equals(value)) continue block0;
            }
            inputValues.remove(i);
            i = -1;
            outputValues.add(value);
            for (j = 0; j < constraintValues.size(); ++j) {
                constraint = (Constraint)constraintValues.get(j);
                if (!((String)constraint.getLesser()).equals(value)) continue;
                constraintValues.remove(j);
                --j;
            }
        }
        if (inputValues.size() > 0) {
            throw new NoTopologicalOrderAvailableException("Couldn't sort topological order the following values may be involved in a cycle " + inputValues);
        }
        return outputValues;
    }

    public static void main(String[] args) throws NoTopologicalOrderAvailableException {
        String[] values = new String[]{"a", "1", "2", "b", "c", "3", "3.5", "5", "4", "INFINITY", "NEGATIVE_INFINITY", "z", "b2"};
        Constraint[] constraints = new Constraint[]{new Constraint<String>("b", "3"), new Constraint<String>("5", "INFINITY"), new Constraint<String>("1", "b"), new Constraint<String>("2", "c"), new Constraint<String>("b", "2"), new Constraint<String>("z", "a"), new Constraint<String>("a", "NEGATIVE_INFINITY"), new Constraint<String>("NEGATIVE_INFINITY", "1")};
        System.out.println(TopologicalSorter.getTopologicalOrder(Arrays.asList(values), Arrays.asList(constraints)));
        values = new String[]{"Z", "a", "1", "2", "b", "c", "3", "3.5", "5", "4", "INFINITY", "NEGATIVE_INFINITY", "z", "b2"};
        constraints = new Constraint[]{new Constraint<String>("z", "INFINITY")};
        List<String> valuesList = Arrays.asList(values);
        Collections.shuffle(valuesList);
        System.out.println(TopologicalSorter.getTopologicalOrder(valuesList, Arrays.asList(constraints)));
    }

    public static class NoTopologicalOrderAvailableException
    extends Exception {
        public NoTopologicalOrderAvailableException(String string) {
            super(string);
        }
    }

    public static class Constraint<A> {
        private A less;
        private A greater;

        public Constraint(A a, A b) {
            this.less = a;
            this.greater = b;
            if (a.equals(b)) {
                throw new IllegalArgumentException("Contraint specified the same value " + a + " == " + b);
            }
        }

        public A getLesser() {
            return this.less;
        }

        public A getGreater() {
            return this.greater;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.greater == null ? 0 : this.greater.hashCode());
            result = 31 * result + (this.less == null ? 0 : this.less.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Constraint other = (Constraint)obj;
            if (this.greater == null ? other.greater != null : !this.greater.equals(other.greater)) {
                return false;
            }
            return !(this.less == null ? other.less != null : !this.less.equals(other.less));
        }
    }
}

