/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace;

import ca.ubc.cs.beta.aeatk.json.JSONConverter;
import ca.ubc.cs.beta.aeatk.json.serializers.ParameterConfigurationSpaceJson;
import ca.ubc.cs.beta.aeatk.misc.java.io.FileReaderNoException.FileReaderNoExceptionThrown;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ConditionalOperator;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ForbiddenOperators;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.NormalizedRange;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationStringFormatException;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationStringMissingParameterException;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.util.TopologicalSorter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import ec.util.MersenneTwisterFast;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

@Immutable
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@JsonSerialize(using=ParameterConfigurationSpaceJson.ParamConfigurationSpaceSerializer.class)
@JsonDeserialize(using=ParameterConfigurationSpaceJson.ParamConfigurationSpaceDeserializer.class)
public class ParameterConfigurationSpace
implements Serializable {
    private static final long serialVersionUID = -11111155215218L;
    private final Map<String, List<String>> values;
    private final Map<String, String> defaultValues;
    private final Map<String, ParameterType> paramTypes;
    private final Map<String, Map<String, Integer>> categoricalValueMap;
    private final String absoluteFileName;
    private final Map<String, NormalizedRange> contNormalizedRanges;
    private final Map<String, Integer> paramKeyIndexMap;
    private final boolean[] parameterDomainContinuous;
    private final int[] categoricalSize;
    private final List<double[][]> forbiddenParameterValuesList;
    public static final int INVALID_CATEGORICAL_SIZE = 0;
    private int numberOfParameters;
    private boolean hasRealParameterFile;
    private final List<String> forbiddenLines;
    private final List<String> conditionalLines;
    private final double[] defaultConfigurationValueArray;
    final double[] searchSubspaceValues;
    final boolean[] searchSubspaceActive;
    private List<String> authorativeParameterNameOrder;
    private Set<String> sortedParameterNames;
    private final String[] authorativeParameterOrderArray;
    private final NormalizedRange[] normalizedRangesByIndex;
    private Map<Integer, ArrayList<ArrayList<Conditional>>> nameConditionsMap;
    private Map<String, HashSet<String>> parameterDependencies;
    private List<Integer> activeCheckOrder;
    private List<String> activeCheckOrderString;
    private Map<Integer, int[][]> nameConditionsMapParentsArray;
    private Map<Integer, double[][][]> nameConditionsMapParentsValues;
    private Map<Integer, int[][]> nameConditionsMapOp;
    private final String pcsFile;
    private final Pattern catOrdPattern;
    private final Pattern intReaPattern;
    private final Map<String, String> searchSubspace;
    final List<ExpressionBuilder> bl;
    final Map<ExpressionBuilder, String> expressions;
    final ThreadLocal<List<Expression>> tlExpressions;
    private static final Pattern allowedParameterValuesRegex = Pattern.compile("^\\p{Graph}+$");
    private final Pattern classicForbidden;
    private final Pattern generalForbidden;
    protected Map<String, Double> forbiddenParameterConstants;
    protected Map<String, Double> forbiddenOrdinalAndCategoricalVariableValues;
    Pattern oldCategoricalFormatMatcher;
    Pattern oldContinuousFormatMatcher;
    public static final String SINGLETON_ABSOLUTE_NAME = "<--[SINGLETON SPACE]-->";
    public static final String NULL_ABSOLUTE_NAME = "<--[NULL SPACE]-->";
    private final boolean newForbiddenLinesPresent;

    public Map<String, Integer> getParamKeyIndexMap() {
        return Collections.unmodifiableMap(this.paramKeyIndexMap);
    }

    public Map<Integer, int[][]> getNameConditionsMapParentsArray() {
        return this.nameConditionsMapParentsArray;
    }

    public Map<Integer, double[][][]> getNameConditionsMapParentsValues() {
        return this.nameConditionsMapParentsValues;
    }

    public Map<Integer, int[][]> getNameConditionsMapOp() {
        return this.nameConditionsMapOp;
    }

    protected List<String> getActiveCheckOrderString() {
        return Collections.unmodifiableList(this.activeCheckOrderString);
    }

    protected Map<Integer, ArrayList<ArrayList<Conditional>>> getNameConditionsMap() {
        return Collections.unmodifiableMap(this.nameConditionsMap);
    }

    public Map<String, ParameterType> getParameterTypes() {
        return Collections.unmodifiableMap(this.paramTypes);
    }

    public ParameterConfigurationSpace(String filename) {
        this(new File(filename));
    }

    public ParameterConfigurationSpace(Reader reader, Map<String, String> searchSubspace) {
        this(reader, "ReaderOnly-" + System.currentTimeMillis() + "-" + (int)(Math.random() * 1.0E7), searchSubspace);
        this.hasRealParameterFile = false;
    }

    public ParameterConfigurationSpace(Reader reader) {
        this(reader, "ReaderOnly-" + System.currentTimeMillis() + "-" + (int)(Math.random() * 1.0E7));
        this.hasRealParameterFile = false;
    }

    public ParameterConfigurationSpace(File file) {
        this((Reader)new FileReaderNoExceptionThrown(file), file.getAbsolutePath());
    }

    public ParameterConfigurationSpace(Reader file, String absoluteFileName) {
        this(file, absoluteFileName, Collections.EMPTY_MAP);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParameterConfigurationSpace(Reader file, String absoluteFileName, Map<String, String> searchSubspace) {
        block27: {
            block26: {
                super();
                this.values = new HashMap<String, List<String>>();
                this.defaultValues = new HashMap<String, String>();
                this.paramTypes = new HashMap<String, ParameterType>();
                this.categoricalValueMap = new HashMap<String, Map<String, Integer>>();
                this.contNormalizedRanges = new HashMap<String, NormalizedRange>();
                this.paramKeyIndexMap = new LinkedHashMap<String, Integer>();
                this.forbiddenParameterValuesList = new ArrayList<double[][]>();
                this.hasRealParameterFile = true;
                this.forbiddenLines = new ArrayList<String>();
                this.conditionalLines = new ArrayList<String>();
                this.authorativeParameterNameOrder = new ArrayList<String>();
                this.sortedParameterNames = new TreeSet<String>();
                this.nameConditionsMap = new HashMap<Integer, ArrayList<ArrayList<Conditional>>>();
                this.parameterDependencies = new HashMap<String, HashSet<String>>();
                this.activeCheckOrder = new ArrayList<Integer>();
                this.activeCheckOrderString = new ArrayList<String>();
                this.catOrdPattern = Pattern.compile("^\\s*(?<name>\\p{Graph}+)\\s*(?<type>[co])\\s*\\{(?<values>.*)\\}\\s*\\[(?<default>\\p{Graph}+)\\]\\s*$");
                this.intReaPattern = Pattern.compile("^\\s*(?<name>\\p{Graph}+)\\s*(?<type>[ir])\\s*\\[\\s*(?<min>\\p{Graph}+)\\s*,\\s*(?<max>\\p{Graph}+)\\s*\\]\\s*\\[(?<default>\\p{Graph}+)\\]\\s*(?<log>(log)?)\\s*$");
                this.bl = new ArrayList<ExpressionBuilder>();
                this.expressions = new IdentityHashMap<ExpressionBuilder, String>();
                this.tlExpressions = new ThreadLocal<T>();
                this.classicForbidden = Pattern.compile("^\\s*\\{((\\s*\\S+\\s*=\\s*\\S+\\s*,?\\s*)+)\\}\\s*$");
                this.generalForbidden = Pattern.compile("^\\s*\\{\\s*([^\\{\\}]+)\\s*\\}\\s*$");
                this.oldCategoricalFormatMatcher = Pattern.compile("^\\s*(\\S+)\\s*\\{(.+)\\}\\s*\\[\\s*(\\S+)\\s*\\]\\s*$");
                this.oldContinuousFormatMatcher = Pattern.compile("^\\s*(\\S+)\\s*\\[(.+)\\]\\s*\\[\\s*(\\S+)\\s*]\\s*([il]*[il]*)\\s*$");
                this.absoluteFileName = absoluteFileName;
                if (absoluteFileName == null || absoluteFileName.trim().length() == 0) {
                    throw new IllegalArgumentException("Absolute File Name must be non-empty:" + absoluteFileName);
                }
                try {
                    pcs = new StringBuilder();
                    inputData = new BufferedReader(file);
                    var6_9 = null;
                    ** try [egrp 1[TRYBLOCK] [2, 3 : 329->384)] { 
lbl35:
                    // 1 sources

                    break block26;
lbl36:
                    // 1 sources

                    catch (Throwable line) {
                        var6_9 = line;
                        throw line;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            while ((line = inputData.readLine()) != null) {
                pcs.append(line + "\n");
                this.parseAClibLine(this.transformOldFormat(line));
            }
            break block27;
lbl53:
            // 1 sources

            finally {
                if (inputData != null) {
                    if (var6_9 != null) {
                        try {
                            inputData.close();
                        }
                        catch (Throwable line) {
                            var6_9.addSuppressed(line);
                        }
                    } else {
                        inputData.close();
                    }
                }
            }
        }
        this.pcsFile = pcs.toString();
        Collections.sort(this.authorativeParameterNameOrder);
        this.numberOfParameters = this.authorativeParameterNameOrder.size();
        for (i = 0; i < this.authorativeParameterNameOrder.size(); ++i) {
            this.paramKeyIndexMap.put(this.authorativeParameterNameOrder.get(i), i);
        }
        this.processConditionalLines();
        this.computeCheckActiveOrder();
        this.transformConditionals2FastRFStructure();
        this.authorativeParameterOrderArray = new String[this.authorativeParameterNameOrder.size()];
        this.normalizedRangesByIndex = new NormalizedRange[this.authorativeParameterNameOrder.size()];
        for (i = 0; i < this.authorativeParameterNameOrder.size(); ++i) {
            this.authorativeParameterOrderArray[i] = this.authorativeParameterNameOrder.get(i);
            this.normalizedRangesByIndex[i] = this.contNormalizedRanges.get(this.authorativeParameterOrderArray[i]);
        }
        this.parameterDomainContinuous = new boolean[this.numberOfParameters];
        this.categoricalSize = new int[this.numberOfParameters];
        i = 0;
        inputData = this.authorativeParameterOrderArray;
        var6_10 = inputData.length;
        for (line = 0; line < var6_10; ++i, ++line) {
            paramName = inputData[line];
            this.parameterDomainContinuous[i] = this.getParameterTypes().get(paramName).isNormalized();
            this.categoricalSize[i] = this.parameterDomainContinuous[i] == false ? this.getValuesMap().get(paramName).size() : 0;
        }
        this.newForbiddenLinesPresent = this.parseForbiddenLines(this.forbiddenLines);
        this.defaultConfigurationValueArray = this._getDefaultConfiguration().toValueArray();
        if (this.getDefaultConfiguration().isForbiddenParameterConfiguration()) {
            throw new IllegalArgumentException("Default parameter setting cannot be a forbidden parameter setting:" + this.getDefaultConfiguration().getFormattedParameterString());
        }
        this.searchSubspaceValues = new double[this.defaultConfigurationValueArray.length];
        this.searchSubspaceActive = new boolean[this.defaultConfigurationValueArray.length];
        searchSubspaceMap = new TreeMap<String, String>();
        var6_11 = searchSubspace.entrySet().iterator();
        while (true) {
            if (!var6_11.hasNext()) {
                this.searchSubspace = Collections.unmodifiableMap(searchSubspaceMap);
                return;
            }
            subspaceProfile = var6_11.next();
            param = subspaceProfile.getKey();
            value = subspaceProfile.getValue();
            if (value.equals("<DEFAULT>")) {
                value = this.getDefaultConfiguration().get(param);
            }
            searchSubspaceMap.put(param, value);
            index = this.paramKeyIndexMap.get(param);
            this.setValueInArray(this.searchSubspaceValues, param, value);
            this.searchSubspaceActive[index] = true;
        }
    }

    private final void processConditionalLines() {
        LinkedHashMap conditionalLinesMap = new LinkedHashMap();
        for (String string : this.conditionalLines) {
            String name = this.getName(string);
            if (conditionalLinesMap.get(name) == null) {
                conditionalLinesMap.put(name, new ArrayList());
            }
            ((List)conditionalLinesMap.get(name)).add(string);
        }
        for (Map.Entry entry : conditionalLinesMap.entrySet()) {
            List conditionalLines = (List)entry.getValue();
            if (conditionalLines.size() == 1) {
                this.parseConditional((String)conditionalLines.get(0));
                continue;
            }
            if (conditionalLines.size() > 1) {
                StringBuilder sb = new StringBuilder((String)entry.getKey());
                sb.append("|");
                Pattern p = Pattern.compile("^\\s*\\S+\\s*\\|\\s*(\\S+)\\s+in\\s+(\\{.+\\})\\s*$");
                for (String line : conditionalLines) {
                    Matcher m = p.matcher(line);
                    if (m.find()) {
                        String name = m.group(1);
                        String values = m.group(2);
                        sb.append(" ").append(name).append(" in ").append(values).append(" &&");
                        continue;
                    }
                    throw new IllegalArgumentException("Duplicate conditional lines detected: " + conditionalLines + ". Only one conditional line allowed per variable in new format. This line doesn't seem to be of the old format: " + line);
                }
                sb.setLength(sb.length() - 2);
                try {
                    this.parseConditional(sb.toString());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Problem occured during parsing conditionals, new PCS format requires all conditionals to be on the same line. This transformation has been done internally, and afterwards the following error occurred:" + e.getMessage());
                }
            }
            throw new IllegalArgumentException("Duplicate conditional lines detected: " + conditionalLines);
        }
        this.conditionalLines.clear();
    }

    public String getParamFileName() {
        return this.absoluteFileName;
    }

    private void parseAClibLine(String line) {
        int commentStart = (line = line.trim()).indexOf("#");
        if (commentStart >= 0) {
            line = line.substring(0, commentStart).trim();
        }
        if (line.length() == 0) {
            return;
        }
        if (line.trim().equals("Conditionals:")) {
            return;
        }
        if (line.trim().equals("Forbidden:")) {
            return;
        }
        Matcher catOrdMatcher = this.catOrdPattern.matcher(line);
        Matcher intReaMatcher = this.intReaPattern.matcher(line);
        if (catOrdMatcher.find()) {
            String name = catOrdMatcher.group("name");
            String type = catOrdMatcher.group("type");
            List<String> paramValues = Arrays.asList(catOrdMatcher.group("values").split(","));
            String defaultValue = catOrdMatcher.group("default").trim();
            if (this.sortedParameterNames.contains(name)) {
                throw new IllegalArgumentException("Parameter (" + name + ") defined more than once.");
            }
            this.sortedParameterNames.add(name);
            this.authorativeParameterNameOrder.add(name);
            ArrayList<String> paramValues_trimed = new ArrayList<String>();
            HashSet<String> paramValuesSet = new HashSet<String>();
            for (String value : paramValues) {
                if (!allowedParameterValuesRegex.matcher(value.trim()).find()) {
                    throw new IllegalArgumentException("Illegal parameter value detected: `" + value.trim() + "` on line: " + line);
                }
                paramValues_trimed.add(value.trim());
                if (paramValuesSet.add(value.trim())) continue;
                throw new IllegalArgumentException("Duplicate value: " + value.trim() + " detected on line: " + line);
            }
            LinkedHashMap<String, Integer> valueMap = new LinkedHashMap<String, Integer>();
            int i = 0;
            for (String value : paramValues_trimed) {
                valueMap.put(value, i);
                ++i;
            }
            this.categoricalValueMap.put(name, valueMap);
            this.defaultValues.put(name, defaultValue);
            this.values.put(name, paramValues_trimed);
            if (!paramValuesSet.contains(defaultValue)) {
                throw new IllegalArgumentException("Default value " + defaultValue + " is not in the domain of the parameter on line: " + line);
            }
            switch (type) {
                case "c": {
                    this.paramTypes.put(name, ParameterType.CATEGORICAL);
                    break;
                }
                case "o": {
                    boolean intValuesOnly = true;
                    boolean logScale = false;
                    double min = 0.0;
                    double max = paramValuesSet.size() - 1;
                    this.createNumericParameter(line, intValuesOnly, logScale, name, type, min, max, String.valueOf(valueMap.get(defaultValue)));
                    this.paramTypes.put(name, ParameterType.ORDINAL);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Type");
                }
            }
            return;
        }
        if (intReaMatcher.find()) {
            String defaultValue;
            Double max;
            Double min;
            boolean intValuesOnly = false;
            boolean logScale = false;
            String name = intReaMatcher.group("name");
            String type = intReaMatcher.group("type");
            if (this.sortedParameterNames.contains(name)) {
                throw new IllegalArgumentException("Parameter (" + name + ") defined more than once.");
            }
            this.sortedParameterNames.add(name);
            this.authorativeParameterNameOrder.add(name);
            if (type.equals("i")) {
                intValuesOnly = true;
            }
            try {
                min = Double.valueOf(intReaMatcher.group("min"));
                max = Double.valueOf(intReaMatcher.group("max"));
                if (min > max) {
                    throw new IllegalArgumentException("Minimum value " + min + " must be less than the maximum value: " + max + " on line:" + line);
                }
                defaultValue = intReaMatcher.group("default");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("This parameter has to consists of numbers:" + line);
            }
            if (!intReaMatcher.group("log").isEmpty()) {
                logScale = true;
            }
            switch (type) {
                case "i": {
                    this.paramTypes.put(name, ParameterType.INTEGER);
                    break;
                }
                case "r": {
                    this.paramTypes.put(name, ParameterType.REAL);
                    break;
                }
                default: {
                    throw new IllegalStateException("Could not identify the type of the parameter: " + line);
                }
            }
            this.defaultValues.put(name, defaultValue);
            this.values.put(name, Collections.emptyList());
            this.createNumericParameter(line, intValuesOnly, logScale, name, type, min, max, defaultValue);
            return;
        }
        if (this.generalForbidden.matcher(line).find()) {
            this.forbiddenLines.add(line);
            return;
        }
        if (line.indexOf("|") >= 0) {
            this.conditionalLines.add(line);
            return;
        }
        throw new IllegalArgumentException("Not sure how to parse this line: " + line);
    }

    public void createNumericParameter(String line, boolean intValuesOnly, boolean logScale, String name, String type, Double min, Double max, String defaultValue) {
        if (intValuesOnly) {
            try {
                if (!this.isIntegerDouble(min)) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
                if (!this.isIntegerDouble(max)) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
                if (!this.isIntegerDouble(Double.valueOf(defaultValue))) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
                double defDouble = Double.valueOf(defaultValue);
                if (defDouble < min || defDouble > max) {
                    throw new IllegalArgumentException("Default value " + defaultValue + " must fall in the interval [" + min + "," + max + "] on line: " + line);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
            }
        }
        try {
            this.contNormalizedRanges.put(name, new NormalizedRange(min, max, logScale, intValuesOnly));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "; error occured while parsing line: " + line);
        }
    }

    private void parseConditional(String line) {
        String param_name = this.getName(line);
        String conditions = line.substring(line.indexOf("|") + 1);
        String[] disjunctions = conditions.split("\\|\\|");
        ArrayList conditionals = new ArrayList();
        Integer param_id = this.paramKeyIndexMap.get(param_name);
        if (param_id == null) {
            throw new IllegalArgumentException("Conditioned parameter " + param_name + " not defined.");
        }
        if (this.nameConditionsMap.get(param_id) != null) {
            throw new IllegalArgumentException("Each parameter can only be once in the head of a condition:" + param_name + " on line: " + line);
        }
        this.nameConditionsMap.put(param_id, conditionals);
        for (String dis : disjunctions) {
            String[] conjunctions = dis.split("&&");
            ArrayList<Conditional> conj_conds = new ArrayList<Conditional>();
            conditionals.add(conj_conds);
            for (String con : conjunctions) {
                String parent = ConditionalOperator.getParent(con);
                ConditionalOperator op = ConditionalOperator.getOperatorFromConditionalClause(con);
                String[] value = ConditionalOperator.getValues(con);
                if (!this.paramKeyIndexMap.keySet().contains(parent)) {
                    throw new IllegalArgumentException("Unknown dependent parameter: " + parent + ", specified on conditional line: " + line);
                }
                ArrayList<Double> values_mapped = new ArrayList<Double>();
                for (String string : value) {
                    Double vmapped;
                    if (this.paramTypes.get(parent) == ParameterType.CATEGORICAL || this.paramTypes.get(parent) == ParameterType.ORDINAL) {
                        Integer mapped_value = this.categoricalValueMap.get(parent).get(string);
                        if (mapped_value == null) {
                            throw new IllegalArgumentException("Illegal value (" + string + ") specified for parent (" + parent + ") specified on conditional line: " + line);
                        }
                        vmapped = (double)mapped_value;
                    } else {
                        try {
                            vmapped = Double.parseDouble(string);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException(parent + " is a of type i or o but is compared a non-double value in conditionals.");
                        }
                    }
                    values_mapped.add(vmapped);
                }
                int parent_id = this.paramKeyIndexMap.get(parent);
                double[] value_array = new double[values_mapped.size()];
                int i = 0;
                Iterator iterator = values_mapped.iterator();
                while (iterator.hasNext()) {
                    double v3;
                    value_array[i] = v3 = ((Double)iterator.next()).doubleValue();
                    ++i;
                }
                Conditional conditional = new Conditional(parent_id, value_array, op);
                conj_conds.add(conditional);
                if (this.parameterDependencies.get(param_name) == null) {
                    HashSet<String> deps = new HashSet<String>();
                    deps.add(parent);
                    this.parameterDependencies.put(param_name, deps);
                    continue;
                }
                this.parameterDependencies.get(param_name).add(parent);
            }
        }
    }

    private void computeCheckActiveOrder() {
        HashSet<String> params_left = new HashSet<String>(this.authorativeParameterNameOrder);
        boolean changed = true;
        while (!params_left.isEmpty() && changed) {
            changed = false;
            HashSet<String> to_remove = new HashSet<String>();
            for (String p : params_left) {
                boolean ok = true;
                if (this.parameterDependencies.get(p) != null) {
                    for (String d : this.parameterDependencies.get(p)) {
                        if (this.activeCheckOrder.contains(this.paramKeyIndexMap.get(d))) continue;
                        ok = false;
                        break;
                    }
                }
                if (!ok) continue;
                this.activeCheckOrder.add(this.paramKeyIndexMap.get(p));
                this.activeCheckOrderString.add(p);
                to_remove.add(p);
                changed = true;
            }
            params_left.removeAll(to_remove);
        }
        if (!params_left.isEmpty()) {
            throw new IllegalArgumentException("Could not parse hierarchy of parameters. Probably cycles in there. (" + Arrays.toString(params_left.toArray()) + ")");
        }
    }

    private void transformConditionals2FastRFStructure() {
        this.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        this.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        this.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        for (int p_idx : this.nameConditionsMap.keySet()) {
            int[][] parent_id = new int[this.nameConditionsMap.get(p_idx).size()][];
            double[][][] values = new double[this.nameConditionsMap.get(p_idx).size()][][];
            int[][] op = new int[this.nameConditionsMap.get(p_idx).size()][];
            int i = 0;
            for (List list : this.nameConditionsMap.get(p_idx)) {
                int j = 0;
                int[] parent_id_in = new int[list.size()];
                double[][] values_in = new double[list.size()][];
                int[] op_in = new int[list.size()];
                for (Conditional cond : list) {
                    parent_id_in[j] = cond.parent_ID;
                    String parent_name = this.authorativeParameterNameOrder.get(cond.parent_ID);
                    Boolean normalize = this.getParameterTypes().get(parent_name).isNormalized();
                    if (normalize.booleanValue()) {
                        int z = 0;
                        values_in[j] = new double[cond.values.length];
                        double[] dArray = cond.values;
                        int n = dArray.length;
                        for (int k = 0; k < n; ++k) {
                            Double d = dArray[k];
                            try {
                                values_in[j][z] = this.contNormalizedRanges.get(parent_name).normalizeValue(d);
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException("Error parsing conditional statement with variable " + parent_name + " : " + e.getMessage() + ".");
                            }
                            ++z;
                        }
                    } else {
                        values_in[j] = cond.values;
                    }
                    if ((cond.op.equals((Object)ConditionalOperator.LE) || cond.op.equals((Object)ConditionalOperator.GR)) && this.getParameterTypes().get(parent_name) == ParameterType.CATEGORICAL) {
                        throw new IllegalArgumentException("You cannot use the > or < in a conditional clause with categorical parameter:" + parent_name);
                    }
                    op_in[j] = cond.op.getOperatorCode();
                    ++j;
                }
                parent_id[i] = parent_id_in;
                values[i] = values_in;
                op[i] = op_in;
                ++i;
            }
            this.nameConditionsMapParentsArray.put(p_idx, parent_id);
            this.nameConditionsMapParentsValues.put(p_idx, values);
            this.nameConditionsMapOp.put(p_idx, op);
        }
    }

    private boolean parseForbiddenLines(List<String> lines) {
        boolean newForbiddenStatements = false;
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line;
            String originalLine = line = iterator.next();
            if (line.indexOf("#") >= 0) {
                line = line.substring(0, line.indexOf("#"));
            }
            Matcher classicForbiddenStatementMatcher = this.classicForbidden.matcher(line);
            Matcher generalForbiddenMatcher = this.generalForbidden.matcher(line);
            if (classicForbiddenStatementMatcher.matches()) {
                String values = classicForbiddenStatementMatcher.group(1);
                String[] nameValuePairs = values.split(",");
                ArrayList<double[]> forbiddenIndexValuePairs = new ArrayList<double[]>();
                block12: for (String nameValuePair : nameValuePairs) {
                    Object[] nvPairArr = nameValuePair.split("=");
                    if (nvPairArr.length != 2) {
                        throw new IllegalArgumentException("Line specifying forbidden parameters contained an name value pair that could not be parsed: " + Arrays.toString(nvPairArr) + " in line: " + originalLine);
                    }
                    String name = nvPairArr[0].trim();
                    Integer indexIntoValueArrays = this.paramKeyIndexMap.get(name);
                    if (indexIntoValueArrays == null) {
                        throw new IllegalArgumentException("Unknown parameter " + name + " in line: " + originalLine);
                    }
                    String value = ((String)nvPairArr[1]).trim();
                    switch (this.paramTypes.get(name)) {
                        case CATEGORICAL: {
                            Integer valueIndex = this.categoricalValueMap.get(name).get(value);
                            if (valueIndex == null) {
                                throw new IllegalArgumentException("Invalid parameter value " + value + " for parameter " + name + " in line: " + line);
                            }
                            double[] nvPairArrayForm = new double[]{indexIntoValueArrays.intValue(), valueIndex.intValue()};
                            forbiddenIndexValuePairs.add(nvPairArrayForm);
                            continue block12;
                        }
                        case ORDINAL: {
                            value = String.valueOf(this.categoricalValueMap.get(name).get(value));
                        }
                        case REAL: 
                        case INTEGER: {
                            double[] nvPairArrayForm = new double[]{indexIntoValueArrays.intValue(), this.getNormalizedRangeMap().get(name).normalizeValue(Double.valueOf(value))};
                            forbiddenIndexValuePairs.add(nvPairArrayForm);
                            continue block12;
                        }
                        default: {
                            throw new IllegalStateException("Unknown Parameter Type:" + (Object)((Object)this.paramTypes.get(name)));
                        }
                    }
                }
                this.forbiddenParameterValuesList.add((double[][])forbiddenIndexValuePairs.toArray((T[])new double[0][0]));
                continue;
            }
            if (generalForbiddenMatcher.find()) {
                newForbiddenStatements = true;
                ExpressionBuilder eb = new ExpressionBuilder(line);
                TreeSet<String> parameterNameVariables = new TreeSet<String>(this.getParameterNames());
                TreeSet parameterValuesVariables = new TreeSet();
                TreeSet<String> allParameterValues = new TreeSet<String>();
                HashSet<TopologicalSorter.Constraint<String>> constraints = new HashSet<TopologicalSorter.Constraint<String>>();
                for (Map.Entry<String, Map<String, Integer>> ent : this.categoricalValueMap.entrySet()) {
                    int i;
                    ArrayList<String> paramValues = new ArrayList<String>(ent.getValue().keySet());
                    allParameterValues.addAll(paramValues);
                    if (this.getParameterTypes().get(ent.getKey()) == ParameterType.ORDINAL) {
                        for (i = 1; i < paramValues.size(); ++i) {
                            constraints.add(new TopologicalSorter.Constraint(paramValues.get(i - 1), paramValues.get(i)));
                        }
                    }
                    for (i = 0; i < paramValues.size(); ++i) {
                        try {
                            Double.valueOf((String)paramValues.get(i));
                            continue;
                        }
                        catch (RuntimeException e) {
                            parameterValuesVariables.add(paramValues.get(i));
                        }
                    }
                }
                HashSet<String> copyOfParameterNameVariables = new HashSet<String>(parameterNameVariables);
                copyOfParameterNameVariables.removeAll(parameterValuesVariables);
                if (this.forbiddenParameterConstants == null) {
                    List<String> topologicallySortedValues;
                    try {
                        topologicallySortedValues = TopologicalSorter.getTopologicalOrder(allParameterValues, constraints);
                    }
                    catch (TopologicalSorter.NoTopologicalOrderAvailableException e) {
                        throw new IllegalArgumentException("Cycle detected in ordinal parameter values:" + e.getMessage());
                    }
                    this.forbiddenParameterConstants = Collections.unmodifiableMap(this.getForbiddenParameterConstants(topologicallySortedValues));
                    LinkedHashMap<String, Double> forbiddenParameterConstantVariableValues = new LinkedHashMap<String, Double>();
                    for (Map.Entry<String, Double> ent : this.forbiddenParameterConstants.entrySet()) {
                        try {
                            Double.valueOf(ent.getKey());
                        }
                        catch (RuntimeException e) {
                            forbiddenParameterConstantVariableValues.put(ent.getKey(), ent.getValue());
                        }
                    }
                    this.forbiddenOrdinalAndCategoricalVariableValues = Collections.unmodifiableMap(forbiddenParameterConstantVariableValues);
                }
                if (!copyOfParameterNameVariables.equals(parameterNameVariables)) {
                    parameterNameVariables.retainAll(parameterValuesVariables);
                    throw new IllegalArgumentException("Detected parameter name that is also a value to another parameter, which is not allowed with advanced forbidden parameters: " + parameterNameVariables);
                }
                TreeSet<String> exp4jVariables = new TreeSet<String>();
                exp4jVariables.addAll(parameterNameVariables);
                exp4jVariables.addAll(parameterValuesVariables);
                eb.variables(exp4jVariables);
                HashSet<String> illegalVariables = new HashSet<String>();
                Pattern legalCharacters = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
                for (String variable : exp4jVariables) {
                    if (legalCharacters.matcher(variable).find()) continue;
                    illegalVariables.add(variable);
                }
                if (illegalVariables.size() > 0) {
                    throw new IllegalArgumentException("When using Advanced Forbidden Syntax all parameter names and values must start with an letter or underscore, and can only consist of letter, underscores and digits. Illegal names & values are:" + illegalVariables);
                }
                eb.operator(ForbiddenOperators.operators);
                this.bl.add(eb);
                this.expressions.put(eb, line);
                continue;
            }
            throw new IllegalArgumentException("Unsure how to parse the following line, guess was that it was forbidden, line: " + originalLine);
        }
        this.forbiddenLines.clear();
        return newForbiddenStatements;
    }

    private Map<String, Double> getForbiddenParameterConstants(List<String> input) {
        LinkedHashMap<String, Double> forbiddenExpressionConstants = new LinkedHashMap<String, Double>();
        double leastValue = input.size();
        int inputsBeforeLeastValue = 0;
        for (String val : input) {
            ++inputsBeforeLeastValue;
            try {
                leastValue = Double.valueOf(val);
                break;
            }
            catch (RuntimeException e) {
            }
        }
        double lastValue = leastValue - (double)inputsBeforeLeastValue;
        int i = 0;
        while (i < input.size()) {
            int j;
            boolean nextNumberFound = false;
            int indexOfNumberFound = 0;
            double nextNumber = 0.0;
            for (j = i; j < input.size(); ++j) {
                try {
                    nextNumber = Double.valueOf(input.get(j));
                    nextNumberFound = true;
                    indexOfNumberFound = j;
                    break;
                }
                catch (RuntimeException e) {
                    continue;
                }
            }
            if (!nextNumberFound) {
                for (j = i; j < input.size(); ++j) {
                    forbiddenExpressionConstants.put(input.get(j), (double)(j - i + 1) + lastValue);
                }
                break;
            }
            double delta = nextNumber - lastValue;
            double avgDelta = delta / (double)(indexOfNumberFound - i + 1);
            double assignedValue = nextNumber - (double)(indexOfNumberFound - i + 1) * avgDelta;
            for (int j2 = i; j2 < indexOfNumberFound; ++j2) {
                forbiddenExpressionConstants.put(input.get(j2), assignedValue += avgDelta);
            }
            lastValue = nextNumber;
            i = indexOfNumberFound + 1;
            forbiddenExpressionConstants.put(input.get(indexOfNumberFound), nextNumber);
        }
        return forbiddenExpressionConstants;
    }

    private String transformOldFormat(String s) {
        String line = s;
        int commentStart = line.indexOf("#");
        line = line.trim();
        if (commentStart >= 0) {
            line = line.substring(0, commentStart).trim();
        }
        if (line.length() == 0) {
            return s;
        }
        if (line.trim().equals("Conditionals:")) {
            return s;
        }
        if (line.trim().equals("Forbidden:")) {
            return s;
        }
        Matcher match = this.oldCategoricalFormatMatcher.matcher(line);
        if (match.find()) {
            String name = match.group(1);
            String values = match.group(2);
            String defaultValue = match.group(3);
            String newLine = name + " c {" + values + "} [" + defaultValue + "]";
            return newLine;
        }
        match = this.oldContinuousFormatMatcher.matcher(line);
        if (match.find()) {
            String name = match.group(1);
            String range = match.group(2);
            String defaultValue = match.group(3);
            String il = match.group(4);
            boolean integerOnly = false;
            boolean logTransform = false;
            if (il.contains("i")) {
                integerOnly = true;
            }
            if (il.contains("l")) {
                logTransform = true;
            }
            String newLine = name + " " + (integerOnly ? "i" : "r") + " [" + range + "] " + "[" + defaultValue + "]" + (logTransform ? "log" : "");
            return newLine;
        }
        return s;
    }

    private String getName(String line) {
        return this.getName(line, 0);
    }

    private String getName(String line, int offset) {
        line = line.trim();
        int firstSpace = line.indexOf(" ");
        int firstPipe = line.indexOf("|");
        int firstCurly = line.indexOf("{");
        int firstSquare = line.indexOf("[");
        if (firstSpace == -1) {
            firstSpace = Integer.MAX_VALUE;
        }
        if (firstPipe == -1) {
            firstPipe = Integer.MAX_VALUE;
        }
        if (firstCurly == -1) {
            firstCurly = Integer.MAX_VALUE;
        }
        if (firstSquare == -1) {
            firstSquare = Integer.MAX_VALUE;
        }
        int nameBoundary = Math.min(firstSpace, firstPipe);
        nameBoundary = Math.min(nameBoundary, firstCurly);
        String name = line.substring(offset, nameBoundary = Math.min(nameBoundary, firstSquare)).trim();
        if (name.length() == 0) {
            throw new IllegalArgumentException("Did Not Parse a Parameter Name in line: " + line);
        }
        return name;
    }

    public List<String> getParameterNames() {
        return Collections.unmodifiableList(this.authorativeParameterNameOrder);
    }

    public Map<String, Boolean> getContinuousMap() {
        LinkedHashMap<String, Boolean> continuousMap = new LinkedHashMap<String, Boolean>();
        for (Map.Entry<String, ParameterType> ent : this.getParameterTypes().entrySet()) {
            continuousMap.put(ent.getKey(), ent.getValue().isNormalized());
        }
        return Collections.unmodifiableMap(continuousMap);
    }

    public Map<String, List<String>> getValuesMap() {
        return Collections.unmodifiableMap(this.values);
    }

    public Map<String, String> getDefaultValuesMap() {
        return Collections.unmodifiableMap(this.defaultValues);
    }

    public Map<String, Map<String, Integer>> getCategoricalValueMap() {
        return Collections.unmodifiableMap(this.categoricalValueMap);
    }

    public Map<String, NormalizedRange> getNormalizedRangeMap() {
        return Collections.unmodifiableMap(this.contNormalizedRanges);
    }

    public List<String> getParameterNamesInAuthorativeOrder() {
        return this.authorativeParameterNameOrder;
    }

    public Set<String> getImmediateParentParameters(String parameter) {
        return Collections.unmodifiableSet((Set)this.parameterDependencies.get(parameter));
    }

    public Set<String> getAllParentParameters(String parameter) {
        Set immediate = this.parameterDependencies.get(parameter);
        if (immediate == null) {
            return null;
        }
        HashSet<String> parents = new HashSet<String>(immediate);
        HashSet queryParameters = new HashSet(immediate);
        while (!queryParameters.isEmpty()) {
            HashSet newParents = new HashSet();
            for (String queryParameter : queryParameters) {
                Set queryParents = this.parameterDependencies.get(queryParameter);
                if (queryParents == null) continue;
                newParents.addAll(queryParents);
            }
            queryParameters.clear();
            parents.addAll(newParents);
            queryParameters.addAll(newParents);
        }
        return parents;
    }

    public int hashCode() {
        return this.absoluteFileName.hashCode();
    }

    public boolean isCompatible(ParameterConfigurationSpace oSpace) {
        return Arrays.equals(this.categoricalSize, oSpace.categoricalSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParameterConfigurationSpace) {
            ParameterConfigurationSpace po = (ParameterConfigurationSpace)o;
            if (po.absoluteFileName.equals(this.absoluteFileName) && Arrays.equals(this.searchSubspaceActive, po.searchSubspaceActive) && Arrays.equals(this.searchSubspaceValues, po.searchSubspaceValues)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ParamFile:" + this.absoluteFileName;
    }

    public ParameterConfiguration getRandomParameterConfiguration(Random random) {
        return this.getRandomParameterConfiguration(random, false);
    }

    public ParameterConfiguration getRandomParameterConfiguration(Random random, boolean allowForbiddenParameters) {
        return this.getRandomParameterConfiguration(new RandomAdapter(random), allowForbiddenParameters);
    }

    public ParameterConfiguration getRandomParameterConfiguration(MersenneTwisterFast random) {
        return this.getRandomParameterConfiguration(new RandomAdapter(random), false);
    }

    public ParameterConfiguration getRandomParameterConfiguration(MersenneTwisterFast random, boolean allowForbiddenParameters) {
        return this.getRandomParameterConfiguration(new RandomAdapter(random), allowForbiddenParameters);
    }

    private ParameterConfiguration getRandomParameterConfiguration(RandomAdapter random, boolean allowForbiddenParameters) {
        if (random == null) {
            throw new IllegalArgumentException("Cannot supply null random object ");
        }
        double[] valueArray = new double[this.numberOfParameters];
        for (int j = 0; j < 1000000; ++j) {
            for (int i = 0; i < this.numberOfParameters; ++i) {
                if (this.searchSubspaceActive[i]) {
                    valueArray[i] = this.searchSubspaceValues[i];
                    continue;
                }
                if (this.parameterDomainContinuous[i]) {
                    NormalizedRange nr = this.normalizedRangesByIndex[i];
                    valueArray[i] = nr.normalizeValue(nr.unnormalizeValue(random.nextDouble()));
                    continue;
                }
                valueArray[i] = random.nextInt(this.categoricalSize[i]) + 1;
            }
            ParameterConfiguration p = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
            if (!allowForbiddenParameters && p.isForbiddenParameterConfiguration()) continue;
            return p;
        }
        throw new IllegalArgumentException("After 1,000,000 attempts at generating a random configurations we have failed to generate even one that isn't forbidden. It is likely that your forbidden parameter settings are too restrictive. Try excluding smaller regions of the space.");
    }

    public ParameterConfiguration getDefaultConfiguration() {
        return this.getConfigurationFromValueArray(this.defaultConfigurationValueArray);
    }

    private ParameterConfiguration _getDefaultConfiguration() {
        ParameterConfiguration p = new ParameterConfiguration(this, new double[this.numberOfParameters], this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
        Map<String, String> defaultMap = this.getDefaultValuesMap();
        p.putAll((Map<? extends String, ? extends String>)defaultMap);
        return p;
    }

    public double getUpperBoundOnSize() {
        double configSpaceSize = 1.0;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            int catSize = this.categoricalSize[i];
            if (catSize != 0) {
                configSpaceSize *= (double)catSize;
                continue;
            }
            NormalizedRange nr = this.contNormalizedRanges.get(this.authorativeParameterNameOrder.get(i));
            if (nr.isIntegerOnly()) {
                configSpaceSize *= nr.unnormalizeValue(1.0) - nr.unnormalizeValue(0.0) + 1.0;
                continue;
            }
            return Double.POSITIVE_INFINITY;
        }
        return configSpaceSize;
    }

    public double getLowerBoundOnSize() {
        double configSpaceSize = 1.0;
        if (this.forbiddenParameterValuesList.size() > 0 || this.bl.size() > 0) {
            return 1.0;
        }
        for (int i = 0; i < this.numberOfParameters; ++i) {
            int catSize = this.categoricalSize[i];
            if (this.parameterDependencies.get(this.authorativeParameterNameOrder.get(i)) != null) continue;
            if (catSize != 0) {
                configSpaceSize *= (double)catSize;
                continue;
            }
            NormalizedRange nr = this.contNormalizedRanges.get(this.authorativeParameterNameOrder.get(i));
            if (nr.isIntegerOnly()) {
                configSpaceSize *= nr.unnormalizeValue(1.0) - nr.unnormalizeValue(0.0) + 1.0;
                continue;
            }
            return Double.POSITIVE_INFINITY;
        }
        return configSpaceSize;
    }

    private ParameterConfiguration getConfigurationFromValueArray(double[] valueArray) {
        if (valueArray.length != this.categoricalSize.length) {
            throw new IllegalArgumentException("Value Array Length is not the right size " + valueArray.length + " vs " + this.categoricalSize.length);
        }
        return new ParameterConfiguration(this, (double[])valueArray.clone(), this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
    }

    public ParameterConfiguration getParameterConfigurationFromString(String paramString, ParameterConfiguration.ParameterStringFormat f) {
        return this.getParameterConfigurationFromString(paramString, f, null);
    }

    public ParameterConfiguration getParameterConfigurationFromString(String paramString, ParameterConfiguration.ParameterStringFormat f, Random rand) {
        try {
            ParameterConfiguration config;
            String trySpecialParamString = paramString.trim().toUpperCase();
            if (trySpecialParamString.equals("DEFAULT") || trySpecialParamString.equals("<DEFAULT>")) {
                return this.getDefaultConfiguration();
            }
            if (trySpecialParamString.equals("RANDOM") || trySpecialParamString.equals("<RANDOM>")) {
                if (rand == null) {
                    throw new IllegalStateException("Cannot generate random configurations unless a random object is passed with us");
                }
                return this.getRandomParameterConfiguration(rand);
            }
            HashSet<String> namesSpecified = new HashSet<String>();
            ParameterConfiguration defaultConfig = this.getDefaultConfiguration();
            switch (f) {
                case NODB_SYNTAX_WITH_INDEX: {
                    paramString = paramString.replaceFirst("\\A\\d+:", "");
                }
                case NODB_SYNTAX: {
                    String[] paramSplit;
                    double[] valueArray = new double[this.numberOfParameters];
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = " " + paramString;
                    Object params = tmpParamString.split("\\s-");
                    for (String param : params) {
                        if (param.trim().equals("") || (paramSplit = param.trim().split(" "))[1].trim().equals("NaN")) continue;
                        config.put(paramSplit[0].trim(), paramSplit[1].replaceAll("'", "").trim());
                        namesSpecified.add(paramSplit[0].trim());
                    }
                    break;
                }
                case STATEFILE_SYNTAX_WITH_INDEX: {
                    paramString = paramString.replaceFirst("\\A\\d+:", "");
                }
                case STATEFILE_SYNTAX: {
                    String[] paramSplit;
                    double[] valueArray = new double[this.numberOfParameters];
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = " " + paramString.replaceAll("'", "");
                    Object params = tmpParamString.split(",");
                    for (String param : params) {
                        if (param.trim().equals("") || (paramSplit = param.trim().split("="))[1].trim().equals("NaN")) continue;
                        config.put(paramSplit[0].trim(), paramSplit[1].trim());
                        namesSpecified.add(paramSplit[0].trim());
                    }
                    break;
                }
                case ARRAY_STRING_SYNTAX: {
                    double[] valueArray = new double[this.numberOfParameters];
                    String tmpParamString = paramString;
                    if (paramString.trim().length() == 0) {
                        config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                        break;
                    }
                    Object params = tmpParamString.split(",");
                    if (((String[])params).length != valueArray.length) {
                        throw new IllegalArgumentException("Param String Value Array expected to be: " + valueArray.length + " but got a string of length " + paramString.length());
                    }
                    for (int i = 0; i < valueArray.length; ++i) {
                        valueArray[i] = Double.valueOf(params[i]);
                    }
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    namesSpecified.addAll(config.keySet());
                    break;
                }
                case SURROGATE_EXECUTOR: {
                    double[] valueArray = new double[this.numberOfParameters];
                    config = new ParameterConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    if (paramString.trim().length() == 0) break;
                    String tmpParamString = paramString.trim().replaceAll("-P", "");
                    Object params = tmpParamString.trim().split(" ");
                    for (int i = 0; i < ((String[])params).length; ++i) {
                        String[] param = ((String)params[i]).split("=");
                        if (param.length != 2) {
                            throw new IllegalArgumentException("Param String could not parse portion of string " + paramString + " error occured while seperating: (" + (String)params[i] + ")");
                        }
                        namesSpecified.add(param[0].trim());
                        config.put(param[0].trim(), param[1].trim());
                    }
                    if (namesSpecified.equals(config.getActiveParameters())) break;
                    HashSet<String> missingButRequired = new HashSet<String>();
                    HashSet<String> specifiedButNotActive = new HashSet<String>();
                    missingButRequired.addAll(config.getActiveParameters());
                    missingButRequired.removeAll(namesSpecified);
                    specifiedButNotActive.addAll(namesSpecified);
                    specifiedButNotActive.removeAll(config.getActiveParameters());
                    throw new IllegalArgumentException("Param String specified some combination of inactive parameters and/or missed active parameters. \nRequired Parameters: " + config.getActiveParameters().size() + "\nSpecified Parameters: " + namesSpecified.size() + "\nRequired But Missing: " + ((Object)missingButRequired).toString() + "\nSpecified But Not Required" + ((Object)specifiedButNotActive).toString());
                }
                case NODB_OR_STATEFILE_SYNTAX: {
                    try {
                        return this.getParameterConfigurationFromString(paramString, ParameterConfiguration.ParameterStringFormat.STATEFILE_SYNTAX, rand);
                    }
                    catch (RuntimeException e) {
                        return this.getParameterConfigurationFromString(paramString, ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX, rand);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Parsing not implemented for String Format: " + (Object)((Object)f));
                }
            }
            HashSet<String> allParameters = new HashSet<String>(this.getParameterNames());
            allParameters.removeAll(config.getActiveParameters());
            for (String inactiveParameter : allParameters) {
                if (namesSpecified.contains(inactiveParameter)) continue;
                config.put(inactiveParameter, defaultConfig.get(inactiveParameter));
            }
            TreeSet<String> unSetActiveParameters = new TreeSet<String>(config.getActiveParameters());
            unSetActiveParameters.removeAll(namesSpecified);
            if (unSetActiveParameters.size() > 0) {
                throw new ParameterConfigurationStringMissingParameterException("Error processing Parameter Configuration String \"" + paramString + "\" in format: " + (Object)((Object)f) + ". The string specified is missing one or more required parameters: " + ((Object)unSetActiveParameters).toString());
            }
            return config;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ParameterConfigurationStringFormatException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ParameterConfigurationStringFormatException("Error processing Parameter Configuration String \"" + paramString + "\" in format: " + (Object)((Object)f) + " please check the arguments (and nested exception) and try again", e);
        }
    }

    public int[] getCategoricalSize() {
        return (int[])this.categoricalSize.clone();
    }

    protected boolean isForbiddenParameterConfigurationByClassicClauses(double[] valueArray) {
        for (double[][] forbiddenParamValues : this.forbiddenParameterValuesList) {
            boolean match = true;
            for (double[] forbiddenParamValue : forbiddenParamValues) {
                int index = (int)forbiddenParamValue[0];
                if (this.parameterDomainContinuous[index]) {
                    if (valueArray[index] == forbiddenParamValue[1]) continue;
                    match = false;
                    break;
                }
                if (valueArray[index] == forbiddenParamValue[1] + 1.0) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean isIntegerDouble(double d) {
        return d - Math.floor(d) == 0.0;
    }

    public boolean hasRealParameterFile() {
        return this.hasRealParameterFile;
    }

    public static ParameterConfigurationSpace getSingletonConfigurationSpace() {
        return new ParameterConfigurationSpace((Reader)new StringReader("singleton c { singleton } [singleton]"), SINGLETON_ABSOLUTE_NAME);
    }

    public static ParameterConfigurationSpace getNullConfigurationSpace() {
        return new ParameterConfigurationSpace((Reader)new StringReader(""), NULL_ABSOLUTE_NAME);
    }

    void setValueInArray(double[] valueArray, String key, String newValue) {
        Integer index = this.paramKeyIndexMap.get(key);
        if (index == null) {
            throw new IllegalArgumentException("This key does not exist in the Parameter Space: " + key);
        }
        if (newValue == null) {
            valueArray[index.intValue()] = Double.NaN;
        } else if (this.parameterDomainContinuous[index]) {
            NormalizedRange nr = this.getNormalizedRangeMap().get(key);
            valueArray[index.intValue()] = nr.normalizeValue(nr.unnormalizeValue(nr.normalizeValue(Double.valueOf(newValue))));
        } else {
            List<String> inOrderValues = this.getValuesMap().get(key);
            int i = 1;
            boolean valueFound = false;
            for (String possibleValue : inOrderValues) {
                if (possibleValue.equals(newValue)) {
                    valueArray[index.intValue()] = i;
                    valueFound = true;
                    break;
                }
                ++i;
            }
            if (!valueFound) {
                throw new IllegalArgumentException("Value is not legal for this parameter: " + key + " Value:" + newValue);
            }
        }
    }

    public String getPCSFile() {
        return this.pcsFile;
    }

    public Map<String, String> getSearchSubspace() {
        return this.searchSubspace;
    }

    boolean hasNewForbidden() {
        return this.newForbiddenLinesPresent;
    }

    public Map<String, Double> getForbiddenOrdinalAndCategoricalValues() {
        return this.forbiddenParameterConstants == null ? Collections.emptyMap() : this.forbiddenParameterConstants;
    }

    public Map<String, Double> getForbiddenOrdinalAndCategoricalVariableValues() {
        return this.forbiddenOrdinalAndCategoricalVariableValues == null ? Collections.emptyMap() : this.forbiddenOrdinalAndCategoricalVariableValues;
    }

    private final Object writeReplace() throws ObjectStreamException {
        JSONConverter<ParameterConfigurationSpace> json = new JSONConverter<ParameterConfigurationSpace>(){};
        String jsonText = json.getJSON(this);
        return new PCSSerializationProxy(jsonText);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("This object cannot be deserialized, should have used: " + PCSSerializationProxy.class.getCanonicalName());
    }

    private static final class PCSSerializationProxy
    implements Serializable {
        private final String pcsJSON;
        private static final long serialVersionUID = 21585218521L;

        public PCSSerializationProxy(String json) {
            this.pcsJSON = json;
        }

        private final Object readResolve() throws ObjectStreamException {
            JSONConverter<ParameterConfigurationSpace> json = new JSONConverter<ParameterConfigurationSpace>(){};
            return json.getObject(this.pcsJSON);
        }
    }

    private static class RandomAdapter {
        private MersenneTwisterFast fastRand;
        private Random rand;

        RandomAdapter(Random r) {
            this.rand = r;
            this.fastRand = null;
        }

        RandomAdapter(MersenneTwisterFast fastRand) {
            this.rand = null;
            this.fastRand = fastRand;
        }

        public int nextInt(int n) {
            if (this.fastRand != null) {
                return this.fastRand.nextInt(n);
            }
            return this.rand.nextInt(n);
        }

        public double nextDouble() {
            if (this.fastRand != null) {
                return this.fastRand.nextDouble();
            }
            return this.rand.nextDouble();
        }
    }

    public class Conditional {
        public final int parent_ID;
        public final double[] values;
        public final ConditionalOperator op;

        public Conditional(int parent_ID, double[] values, ConditionalOperator op) {
            this.parent_ID = parent_ID;
            this.values = values;
            this.op = op;
        }

        public String toString() {
            return "parentID:" + this.parent_ID + " values: " + Arrays.toString(this.values) + " op: " + (Object)((Object)this.op);
        }
    }

    public static enum ParameterType {
        CATEGORICAL(false),
        ORDINAL(true),
        INTEGER(true),
        REAL(true);

        private final boolean normalize;

        private ParameterType(boolean normalize) {
            this.normalize = normalize;
        }

        public Boolean isNormalized() {
            return this.normalize;
        }
    }
}

