/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.misc.bootstrap;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.objectives.ObjectiveHelper;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class ConfigurationDifference {
    public static ChallengeResult compareChallengerWithIncumbent(ThreadSafeRunHistory runHistory, ParameterConfiguration challenger, ParameterConfiguration incumbent, Random rand, ObjectiveHelper obj, double cutoffTime) {
        Set<ProblemInstance> piCommon = runHistory.getProblemInstancesRan(incumbent);
        piCommon.retainAll(runHistory.getProblemInstancesRan(challenger));
        double incCost = runHistory.getEmpiricalCost(incumbent, piCommon, cutoffTime);
        double chalCost = runHistory.getEmpiricalCost(challenger, piCommon, cutoffTime);
        if (incCost + Math.pow(10.0, -6.0) < chalCost) {
            return ChallengeResult.REJECT_CHALLENGER;
        }
        List<AlgorithmRunResult> incumbentRuns = runHistory.getAlgorithmRunsExcludingRedundant(incumbent);
        List<AlgorithmRunResult> chalRuns = runHistory.getAlgorithmRunsExcludingRedundant(challenger);
        Set<ProblemInstanceSeedPair> chalPisps = runHistory.getProblemInstanceSeedPairsRan(challenger);
        HashSet<ProblemInstanceSeedPair> common = new HashSet<ProblemInstanceSeedPair>(runHistory.getProblemInstanceSeedPairsRan(incumbent));
        common.retainAll(chalPisps);
        LinkedHashMap<ProblemInstanceSeedPair, AlgorithmRunResult> challengerRunMap = new LinkedHashMap<ProblemInstanceSeedPair, AlgorithmRunResult>();
        LinkedHashMap<ProblemInstanceSeedPair, AlgorithmRunResult> incRunMap = new LinkedHashMap<ProblemInstanceSeedPair, AlgorithmRunResult>();
        for (AlgorithmRunResult run : incumbentRuns) {
            if (!common.contains(run.getProblemInstanceSeedPair())) continue;
            incRunMap.put(run.getProblemInstanceSeedPair(), run);
        }
        for (AlgorithmRunResult run : chalRuns) {
            if (!common.contains(run.getProblemInstanceSeedPair())) continue;
            challengerRunMap.put(run.getProblemInstanceSeedPair(), run);
        }
        ArrayList instanceSeedPairs = new ArrayList();
        instanceSeedPairs.addAll(challengerRunMap.keySet());
        int BOOTSTRAP_SAMPLES = 1000;
        double[] bootstrapDiff = new double[1000];
        for (int B = 0; B < 1000; ++B) {
            ArrayList<AlgorithmRunResult> chalBootSamples = new ArrayList<AlgorithmRunResult>();
            ArrayList<AlgorithmRunResult> incBootSamples = new ArrayList<AlgorithmRunResult>();
            for (int i = 0; i < instanceSeedPairs.size(); ++i) {
                ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)instanceSeedPairs.get(rand.nextInt(instanceSeedPairs.size()));
                AlgorithmRunResult chalRun = (AlgorithmRunResult)challengerRunMap.get(pisp);
                if (chalRun == null) {
                    throw new IllegalStateException("Challenger Run for pisp " + pisp + " was null this was unexpected");
                }
                AlgorithmRunResult incRun = (AlgorithmRunResult)incRunMap.get(pisp);
                if (incRun == null) {
                    throw new IllegalStateException("Incumbent Run for pisp " + pisp + " was null this was unexpected");
                }
                chalBootSamples.add(chalRun);
                incBootSamples.add(incRun);
            }
            double chal = obj.computeObjective(chalBootSamples);
            double inc = obj.computeObjective(incBootSamples);
            bootstrapDiff[B] = chal - inc;
        }
        Percentile p = new Percentile();
        double sigLevel = p.evaluate(bootstrapDiff, 95.0);
        if (sigLevel < 0.0) {
            return ChallengeResult.ACCEPT_CHALLENGER;
        }
        return ChallengeResult.CONTINUE;
    }

    public static enum ChallengeResult {
        CONTINUE,
        REJECT_CHALLENGER,
        ACCEPT_CHALLENGER;

    }
}

