/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.statemerge;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.model.ModelBuildingOptions;
import ca.ubc.cs.beta.aeatk.model.builder.AdaptiveCappingModelBuilder;
import ca.ubc.cs.beta.aeatk.model.builder.BasicModelBuilder;
import ca.ubc.cs.beta.aeatk.model.builder.ModelBuilder;
import ca.ubc.cs.beta.aeatk.model.data.DefaultValueForConditionalsMDS;
import ca.ubc.cs.beta.aeatk.model.data.MaskCensoredDataAsUncensored;
import ca.ubc.cs.beta.aeatk.model.data.MaskInactiveConditionalParametersWithDefaults;
import ca.ubc.cs.beta.aeatk.model.data.SanitizedModelData;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.options.RandomForestOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistoryHelper;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMergeModelBuilder {
    private RandomForest forest;
    private RandomForest preparedForest;
    private SanitizedModelData sanitizedData;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void learnModel(List<ProblemInstance> instances, RunHistory runHistory, ParameterConfigurationSpace configSpace, RandomForestOptions rfOptions, ModelBuildingOptions mbOptions, double cutoffTime, OverallObjective intraInstanceObjective, boolean adaptiveCapping, SeedableRandomPool pool) {
        int j;
        LinkedHashSet<ProblemInstance> all_instances = new LinkedHashSet<ProblemInstance>(instances);
        Set<ParameterConfiguration> paramConfigs = runHistory.getUniqueParamConfigurations();
        Set<ProblemInstance> runInstances = runHistory.getUniqueInstancesRan();
        ArrayList<Integer> runInstancesIdx = new ArrayList<Integer>(all_instances.size());
        int i = 0;
        double[][] instanceFeatureMatrix = new double[all_instances.size()][];
        for (ProblemInstance problemInstance : all_instances) {
            if (runInstances.contains(problemInstance)) {
                runInstancesIdx.add(i);
            }
            instanceFeatureMatrix[i] = problemInstance.getFeaturesDouble();
            ++i;
        }
        double[][] thetaMatrix = new double[paramConfigs.size()][];
        i = 0;
        for (ParameterConfiguration pc : paramConfigs) {
            if (mbOptions.maskInactiveConditionalParametersAsDefaultValue) {
                thetaMatrix[i++] = pc.toComparisonValueArray();
                continue;
            }
            thetaMatrix[i++] = pc.toValueArray();
        }
        int[] nArray = new int[runInstancesIdx.size()];
        for (int j2 = 0; j2 < runInstancesIdx.size(); ++j2) {
            nArray[j2] = (Integer)runInstancesIdx.get(j2);
        }
        List<AlgorithmRunResult> runs = runHistory.getAlgorithmRunsExcludingRedundant();
        double[] runResponseValues = RunHistoryHelper.getRunResponseValues(runs, runHistory.getRunObjective());
        boolean[] censored = RunHistoryHelper.getCensoredEarlyFlagForRuns(runs);
        if (mbOptions.maskCensoredDataAsKappaMax) {
            for (j = 0; j < runResponseValues.length; ++j) {
                if (!censored[j]) continue;
                runResponseValues[j] = cutoffTime;
            }
        }
        for (j = 0; j < runResponseValues.length; ++j) {
            if (!(runResponseValues[j] >= cutoffTime)) continue;
            runResponseValues[j] = cutoffTime * intraInstanceObjective.getPenaltyFactor();
        }
        SanitizedModelData sanitizedData = new DefaultValueForConditionalsMDS((double[][])instanceFeatureMatrix, (double[][])thetaMatrix, runResponseValues, nArray, (boolean)rfOptions.logModel, runHistory.getParameterConfigurationInstancesRanByIndexExcludingRedundant(), censored, configSpace);
        if (mbOptions.maskCensoredDataAsUncensored) {
            sanitizedData = new MaskCensoredDataAsUncensored(sanitizedData);
        }
        if (mbOptions.maskInactiveConditionalParametersAsDefaultValue) {
            sanitizedData = new MaskInactiveConditionalParametersWithDefaults(sanitizedData, configSpace);
        }
        this.forest = null;
        this.preparedForest = null;
        ModelBuilder mb = adaptiveCapping ? new AdaptiveCappingModelBuilder(sanitizedData, rfOptions, pool.getRandom("RANDOM_FOREST_BUILDING_PRNG"), mbOptions.imputationIterations, cutoffTime, intraInstanceObjective.getPenaltyFactor(), 1.0) : new BasicModelBuilder(sanitizedData, rfOptions, 1.0, pool.getRandom("RANDOM_FOREST_BUILDING_PRNG"));
        this.forest = mb.getRandomForest();
        this.preparedForest = mb.getPreparedRandomForest();
        this.log.debug("Random Forest Built");
    }

    public RandomForest getRandomForest() {
        return this.forest;
    }

    public RandomForest getPreparedForest() {
        return this.preparedForest;
    }
}

