/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.eventsystem.handlers;

import ca.ubc.cs.beta.aeatk.eventsystem.EventHandler;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;

public class ParamConfigurationIncumbentChangerOriginTracker
implements EventHandler<IncumbentPerformanceChangeEvent> {
    private final ParamConfigurationOriginTracker configTracker;
    private final ThreadSafeRunHistory runHistory;
    private double cutoffTime;
    ParameterConfiguration lastIncumbent;

    public ParamConfigurationIncumbentChangerOriginTracker(ParamConfigurationOriginTracker configTracker, ThreadSafeRunHistory runHistory, double cutoffTime) {
        this.configTracker = configTracker;
        this.runHistory = runHistory;
        this.cutoffTime = cutoffTime;
    }

    @Override
    public synchronized void handleEvent(IncumbentPerformanceChangeEvent event) {
        if (event.incumbentChanged()) {
            this.configTracker.addConfiguration(event.getIncumbent(), "Incumbent", "Performance=" + event.getEmpiricalPerformance(), "Runs=" + event.getIncumbentRunCount());
            if (this.lastIncumbent != null) {
                this.runHistory.readLock();
                try {
                    this.configTracker.addConfiguration(this.lastIncumbent, "Displaced Incumbent", "Performance=" + this.runHistory.getEmpiricalCost(this.lastIncumbent, this.runHistory.getProblemInstancesRan(this.lastIncumbent), this.cutoffTime), "Runs=" + this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(this.lastIncumbent));
                }
                finally {
                    this.runHistory.releaseReadLock();
                }
            }
            this.lastIncumbent = event.getIncumbent();
        }
    }
}

