/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.concurrent.threadfactory;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SequentiallyNamedThreadFactory
implements ThreadFactory {
    private final String name;
    private final AtomicLong threadIds = new AtomicLong(0L);
    private boolean daemonThreads;
    private static final AtomicLong threadFactoryId = new AtomicLong(0L);

    public SequentiallyNamedThreadFactory(String name) {
        this(name, false);
    }

    public SequentiallyNamedThreadFactory(String name, boolean daemonThreads) {
        this.name = name + " (" + threadFactoryId.incrementAndGet();
        this.daemonThreads = daemonThreads;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setName(this.name + "-" + this.threadIds.incrementAndGet() + ")");
        t.setDaemon(this.daemonThreads);
        return t;
    }
}

